/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.ui.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.wizard.renderer.IRenderPage;
import com.elixirtech.wizard.renderer.RenderDetailsUtil;
import com.elixirtech.wizard.renderer.RendererWizard;
import javax.swing.JCheckBox;

public class HTMLPage
extends RelativeLayoutWizardPage
implements IRenderPage {
    private static final String SKIP_HEADERS = "SkipHeaders";
    private RawReport m_Report;
    private JCheckBox m_SkipHeaders;

    public HTMLPage() {
        super("HTML", null);
    }

    @Override
    public String getMimeType() {
        return "text/html";
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Report = ((RendererWizard)iWizard).getReport();
        this.m_SkipHeaders = SwingFactory.newCheckBox("skip");
        boolean bl = false;
        RenderDetails renderDetails = this.m_Report.getRenderDetails("text/html");
        if (renderDetails != null) {
            bl = renderDetails.isSet(SKIP_HEADERS);
        }
        this.m_SkipHeaders.setSelected(bl);
        this.m_Component.add(this.m_SkipHeaders);
        this.stickTop("skip");
        this.stickLeft("skip");
        I18N.REPORT_UI_MAP.injectObject(null, this, "HTMLPage");
        I18N.REPORT_UI_MAP.injectComponents("HTMLPage.", this.m_Component);
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        RenderDetails renderDetails = this.m_Report.getRenderDetails("text/html");
        if (renderDetails == null) {
            renderDetails = new RenderDetails();
            renderDetails.setMimeType("text/html");
            this.m_Report.addRenderDetails(renderDetails);
        }
        boolean bl = false;
        if (bl |= RenderDetailsUtil.setRenderDetails(renderDetails, SKIP_HEADERS, this.m_SkipHeaders.isSelected() ? "Yes" : "No")) {
            this.m_Report.setDirty(true);
        }
    }
}

