/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.ui.I18N;
import com.elixirtech.ui.JColorChooserEx;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.renderer.IRenderPage;
import com.elixirtech.wizard.renderer.RenderDetailsUtil;
import com.elixirtech.wizard.renderer.RendererWizard;
import java.awt.Color;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class HTMLZipPage
extends RelativeLayoutWizardPage
implements IRenderPage {
    private static final String MIME_TYPE = "application/x-html-zip";
    private static final String STREAMED = "Streamed";
    private static final String SECTIONED = "Sectioned";
    private static final String PAGED = "Paged";
    private static final String TREE = "Tree";
    private static final String SVG_PASSTHROUGH = "SVGPassThrough";
    private static final String SKIP_HEADERS = "SkipHeaders";
    private static final String TREE_HIGHLIGHT_COLOR = "TreeHighlightColor";
    private static final String TREE_NORMAL_COLOR = "TreeNormalColor";
    private RawReport m_Report;
    private JRadioButton m_Streamed;
    private JRadioButton m_Sectioned;
    private JRadioButton m_Paged;
    private JRadioButton m_Tree;
    private JCheckBox m_SVGPassThrough;
    private JCheckBox m_SkipHeaders;
    private JTextField m_HighlightBackground;
    private JTextField m_NormalBackground;

    public HTMLZipPage() {
        super("HTML-Zip", null);
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Report = ((RendererWizard)iWizard).getReport();
        CodeBlock codeBlock = new CodeBlock((Object)this, "checkEnabled");
        this.m_Streamed = SwingFactory.newRadioButton("streamed");
        this.m_Streamed.addItemListener(codeBlock);
        this.m_Sectioned = SwingFactory.newRadioButton("sectioned");
        this.m_Sectioned.addItemListener(codeBlock);
        this.m_Paged = SwingFactory.newRadioButton("paged");
        this.m_Paged.addItemListener(codeBlock);
        this.m_Tree = SwingFactory.newRadioButton("tree");
        this.m_Tree.addItemListener(codeBlock);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_Streamed);
        buttonGroup.add(this.m_Sectioned);
        buttonGroup.add(this.m_Paged);
        buttonGroup.add(this.m_Tree);
        this.m_SVGPassThrough = SwingFactory.newCheckBox("svg");
        this.m_SkipHeaders = SwingFactory.newCheckBox("skip");
        this.m_HighlightBackground = SwingFactory.newTextField("highlight");
        this.m_NormalBackground = SwingFactory.newTextField("normal");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string = null;
        String string2 = null;
        RenderDetails renderDetails = this.m_Report.getRenderDetails(MIME_TYPE);
        if (renderDetails != null) {
            bl = renderDetails.isSet(STREAMED);
            bl2 = renderDetails.isSet(SECTIONED);
            bl3 = renderDetails.isSet(PAGED);
            bl4 = renderDetails.isSet(TREE);
            bl5 = renderDetails.isSet(SVG_PASSTHROUGH);
            bl6 = renderDetails.isSet(SKIP_HEADERS);
            string = renderDetails.getParameterValue(TREE_HIGHLIGHT_COLOR);
            string2 = renderDetails.getParameterValue(TREE_NORMAL_COLOR);
            if (string == null) {
                string = "aqua";
            }
            if (string2 == null) {
                string2 = "white";
            }
        }
        this.m_Streamed.setSelected(bl);
        this.m_Sectioned.setSelected(bl2);
        this.m_Paged.setSelected(bl3);
        this.m_Tree.setSelected(bl4);
        this.m_SVGPassThrough.setSelected(bl5);
        this.m_SkipHeaders.setSelected(bl6);
        this.m_HighlightBackground.setText(string);
        this.m_NormalBackground.setText(string2);
        this.checkEnabled();
        this.m_Component.add(this.m_Streamed);
        this.m_Component.add(this.m_Sectioned);
        this.m_Component.add(this.m_Paged);
        this.m_Component.add(this.m_Tree);
        this.m_Component.add(this.m_SVGPassThrough);
        this.m_Component.add(this.m_SkipHeaders);
        this.m_Component.add(this.m_HighlightBackground);
        this.m_Component.add(SwingFactory.newLabel("highlight-label"));
        this.m_Component.add(SwingFactory.newDotsButton("highlight-dots", new CodeBlock((Object)this, "setHighlight")));
        this.m_Component.add(this.m_NormalBackground);
        this.m_Component.add(SwingFactory.newLabel("normal-label"));
        this.m_Component.add(SwingFactory.newDotsButton("normal-dots", new CodeBlock((Object)this, "setNormal")));
        this.stickTop("streamed");
        this.stickLeft("streamed");
        this.alignBelow("sectioned", "streamed");
        this.alignBelow("paged", "sectioned");
        this.alignBelow("tree", "paged");
        this.alignBelow("svg", "tree", 5);
        this.alignBelow("skip", "svg", 5);
        this.stickLeft("highlight-label");
        this.vCenter("highlight-label", "highlight");
        this.vCenter("highlight-dots", "highlight");
        this.setHeight("highlight-dots", "highlight");
        this.stickRight("highlight-dots");
        this.putLeft("highlight", "highlight-dots");
        this.putRight("highlight", "highlight-label,normal-label", 10);
        this.putBelow("highlight", "skip", 5);
        this.alignBelow("normal", "highlight");
        this.stickLeft("normal-label");
        this.vCenter("normal-label", "normal");
        this.vCenter("normal-dots", "normal");
        this.setHeight("normal-dots", "normal");
        this.stickRight("normal-dots");
        this.putLeft("normal", "normal-dots");
        I18N.REPORT_UI_MAP.injectComponents("HTMLZipPage.", this.m_Component);
        I18N.REPORT_UI_MAP.injectObject(null, this, "HTMLZipPage");
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    public void setHighlight() {
        Color color = StandardColor.lookup(this.m_HighlightBackground.getText());
        Color color2 = JColorChooserEx.showDialog(this.m_Component, color);
        this.m_HighlightBackground.setText(StandardColor.getColorName(color2));
    }

    public void setNormal() {
        Color color = StandardColor.lookup(this.m_NormalBackground.getText());
        Color color2 = JColorChooserEx.showDialog(this.m_Component, color);
        this.m_NormalBackground.setText(StandardColor.getColorName(color2));
    }

    @Override
    public void doFinish() {
        RenderDetails renderDetails = this.m_Report.getRenderDetails(MIME_TYPE);
        if (renderDetails == null) {
            renderDetails = new RenderDetails();
            renderDetails.setMimeType(MIME_TYPE);
            this.m_Report.addRenderDetails(renderDetails);
        }
        boolean bl = false;
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, STREAMED, this.m_Streamed.isSelected() ? "Yes" : "No");
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, SECTIONED, this.m_Sectioned.isSelected() ? "Yes" : "No");
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, PAGED, this.m_Paged.isSelected() ? "Yes" : "No");
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, TREE, this.m_Tree.isSelected() ? "Yes" : "No");
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, SVG_PASSTHROUGH, this.m_SVGPassThrough.isSelected() ? "Yes" : "No");
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, SKIP_HEADERS, this.m_SkipHeaders.isSelected() ? "Yes" : "No");
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, TREE_HIGHLIGHT_COLOR, this.m_HighlightBackground.getText());
        if (bl |= RenderDetailsUtil.setRenderDetails(renderDetails, TREE_NORMAL_COLOR, this.m_NormalBackground.getText())) {
            this.m_Report.setDirty(true);
        }
    }

    public void checkEnabled() {
        boolean bl = this.m_Tree.isSelected();
        this.m_HighlightBackground.setEnabled(bl);
        this.m_NormalBackground.setEnabled(bl);
    }
}

