/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.mime.MIMETypes;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.renderer.IRenderPage;
import com.elixirtech.wizard.renderer.RenderDetailsUtil;
import com.elixirtech.wizard.renderer.RendererWizard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class ImagePage
extends RelativeLayoutWizardPage
implements IRenderPage {
    private static final String[] COLOUR_CHOICE = new String[]{"Image.Colour", "Image.Greyscale"};
    private JComboBox m_MimeTypes;
    private RawReport m_Report;
    private JCheckBox m_Tree;
    private JComboBox m_Mode;
    private JTextField m_DPI;
    private static String m_MimeType = "application/x-png-zip";
    private static final String[] MIME_TYPES = new String[]{"application/x-jpeg-zip", "application/x-png-zip", "application/x-tiff-zip", "application/x-bmp-zip", "application/x-wbmp-zip"};

    public ImagePage() {
        super("Image", null);
    }

    @Override
    public String getMimeType() {
        return m_MimeType;
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Report = ((RendererWizard)iWizard).getReport();
        Object[] objectArray = this.getSupportedMimeTypes();
        this.m_MimeTypes = SwingFactory.newComboBox("mime", objectArray);
        this.m_MimeTypes.setSelectedItem(m_MimeType);
        this.m_MimeTypes.addItemListener(new CodeBlock((Object)this, "mimeChanged"));
        this.m_Tree = SwingFactory.newCheckBox("tree");
        this.m_Mode = SwingFactory.newComboBox("mode", I18NUtil.getStrings(I18N.ERD, COLOUR_CHOICE));
        this.m_DPI = SwingFactory.newTextField("dpi");
        this.loadMimeValues();
        this.m_Component.add(this.m_MimeTypes);
        this.m_Component.add(SwingFactory.newLabel("mime-label"));
        this.m_Component.add(this.m_Tree);
        this.m_Component.add(SwingFactory.newLabel("mode-label"));
        this.m_Component.add(this.m_Mode);
        this.m_Component.add(SwingFactory.newLabel("dpi-label"));
        this.m_Component.add(this.m_DPI);
        this.stickLeft("mime-label");
        this.vCenter("mime-label", "mime");
        this.stickLeft("mode-label");
        this.vCenter("mode-label", "mode");
        this.stickLeft("dpi-label");
        this.vCenter("dpi-label", "dpi");
        this.stickTop("mime");
        this.putRight("mime", "mime-label,mode-label,dpi-label", 10);
        this.alignBelow("mode", "mime", 5);
        this.alignBelow("dpi", "mode", 2);
        this.setWidth("dpi", "mode");
        this.putBelow("tree", "dpi", 2);
        this.stickLeft("tree");
        com.elixirtech.report2.ui.I18N.REPORT_UI_MAP.injectObject(null, this, "ImagePage");
        com.elixirtech.report2.ui.I18N.REPORT_UI_MAP.injectComponents("ImagePage.", this.m_Component);
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        this.saveMimeValues();
    }

    public void mimeChanged() {
        this.saveMimeValues();
        m_MimeType = (String)this.m_MimeTypes.getSelectedItem();
        this.loadMimeValues();
    }

    protected void saveMimeValues() {
        RenderDetails renderDetails = this.m_Report.getRenderDetails(m_MimeType);
        if (renderDetails == null) {
            renderDetails = new RenderDetails();
            renderDetails.setMimeType(m_MimeType);
            this.m_Report.addRenderDetails(renderDetails);
        }
        boolean bl = false;
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Greyscale", this.m_Mode.getSelectedIndex() == 1 ? "Yes" : "No");
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "DPI", this.m_DPI.getText());
        if (bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Tree", this.m_Tree.isSelected() ? "Yes" : "No")) {
            this.m_Report.setDirty(true);
        }
    }

    protected void loadMimeValues() {
        boolean bl = false;
        boolean bl2 = false;
        int n = 72;
        RenderDetails renderDetails = this.m_Report.getRenderDetails(m_MimeType);
        if (renderDetails != null) {
            bl = renderDetails.isSet("Tree");
            bl2 = renderDetails.isSet("Greyscale");
            try {
                n = Integer.parseInt(renderDetails.getParameterValue("DPI"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_Tree.setSelected(bl);
        if (bl2) {
            this.m_Mode.setSelectedIndex(1);
        }
        this.m_DPI.setText(String.valueOf(n));
    }

    protected String[] getSupportedMimeTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : MIME_TYPES) {
            String string2 = MIMETypes.getContents(string);
            hashMap.put(string2, string);
        }
        ArrayList arrayList = new ArrayList();
        for (String string2 : ImageIO.getWriterMIMETypes()) {
            if (!hashMap.containsKey(string2)) continue;
            arrayList.add((String)hashMap.get(string2));
        }
        Collections.sort(arrayList);
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }
}

