/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.i18n.I18NBypass;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.ui.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.TitledBorder;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.wizard.renderer.IRenderPage;
import com.elixirtech.wizard.renderer.RendererWizard;
import java.awt.BorderLayout;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class InteractivePage
extends RelativeLayoutWizardPage
implements IFinishPage,
IRenderPage {
    private static final String READ_ONLY = "ReadOnly";
    private static final String ALLOW_PREFIX = "Allow_";
    private RawReport m_Report;
    private JCheckBox m_ReadOnly;
    private JPanel m_ParamPanel;
    private JCheckBox[] m_Params;

    public InteractivePage() {
        super("IML", null);
    }

    @Override
    public String getMimeType() {
        return "application/x-rml-interactive";
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Report = ((RendererWizard)iWizard).getReport();
        this.m_ReadOnly = SwingFactory.newCheckBox("read-only");
        this.m_ParamPanel = new JPanel();
        this.m_ParamPanel.setLayout(new BoxLayout(this.m_ParamPanel, 1));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder(new JLabel(I18N.REPORT_UI.getString("InteractivePage.interactive-parameter"))));
        jPanel.add(new JScrollPane(this.m_ParamPanel));
        this.m_Component.add("read-only", this.m_ReadOnly);
        this.m_Component.add("params", jPanel);
        this.m_Layout.stickLeft("read-only");
        this.m_Layout.stickTop("read-only");
        this.m_Layout.putBelow("params", "read-only", 5);
        this.m_Layout.stickLeft("params");
        this.m_Layout.stickRight("params");
        this.m_Layout.stickBottom("params");
        this.populateParams();
        RenderDetails renderDetails = this.m_Report.getRenderDetails("application/x-rml-interactive");
        if (renderDetails != null) {
            this.m_ReadOnly.setSelected("Yes".equals(renderDetails.getParameterValue(READ_ONLY)));
            for (int i = 0; i < this.m_Params.length; ++i) {
                String string = this.m_Params[i].getName();
                this.m_Params[i].setSelected(renderDetails.isSet(ALLOW_PREFIX + string));
            }
        }
        I18N.REPORT_UI_MAP.injectObject(null, this, "InteractivePage");
        I18N.REPORT_UI_MAP.injectComponents("InteractivePage.", this.m_Component);
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        RenderDetails renderDetails = new RenderDetails();
        renderDetails.setMimeType("application/x-rml-interactive");
        renderDetails.setParameterValue(READ_ONLY, this.m_ReadOnly.isSelected() ? "Yes" : "No");
        for (int i = 0; i < this.m_Params.length; ++i) {
            if (!this.m_Params[i].isSelected()) continue;
            String string = this.m_Params[i].getName();
            renderDetails.setParameterValue(ALLOW_PREFIX + string, "Yes");
        }
        this.m_Report.addRenderDetails(renderDetails);
        this.m_Report.setDirty(true);
    }

    protected void populateParams() {
        int n = this.m_Report.getParameterCount();
        this.m_Params = new JCheckBox[n];
        for (int i = 0; i < n; ++i) {
            String string = this.m_Report.getParameter(i).getKey();
            this.m_Params[i] = I18NBypass.newCheckBox(string);
            this.m_Params[i].setName(string);
            this.m_ParamPanel.add(this.m_Params[i]);
        }
    }
}

