/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.ui.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.UnitField;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.wizard.renderer.IRenderPage;
import com.elixirtech.wizard.renderer.RenderDetailsUtil;
import com.elixirtech.wizard.renderer.RendererWizard;

public class LPTPage
extends RelativeLayoutWizardPage
implements IRenderPage {
    private RawReport m_Report;
    private UnitField m_CharWidth;
    private UnitField m_CharHeight;

    public LPTPage() {
        super("LPT", null);
    }

    @Override
    public String getMimeType() {
        return "text/x-lpt";
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Report = ((RendererWizard)iWizard).getReport();
        int n = 150;
        int n2 = 300;
        RenderDetails renderDetails = this.m_Report.getRenderDetails("text/x-lpt");
        if (renderDetails != null) {
            Parameter parameter;
            Parameter parameter2 = renderDetails.getParameter("CharacterWidth");
            if (parameter2 != null) {
                try {
                    n = Integer.parseInt(parameter2.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((parameter = renderDetails.getParameter("CharacterHeight")) != null) {
                try {
                    n2 = Integer.parseInt(parameter.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.m_CharWidth = UnitField.newUnitField("cw");
        this.m_CharWidth.setValue(n);
        this.m_CharHeight = UnitField.newUnitField("ch");
        this.m_CharHeight.setValue(n2);
        this.m_Component.add(SwingFactory.newLabel("cw-label"));
        this.m_Component.add(this.m_CharWidth);
        this.m_Component.add(SwingFactory.newLabel("ch-label"));
        this.m_Component.add("ch", this.m_CharHeight);
        this.stickTop("cw");
        this.stickLeft("cw-label");
        this.vCenter("cw-label", "cw");
        this.stickRight("cw");
        this.putRight("cw", "cw-label,ch-label", 10);
        this.stickLeft("ch-label");
        this.vCenter("ch-label", "ch");
        this.alignBelow("ch", "cw");
        this.stickRight("ch");
        I18N.REPORT_UI_MAP.injectObject(null, this, "LPTPage");
        I18N.REPORT_UI_MAP.injectComponents("LPTPage.", this.m_Component);
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        RenderDetails renderDetails = this.m_Report.getRenderDetails("text/x-lpt");
        if (renderDetails == null) {
            renderDetails = new RenderDetails();
            renderDetails.setMimeType("text/x-lpt");
            this.m_Report.addRenderDetails(renderDetails);
        }
        boolean bl = false;
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "CharacterWidth", String.valueOf(this.m_CharWidth.getValue()));
        if (bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "CharacterHeight", String.valueOf(this.m_CharHeight.getValue()))) {
            this.m_Report.setDirty(true);
        }
    }
}

