/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.ui.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.UnitField;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.renderer.IRenderPage;
import com.elixirtech.wizard.renderer.RenderDetailsUtil;
import com.elixirtech.wizard.renderer.RendererWizard;
import java.awt.Dimension;

public class PCLPage
extends RelativeLayoutWizardPage
implements IRenderPage {
    private RawReport m_Report;
    private UnitField m_OffsetX;
    private UnitField m_OffsetY;
    private I18NComboBox m_Sides;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PCLPage.class);
    private static final String[] SIDES_IDS = new String[]{"OneSided", "TwoSidedLongEdge", "TwoSidedShortEdge"};
    private static final String[] SIDES_KEYS = new String[]{"PCL.OneSided", "PCL.TwoSidedLongEdge", "PCL.TwoSidedShortEdge"};

    public PCLPage() {
        super("PCL", null);
    }

    @Override
    public String getMimeType() {
        return "application/vnd.hp-pcl";
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Report = ((RendererWizard)iWizard).getReport();
        this.addLabel(SwingFactory.newLabel("offsetX-label"));
        this.m_OffsetX = UnitField.newUnitField("offsetX");
        Dimension dimension = this.m_OffsetX.getPreferredSize();
        dimension.width *= 2;
        this.m_OffsetX.setPreferredSize(dimension);
        this.m_Component.add(this.m_OffsetX);
        this.addLabel(SwingFactory.newLabel("offsetY-label"));
        this.m_OffsetY = UnitField.newUnitField("offsetY");
        this.m_OffsetY.setPreferredSize(dimension);
        this.m_Component.add(this.m_OffsetY);
        this.addLabel(SwingFactory.newLabel("sides-label"));
        Name[] nameArray = I18NComboBox.buildNames(SIDES_IDS, I18N.REPORT_UI, SIDES_KEYS);
        this.m_Sides = SwingFactory.newI18NComboBox("sides", nameArray);
        this.m_Component.add(this.m_Sides);
        this.stickTop("offsetX");
        this.putRight("offsetX", "offsetX-label,offsetY-label,sides-label", 10);
        this.alignBelow("offsetY", "offsetX");
        this.alignBelow("sides", "offsetY");
        RenderDetails renderDetails = this.m_Report.getRenderDetails("application/vnd.hp-pcl");
        if (renderDetails != null) {
            String string = renderDetails.getParameterValue("OffsetX");
            String string2 = renderDetails.getParameterValue("OffsetY");
            try {
                if (StringUtil.notEmpty(string)) {
                    this.m_OffsetX.setValue(Integer.valueOf(string));
                }
                if (StringUtil.notEmpty(string2)) {
                    this.m_OffsetY.setValue(Integer.valueOf(string2));
                }
            }
            catch (NumberFormatException numberFormatException) {
                m_Log.warn((Object)"Can't process PCL offset as int");
            }
            String string3 = renderDetails.getParameterValue("Sides");
            if (StringUtil.notEmpty(string3)) {
                this.m_Sides.setSelectedId(string3);
            } else {
                this.m_Sides.setSelectedId(SIDES_IDS[0]);
            }
        }
        I18N.REPORT_UI_MAP.injectObject(null, this, "PCLPage");
        I18N.REPORT_UI_MAP.injectComponents("PCLPage.", this.m_Component);
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        RenderDetails renderDetails = this.m_Report.getRenderDetails("application/vnd.hp-pcl");
        if (renderDetails == null) {
            renderDetails = new RenderDetails();
            renderDetails.setMimeType("application/vnd.hp-pcl");
            this.m_Report.addRenderDetails(renderDetails);
        }
        String string = String.valueOf(this.m_OffsetX.getValue());
        String string2 = String.valueOf(this.m_OffsetY.getValue());
        String string3 = this.m_Sides.getSelectedId();
        boolean bl = false;
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "OffsetX", string);
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "OffsetY", string2);
        if (bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Sides", string3)) {
            this.m_Report.setDirty(true);
        }
    }
}

