/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.TitledBorder;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.renderer.IRenderPage;
import com.elixirtech.wizard.renderer.PDFPage2;
import com.elixirtech.wizard.renderer.RenderDetailsUtil;
import com.elixirtech.wizard.renderer.RendererWizard;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class PDFPage
extends RelativeLayoutWizardPage
implements IRenderPage {
    private static final String RENDER_TEXT_API = "RenderTextAPI";
    private static final String BLANK_PAGE_ON_EMPTY = "BlankPageOnEmptyFile";
    public static final String NAME = "PDF";
    private RawReport m_Report;
    private JCheckBox m_RenderTextAPI;
    private JCheckBox m_BlankPageOnEmptyFile;
    private AsImagePanel m_AsImagePanel;
    private EncryptionPanel m_EncryptionPanel;
    private FlagsPanel m_FlagsPanel;
    private static final String[] ENCRYPT_KEYS = new String[]{"Encrypt.128", "Encrypt.40"};
    private static final String[] ENCRYPT_IDS = new String[]{"128 bits", "40 bits"};

    public PDFPage() {
        super(NAME, "PDF2");
    }

    @Override
    public String getMimeType() {
        return "application/pdf";
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Report = ((RendererWizard)iWizard).getReport();
        this.m_RenderTextAPI = SwingFactory.newCheckBox("glyph");
        this.m_BlankPageOnEmptyFile = SwingFactory.newCheckBox("blank");
        this.m_AsImagePanel = new AsImagePanel();
        this.m_EncryptionPanel = new EncryptionPanel();
        this.m_FlagsPanel = new FlagsPanel();
        this.m_Component.add(this.m_RenderTextAPI);
        this.m_Component.add(this.m_BlankPageOnEmptyFile);
        this.m_Component.add(this.m_AsImagePanel);
        this.m_Component.add(this.m_EncryptionPanel);
        this.m_Component.add(this.m_FlagsPanel);
        this.stickTop("glyph");
        this.stickLeft("glyph");
        this.putBelow("blank", "glyph");
        this.stickLeft("blank");
        this.putBelow("as-image-panel", "blank");
        this.stickLeft("as-image-panel");
        this.putLeft("as-image-panel", "flags-panel", -10);
        this.stickTop("flags-panel");
        this.stickRight("flags-panel");
        this.putBelow("encryption-panel", "as-image-panel", 10);
        this.stickLeft("encryption-panel");
        this.setWidth("encryption-panel", "as-image-panel");
        RenderDetails renderDetails = this.m_Report.getRenderDetails("application/pdf");
        if (renderDetails != null) {
            this.m_RenderTextAPI.setSelected(renderDetails.isSet(RENDER_TEXT_API));
            this.m_BlankPageOnEmptyFile.setSelected(renderDetails.isSet(BLANK_PAGE_ON_EMPTY));
        } else {
            Package package_ = Package.getPackage("java.util.concurrent");
            if (package_ != null) {
                this.m_RenderTextAPI.setSelected(true);
            }
        }
        com.elixirtech.report2.ui.I18N.REPORT_UI_MAP.injectObject(null, this, "PDFPage");
        com.elixirtech.report2.ui.I18N.REPORT_UI_MAP.injectComponents("PDFPage.", this.m_Component);
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        RenderDetails renderDetails = this.m_Report.getRenderDetails("application/pdf");
        if (renderDetails == null) {
            renderDetails = new RenderDetails();
            renderDetails.setMimeType("application/pdf");
            this.m_Report.addRenderDetails(renderDetails);
        }
        boolean bl = false;
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, RENDER_TEXT_API, this.m_RenderTextAPI.isSelected() ? "Yes" : "No");
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, BLANK_PAGE_ON_EMPTY, this.m_BlankPageOnEmptyFile.isSelected() ? "Yes" : "No");
        bl |= this.m_AsImagePanel.performFinish(renderDetails);
        bl |= this.m_EncryptionPanel.performFinish(renderDetails);
        bl |= this.m_FlagsPanel.performFinish(renderDetails);
        PDFPage2 pDFPage2 = (PDFPage2)this.m_Wizard.getPage("PDF2");
        if (bl |= pDFPage2.performFinish(renderDetails)) {
            this.m_Report.setDirty(true);
        }
    }

    protected Border buildTitledBorder(String string) {
        JLabel jLabel = SwingFactory.newLabel(string);
        com.elixirtech.report2.ui.I18N.REPORT_UI_MAP.injectComponents("PDFPage.", jLabel);
        return new TitledBorder(jLabel);
    }

    public class AsImagePanel
    extends JPanel {
        private ArchLayout m_MyLayout;
        private JCheckBox m_RenderAsImage;
        private JTextField m_RenderAsImageDPI;
        private JCheckBox m_Greyscale;

        public AsImagePanel() {
            this.setName("as-image-panel");
            this.m_MyLayout = new ArchLayout();
            this.setLayout(this.m_MyLayout);
            this.setBorder(PDFPage.this.buildTitledBorder("border-format"));
            this.m_RenderAsImage = SwingFactory.newCheckBox("as-image");
            this.m_RenderAsImage.addItemListener(new CodeBlock((Object)this, "checkEnabled"));
            this.m_RenderAsImageDPI = SwingFactory.newTextField("dpi", 5);
            this.m_Greyscale = SwingFactory.newCheckBox("grey");
            this.add(this.m_RenderAsImage);
            this.add(SwingFactory.newLabel("label"));
            this.add(this.m_RenderAsImageDPI);
            this.add(this.m_Greyscale);
            this.m_MyLayout.stickTop("as-image");
            this.m_MyLayout.stickLeft("as-image");
            this.m_MyLayout.vCenter("label", "dpi");
            this.m_MyLayout.stickLeft("label");
            this.m_MyLayout.putBelow("dpi", "as-image");
            this.m_MyLayout.putRight("dpi", "label", 10);
            this.m_MyLayout.vCenter("grey", "as-image");
            this.m_MyLayout.putRight("grey", "as-image", 10);
            RenderDetails renderDetails = PDFPage.this.m_Report.getRenderDetails("application/pdf");
            if (renderDetails != null) {
                this.m_RenderAsImage.setSelected(renderDetails.isSet("RenderAsImage"));
                this.m_RenderAsImageDPI.setText(renderDetails.getParameterValue("RenderAsImageDPI"));
                this.m_Greyscale.setSelected(renderDetails.isSet("Greyscale"));
            }
            this.checkEnabled();
        }

        public void checkEnabled() {
            boolean bl = this.m_RenderAsImage.isSelected();
            this.m_Greyscale.setEnabled(bl);
        }

        protected boolean performFinish(RenderDetails renderDetails) {
            boolean bl = false;
            bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "RenderAsImage", this.m_RenderAsImage.isSelected() ? "Yes" : "No");
            bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "RenderAsImageDPI", this.m_RenderAsImageDPI.getText());
            return bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Greyscale", this.m_Greyscale.isSelected() ? "Yes" : "No");
        }
    }

    private class EncryptionPanel
    extends JPanel {
        private ArchLayout m_MyLayout;
        private JCheckBox m_Encryption;
        private JTextField m_OwnerPassword;
        private JTextField m_UserPassword;
        private I18NComboBox m_EncryptionStrength;

        public EncryptionPanel() {
            this.setName("encryption-panel");
            this.m_MyLayout = new ArchLayout();
            this.setLayout(this.m_MyLayout);
            this.setBorder(PDFPage.this.buildTitledBorder("border-encryption"));
            this.m_Encryption = SwingFactory.newCheckBox("encryption");
            this.m_OwnerPassword = SwingFactory.newTextField("owner");
            this.m_UserPassword = SwingFactory.newTextField("user");
            this.m_EncryptionStrength = SwingFactory.newI18NComboBox("encrypt", I18NComboBox.buildNames(ENCRYPT_IDS, I18N.ERD, ENCRYPT_KEYS));
            this.add(this.m_Encryption);
            this.add(SwingFactory.newLabel("owner-label"));
            this.add(this.m_OwnerPassword);
            this.add(SwingFactory.newLabel("user-label"));
            this.add(this.m_UserPassword);
            this.add(SwingFactory.newLabel("encrypt-label"));
            this.add(this.m_EncryptionStrength);
            this.m_MyLayout.stickLeft("owner-label");
            this.m_MyLayout.vCenter("owner-label", "owner");
            this.m_MyLayout.stickLeft("user-label");
            this.m_MyLayout.vCenter("user-label", "user");
            this.m_MyLayout.stickLeft("encrypt-label");
            this.m_MyLayout.vCenter("encrypt-label", "encrypt");
            this.m_MyLayout.stickTop("encryption");
            this.m_MyLayout.stickLeft("encryption");
            this.m_MyLayout.putRight("owner", "owner-label,user-label,encrypt-label", 10);
            this.m_MyLayout.putBelow("owner", "encryption");
            this.m_MyLayout.alignBelow("user", "owner");
            this.m_MyLayout.alignBelow("encrypt", "user");
            this.m_MyLayout.stickRight("owner");
            this.m_MyLayout.stickRight("user");
            this.m_MyLayout.stickRight("encrypt");
            RenderDetails renderDetails = PDFPage.this.m_Report.getRenderDetails("application/pdf");
            if (renderDetails != null) {
                Parameter parameter;
                Parameter parameter2;
                Parameter parameter3;
                Parameter parameter4 = renderDetails.getParameter("Encryption");
                if (parameter4 != null) {
                    this.m_Encryption.setSelected("Yes".equals(parameter4.getValue()));
                }
                if ((parameter3 = renderDetails.getParameter("OwnerPassword")) != null) {
                    this.m_OwnerPassword.setText(parameter3.getValue());
                }
                if ((parameter2 = renderDetails.getParameter("UserPassword")) != null) {
                    this.m_UserPassword.setText(parameter2.getValue());
                }
                if ((parameter = renderDetails.getParameter("EncryptionStrength")) != null) {
                    this.m_EncryptionStrength.setSelectedId(parameter.getValue());
                }
            }
        }

        protected boolean performFinish(RenderDetails renderDetails) {
            boolean bl = false;
            bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Encryption", this.m_Encryption.isSelected() ? "Yes" : "No");
            bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "OwnerPassword", this.m_OwnerPassword.getText());
            bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "UserPassword", this.m_UserPassword.getText());
            return bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "EncryptionStrength", this.m_EncryptionStrength.getSelectedId());
        }
    }

    private class FlagsPanel
    extends JPanel {
        private JCheckBox m_AllowModifyContents;
        private JCheckBox m_AllowPrinting;
        private JCheckBox m_AllowCopy;
        private JCheckBox m_AllowModifyAnnotations;
        private JCheckBox m_AllowFillIn;
        private JCheckBox m_AllowScreenReaders;
        private JCheckBox m_AllowAssembly;
        private JCheckBox m_AllowDegradedPrinting;

        public FlagsPanel() {
            this.setName("flags-panel");
            this.setLayout(new GridLayout(8, 1));
            this.setBorder(PDFPage.this.buildTitledBorder("border-flags"));
            this.m_AllowModifyContents = SwingFactory.newCheckBox("flags-modify-contents");
            this.m_AllowPrinting = SwingFactory.newCheckBox("flags-printing");
            this.m_AllowCopy = SwingFactory.newCheckBox("flags-copy");
            this.m_AllowModifyAnnotations = SwingFactory.newCheckBox("flags-modify-annotations");
            this.m_AllowFillIn = SwingFactory.newCheckBox("flags-fill-in");
            this.m_AllowScreenReaders = SwingFactory.newCheckBox("flags-screen-readers");
            this.m_AllowAssembly = SwingFactory.newCheckBox("flags-assembly");
            this.m_AllowDegradedPrinting = SwingFactory.newCheckBox("flags-degraded-printing");
            this.add(this.m_AllowModifyContents);
            this.add(this.m_AllowPrinting);
            this.add(this.m_AllowCopy);
            this.add(this.m_AllowModifyAnnotations);
            this.add(this.m_AllowFillIn);
            this.add(this.m_AllowScreenReaders);
            this.add(this.m_AllowAssembly);
            this.add(this.m_AllowDegradedPrinting);
            RenderDetails renderDetails = PDFPage.this.m_Report.getRenderDetails("application/pdf");
            if (renderDetails != null) {
                this.getParameter(renderDetails, "AllowModifyContents", this.m_AllowModifyContents);
                this.getParameter(renderDetails, "AllowPrinting", this.m_AllowPrinting);
                this.getParameter(renderDetails, "AllowCopy", this.m_AllowCopy);
                this.getParameter(renderDetails, "AllowModifyAnnotations", this.m_AllowModifyAnnotations);
                this.getParameter(renderDetails, "AllowFillIn", this.m_AllowFillIn);
                this.getParameter(renderDetails, "AllowScreenReaders", this.m_AllowScreenReaders);
                this.getParameter(renderDetails, "AllowAssembly", this.m_AllowAssembly);
                this.getParameter(renderDetails, "AllowDegradedPrinting", this.m_AllowDegradedPrinting);
            }
        }

        protected boolean performFinish(RenderDetails renderDetails) {
            boolean bl = false;
            bl |= this.setParameter(renderDetails, "AllowModifyContents", this.m_AllowModifyContents);
            bl |= this.setParameter(renderDetails, "AllowPrinting", this.m_AllowPrinting);
            bl |= this.setParameter(renderDetails, "AllowCopy", this.m_AllowCopy);
            bl |= this.setParameter(renderDetails, "AllowModifyAnnotations", this.m_AllowModifyAnnotations);
            bl |= this.setParameter(renderDetails, "AllowFillIn", this.m_AllowFillIn);
            bl |= this.setParameter(renderDetails, "AllowScreenReaders", this.m_AllowScreenReaders);
            bl |= this.setParameter(renderDetails, "AllowAssembly", this.m_AllowAssembly);
            return bl |= this.setParameter(renderDetails, "AllowDegradedPrinting", this.m_AllowDegradedPrinting);
        }

        private void getParameter(RenderDetails renderDetails, String string, JCheckBox jCheckBox) {
            jCheckBox.setSelected(renderDetails.isSet(string));
        }

        private boolean setParameter(RenderDetails renderDetails, String string, JCheckBox jCheckBox) {
            return RenderDetailsUtil.setRenderDetails(renderDetails, string, jCheckBox.isSelected() ? "Yes" : "No");
        }
    }
}

