/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.RepositoryChooser;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.FileUtil;
import com.elixirtech.util.StringUtil;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import com.elixirtech.wizard.renderer.RenderDetailsUtil;
import com.elixirtech.wizard.renderer.RendererWizard;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;

public class PDFPage2
extends RelativeLayoutWizardPage
implements ActionListener {
    public static final String NAME = "PDF2";
    public static String CJK_MAPPING_URL = "CJKMappingURL";
    private RawReport m_Report;
    private JTextField m_CJKMapping;
    private JButton m_Preview;
    private JTable m_Table;
    private static final String[] COLUMNS = new String[]{"PDFPage.TemplateFont", "PDFPage.PDFFont"};
    private static final String[] COLUMNS_UI = I18NUtil.getStrings(I18N.ERD, COLUMNS);

    public PDFPage2() {
        super(NAME, null);
    }

    public String getMimeType() {
        return "application/pdf";
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Report = ((RendererWizard)iWizard).getReport();
        this.m_CJKMapping = SwingFactory.newTextField("cjk");
        this.m_CJKMapping.getDocument().addDocumentListener(new CodeBlock((Object)this, "checkEnabled"));
        JButton jButton = SwingFactory.newDotsButton("dots", this);
        jButton.setActionCommand("Dots");
        this.m_Preview = SwingFactory.newButton("preview");
        this.m_Preview.setActionCommand("Preview");
        this.m_Preview.addActionListener(this);
        this.m_Table = SwingFactory.newTable();
        this.m_Component.add(SwingFactory.newLabel("label"));
        this.m_Component.add(this.m_CJKMapping);
        this.m_Component.add(jButton);
        this.m_Component.add(this.m_Preview);
        this.m_Component.add(SwingFactory.newScrollPane("table", this.m_Table));
        this.stickTop("cjk");
        this.stickLeft("label");
        this.putRight("cjk", "label", 10);
        this.putLeft("cjk", "dots");
        this.stickTop("dots");
        this.stickRight("dots");
        this.setHeight("dots", "cjk");
        this.vCenter("label", "cjk");
        this.putBelow("preview", "cjk", 5);
        this.hCenter("preview");
        this.putBelow("table", "preview", 5);
        this.stickLeft("table");
        this.stickRight("table");
        this.stickBottom("table");
        RenderDetails renderDetails = this.m_Report.getRenderDetails("application/pdf");
        if (renderDetails != null) {
            this.m_CJKMapping.setText(renderDetails.getParameterValue(CJK_MAPPING_URL));
        }
        this.checkEnabled();
        com.elixirtech.report2.ui.I18N.REPORT_UI_MAP.injectObject(null, this, "PDFPage2");
        com.elixirtech.report2.ui.I18N.REPORT_UI_MAP.injectComponents("PDFPage2.", this.m_Component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block7: {
            String string;
            block6: {
                string = actionEvent.getActionCommand();
                if (!"Dots".equals(string)) break block6;
                ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
                RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
                FileType fileType = repositoryExplorer.getFileTypeJ("text/plain");
                System.out.println("types: " + String.valueOf(repositoryExplorer.getFileTypesJ()));
                RepositoryChooser repositoryChooser = new RepositoryChooser((Frame)elixirFrame.getFrame(), com.elixirtech.report2.ui.I18N.REPORT_UI.getString("PDFPage2.choose-file"), fileType);
                repositoryChooser.setLocationRelativeTo(this.m_Component);
                elixirFrame.showModal(repositoryChooser);
                if (repositoryChooser.isOk()) {
                    this.m_CJKMapping.setText("repository:" + String.valueOf(repositoryChooser.getSelection().getPath()));
                }
                break block7;
            }
            if (!"Preview".equals(string)) break block7;
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            InputStream inputStream = null;
            try {
                String string2;
                inputStream = URLLoader.getInputStream((String)this.m_CJKMapping.getText().trim());
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).length() == 0 || string2.startsWith("#")) continue;
                    String[] stringArray = StringUtil.keyAndValue(string2);
                    arrayList.add(stringArray);
                }
            }
            catch (Exception exception) {
                try {
                    ElixirJ.error(I18N.ERD.getString("PDFPage2.error-preview") + String.valueOf(exception), exception);
                }
                catch (Throwable throwable) {
                    FileUtil.close(inputStream);
                    throw throwable;
                }
                FileUtil.close(inputStream);
            }
            FileUtil.close(inputStream);
            this.m_Table.setModel(new KVTableModel(arrayList));
        }
    }

    public void checkEnabled() {
        boolean bl = true;
        Repository repository = (Repository)Elixir.get(Repository.class);
        String string = this.m_CJKMapping.getText().trim();
        if (string.startsWith("repository:")) {
            FileObject fileObject = repository.getFileJ(string = string.substring(11));
            if (fileObject == null || fileObject.isFolder()) {
                bl = false;
            }
        } else {
            File file;
            bl = string.startsWith("file:") ? (file = new File(string = string.substring(5))).exists() && !file.isDirectory() : false;
        }
        this.m_Preview.setEnabled(bl);
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    public boolean performFinish(RenderDetails renderDetails) {
        boolean bl = false;
        return bl |= RenderDetailsUtil.setRenderDetails(renderDetails, CJK_MAPPING_URL, this.m_CJKMapping.getText().trim());
    }

    private static class KVTableModel
    extends AbstractTableModel {
        private List<String[]> m_List;

        public KVTableModel(List<String[]> list) {
            this.m_List = list;
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.length;
        }

        @Override
        public String getColumnName(int n) {
            return COLUMNS_UI[n];
        }

        @Override
        public int getRowCount() {
            return this.m_List.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String[] stringArray = this.m_List.get(n);
            return stringArray[n2];
        }
    }
}

