/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.report2.engine.PrinterUtil;
import com.elixirtech.report2.print.PrintAttribute;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.ui.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingWorker;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.WizardDialog;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.renderer.IRenderPage;
import com.elixirtech.wizard.renderer.RendererWizard;
import com.elixirtech.wizard.renderer.print.AttributeModel;
import com.elixirtech.wizard.renderer.print.PrintAttributeDialog;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.standard.PrinterName;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;

public class PrintPage
extends RelativeLayoutWizardPage
implements IRenderPage {
    private static final String DEFAULT = I18N.REPORT_UI.getString("PrintPage.DEFAULT");
    private static final String LOADING = I18N.REPORT_UI.getString("PrintPage.LOADING");
    private RawReport m_Report;
    private JList m_AttributesList;
    private JComboBox m_PrinterName;
    private JComboBox m_ScalePagesToFit;
    private JCheckBox m_ShowPrintDialog;
    private JButton m_Add;
    private JButton m_Edit;
    private JButton m_Remove;
    private AttributeModel m_Model;
    private List<String> m_PrinterNames;

    public PrintPage() {
        super("Print", null);
    }

    @Override
    public String getMimeType() {
        return "application/x-print";
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Report = ((RendererWizard)iWizard).getReport();
        RenderDetails renderDetails = this.m_Report.getRenderDetails("application/x-print");
        this.m_Model = new AttributeModel(renderDetails);
        this.m_AttributesList = SwingFactory.newList(this.m_Model);
        this.m_AttributesList.addListSelectionListener(new CodeBlock((Object)this, "selection"));
        this.m_PrinterName = SwingFactory.newComboBox("name", new String[]{LOADING});
        this.m_PrinterName.setEditable(true);
        String[] stringArray = PrinterUtil.getMediaSizeNameStrings();
        Object[] objectArray = new String[stringArray.length + 1];
        objectArray[0] = "Page Setup";
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i + 1] = stringArray[i];
        }
        this.m_ScalePagesToFit = SwingFactory.newComboBox("scale", objectArray);
        this.m_ShowPrintDialog = SwingFactory.newCheckBox("show");
        if (renderDetails != null) {
            String string = renderDetails.getParameterValue("PrinterName");
            if (StringUtil.isEmpty(string)) {
                string = DEFAULT;
            }
            this.m_PrinterName.setSelectedItem(string);
            String string2 = renderDetails.getParameterValue("Media");
            if (string2 != null) {
                this.m_ScalePagesToFit.setSelectedItem(string2);
            }
            this.m_ShowPrintDialog.setSelected(renderDetails.isSet("ShowPrintDialog"));
        }
        this.m_Add = SwingFactory.newButton("add", new CodeBlock((Object)this, "add"));
        this.m_Edit = SwingFactory.newButton("edit", new CodeBlock((Object)this, "edit"));
        this.m_Remove = SwingFactory.newButton("remove", new CodeBlock((Object)this, "remove"));
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        jPanel.setName("box");
        jPanel.add(this.m_Add);
        jPanel.add(this.m_Edit);
        jPanel.add(this.m_Remove);
        this.m_Component.add(SwingFactory.newScrollPane("attrs", this.m_AttributesList));
        this.m_Component.add(SwingFactory.newLabel("name-label"));
        this.m_Component.add(SwingFactory.newLabel("scale-label"));
        this.m_Component.add(this.m_PrinterName);
        this.m_Component.add(this.m_ScalePagesToFit);
        this.m_Component.add(this.m_ShowPrintDialog);
        this.m_Component.add(jPanel);
        this.stickTop("attrs");
        this.stickLeft("attrs");
        this.stickTop("box");
        this.stickRight("box");
        this.stickLeft("show");
        this.stickBottom("show");
        this.putAbove("name", "scale");
        this.putAbove("scale", "show");
        this.stickLeft("scale-label");
        this.putAbove("attrs", "name", 5);
        this.putLeft("attrs", "box");
        this.stickLeft("name-label");
        this.putRight("name", "name-label,scale-label", 10);
        this.putRight("scale", "name-label,scale-label", 10);
        this.stickRight("name");
        this.stickRight("scale");
        this.vCenter("name-label", "name");
        this.vCenter("scale-label", "scale");
        this.updateButtons();
        I18N.REPORT_UI_MAP.injectObject(null, this, "PrintPage");
        I18N.REPORT_UI_MAP.injectComponents("PrintPage.", this.m_Component);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && this.m_PrinterNames == null) {
            SwingWorker swingWorker = new SwingWorker(){

                @Override
                public Object construct() {
                    PrintPage.this.m_PrinterNames = PrintPage.getPrinters();
                    return PrintPage.this.m_PrinterNames;
                }

                @Override
                public void finished() {
                    DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
                    for (String string : PrintPage.this.m_PrinterNames) {
                        defaultComboBoxModel.addElement(string);
                    }
                    PrintPage.this.m_PrinterName.setModel(defaultComboBoxModel);
                    RenderDetails renderDetails = PrintPage.this.m_Report.getRenderDetails("application/x-print");
                    if (renderDetails != null) {
                        String string;
                        string = renderDetails.getParameterValue("PrinterName");
                        if (!PrintPage.this.m_PrinterNames.contains(string)) {
                            string = DEFAULT;
                        }
                        PrintPage.this.m_PrinterName.setSelectedItem(string);
                    }
                }
            };
            swingWorker.start();
        }
        super.setVisible(bl);
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        String string;
        RenderDetails renderDetails = new RenderDetails();
        renderDetails.setMimeType("application/x-print");
        if (this.m_ShowPrintDialog.isSelected()) {
            renderDetails.addParameter(new Parameter("ShowPrintDialog", "Yes"));
        }
        if (!DEFAULT.equals(string = (String)this.m_PrinterName.getSelectedItem()) && !LOADING.equals(string)) {
            renderDetails.addParameter(new Parameter("PrinterName", string));
        }
        if (this.m_ScalePagesToFit.getSelectedIndex() > 0) {
            renderDetails.addParameter(new Parameter("Media", (String)this.m_ScalePagesToFit.getSelectedItem()));
        }
        int n = this.m_Model.getSize();
        for (int i = 0; i < n; ++i) {
            PrintAttribute printAttribute = (PrintAttribute)this.m_Model.getElementAt(i);
            renderDetails.addParameter(new Parameter(printAttribute.getName(), printAttribute.getValue()));
        }
        this.m_Report.addRenderDetails(renderDetails);
        this.m_Report.setDirty(true);
    }

    public void add() {
        WizardDialog wizardDialog = (WizardDialog)this.m_Wizard.getContainer();
        PrintAttributeDialog printAttributeDialog = new PrintAttributeDialog(wizardDialog, this.m_Model, null);
        printAttributeDialog.pack();
        printAttributeDialog.setLocationRelativeTo(this.m_Component);
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        elixirFrame.showModal(printAttributeDialog);
        this.updateButtons();
    }

    public void edit() {
        PrintAttribute printAttribute = (PrintAttribute)this.m_AttributesList.getSelectedValue();
        WizardDialog wizardDialog = (WizardDialog)this.m_Wizard.getContainer();
        PrintAttributeDialog printAttributeDialog = new PrintAttributeDialog(wizardDialog, this.m_Model, printAttribute);
        printAttributeDialog.pack();
        printAttributeDialog.setLocationRelativeTo(this.m_Component);
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        elixirFrame.showModal(printAttributeDialog);
        this.updateButtons();
    }

    public void remove() {
        PrintAttribute printAttribute = (PrintAttribute)this.m_AttributesList.getSelectedValue();
        this.m_Model.removeAttribute(printAttribute);
        this.updateButtons();
    }

    public void selection() {
        this.updateButtons();
    }

    protected void updateButtons() {
        int n = this.m_AttributesList.getSelectedIndex();
        this.m_Add.setEnabled(this.m_Model.getSize() < PrintAttributeDialog.getTotalChoices());
        this.m_Edit.setEnabled(n >= 0);
        this.m_Remove.setEnabled(n >= 0);
    }

    protected static List<String> getPrinters() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DEFAULT);
        for (int i = 0; i < printServiceArray.length; ++i) {
            PrinterName printerName = printServiceArray[i].getAttribute(PrinterName.class);
            if (printerName == null) continue;
            arrayList.add(printerName.getValue());
        }
        return Collections.unmodifiableList(arrayList);
    }
}

