/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.ui.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.wizard.renderer.IRenderPage;
import com.elixirtech.wizard.renderer.RenderDetailsUtil;
import com.elixirtech.wizard.renderer.RendererWizard;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class RTFPage
extends RelativeLayoutWizardPage
implements IRenderPage {
    private RawReport m_Report;
    private JTextField m_Author;
    private JTextField m_Company;
    private JTextField m_Comments;
    private JCheckBox m_Word2003;

    public RTFPage() {
        super("RTF", null);
    }

    @Override
    public String getMimeType() {
        return "application/rtf";
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Report = ((RendererWizard)iWizard).getReport();
        this.m_Author = this.addLabelledField("author");
        this.m_Company = this.addLabelledField("company");
        this.m_Comments = this.addLabelledField("comments");
        this.m_Word2003 = SwingFactory.newCheckBox("word2003");
        this.m_Component.add(this.m_Word2003);
        RenderDetails renderDetails = this.m_Report.getRenderDetails("application/rtf");
        if (renderDetails != null) {
            this.m_Author.setText(renderDetails.getParameterValue("Author"));
            this.m_Company.setText(renderDetails.getParameterValue("Company"));
            this.m_Comments.setText(renderDetails.getParameterValue("Comments"));
            this.m_Word2003.setSelected("Yes".equals(renderDetails.getParameterValue("Word2003")));
        }
        this.stickTop("author");
        this.putRight("author", "author-label,company-label,comments-label", 10);
        this.alignBelow("company", "author");
        this.alignBelow("comments", "company");
        this.alignBelow("word2003", "comments");
        I18N.REPORT_UI_MAP.injectObject(null, this, "RTFPage");
        I18N.REPORT_UI_MAP.injectComponents("RTFPage.", this.m_Component);
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        RenderDetails renderDetails = this.m_Report.getRenderDetails("application/rtf");
        if (renderDetails == null) {
            renderDetails = new RenderDetails();
            renderDetails.setMimeType("application/rtf");
            this.m_Report.addRenderDetails(renderDetails);
        }
        boolean bl = false;
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Author", this.m_Author.getText());
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Company", this.m_Company.getText());
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Comments", this.m_Comments.getText());
        if (bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Word2003", this.m_Word2003.isSelected() ? "Yes" : "No")) {
            this.m_Report.setDirty(true);
        }
    }
}

