/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IApplication;
import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.arch.TerminateException;
import com.elixirtech.arch.mime.MIMETypes;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DSLookup;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.ParameterUtil;
import com.elixirtech.glint.EyeReader;
import com.elixirtech.glint.viewer.IViewerCanvas;
import com.elixirtech.icons.RenderIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.IPipelineFactory;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.ReportDSL;
import com.elixirtech.report2.engine.AbstractSource;
import com.elixirtech.report2.engine.GlintResult;
import com.elixirtech.report2.engine.InteractivePrintResult;
import com.elixirtech.report2.engine.Pipeline;
import com.elixirtech.report2.engine.PrinterUtil;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.engine.Source;
import com.elixirtech.report2.engine.StreamedResult;
import com.elixirtech.report2.raw.CacheBuilder;
import com.elixirtech.report2.raw.ReportLoader;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.PageHolder;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.ui.wizard.WizardDialog;
import com.elixirtech.util.BooleanUtil;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.FileUtil;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.ParameterUI;
import com.elixirtech.wizard.renderer.ChooseRenderTypePage;
import com.elixirtech.wizard.renderer.IRenderPage;
import com.elixirtech.wizard.renderer.JavaViewer;
import com.elixirtech.wizard.renderer.WizardRegistry;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class RendererWizard
extends Wizard {
    RawReport m_Report;
    boolean m_Preserve;
    Result m_Result;
    protected ArgumentMap m_ArgumentMap = new ArgumentMap();
    protected Map<String, String> m_DynamicParameters = new HashMap<String, String>();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RendererWizard.class);
    public static Icon ICON = RenderIcons.RENDERER_IMAGE;

    public RendererWizard(RawReport rawReport, boolean bl) {
        super(I18N.ERD.getString("RendererWizard.title"));
        this.m_Report = rawReport;
        this.m_Preserve = bl;
        this.buildPages();
    }

    public RawReport getReport() {
        return this.m_Report;
    }

    @Override
    public boolean isStandardSize() {
        return false;
    }

    @Override
    public Dimension getSize() {
        return this.incHeight(WizardDialog.STANDARD_SIZE, 10);
    }

    private Dimension incHeight(Dimension dimension, int n) {
        return new Dimension(dimension.width, dimension.height + n);
    }

    protected void buildPages() {
        ChooseRenderTypePage chooseRenderTypePage = new ChooseRenderTypePage();
        chooseRenderTypePage.setWizard(this);
        this.m_Pages.add(chooseRenderTypePage);
        Iterator<PageHolder> iterator = WizardRegistry.getPageHolders();
        while (iterator.hasNext()) {
            PageHolder pageHolder = iterator.next();
            try {
                IWizardPage iWizardPage = pageHolder.getPage();
                iWizardPage.setWizard(this);
                this.m_Pages.add(iWizardPage);
            }
            catch (Exception exception) {
                m_Log.error((Object)("Can't load page: " + pageHolder.getPageClassName() + " : " + String.valueOf(exception)));
            }
        }
    }

    @Override
    public boolean canFinish() {
        IWizardPage iWizardPage = null;
        IWizardContainer iWizardContainer = this.getContainer();
        if (iWizardContainer != null) {
            iWizardPage = iWizardContainer.getCurrentPage();
        }
        if (iWizardPage == null) {
            iWizardPage = (IWizardPage)this.m_Pages.get(0);
        }
        return iWizardPage.isPageComplete();
    }

    @Override
    public boolean performFinish() {
        Object object;
        m_Log.info((Object)"performFinish()");
        ChooseRenderTypePage chooseRenderTypePage = (ChooseRenderTypePage)this.getPage("RenderType");
        chooseRenderTypePage.saveChoices();
        IRenderPage iRenderPage = (IRenderPage)chooseRenderTypePage.getNextPage();
        iRenderPage.doFinish();
        String string = iRenderPage.getMimeType();
        if (chooseRenderTypePage.isSave() && StringUtil.notEmpty(chooseRenderTypePage.getFilename())) {
            Object object2;
            object = chooseRenderTypePage.getFilename();
            if (((String)object).indexOf(".") < 0) {
                object2 = MIMETypes.getExtension(string);
                object = (String)object + (String)object2;
            }
            if (((File)(object2 = new File((String)object))).exists()) {
                ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
                String string2 = MessageFormat.format(com.elixirtech.report2.ui.I18N.REPORT_UI.getString("RendererWizard.Overwrite"), ((File)object2).getName());
                String string3 = com.elixirtech.report2.ui.I18N.REPORT_UI.getString("RendererWizard.FileExits");
                int n = JOptionPane.showConfirmDialog(elixirFrame.getFrame(), string2, string3, 0);
                if (n == 1) {
                    return false;
                }
            }
        }
        if (this.buildDynamicParameters()) {
            if ("application/x-print".equals(string)) {
                this.printUI();
            } else if ("application/x-glint".equals(string)) {
                object = new CodeBlock((Object)this, "glint");
                new Thread((Runnable)object).start();
            } else {
                object = new CodeBlock((Object)this, "output");
                new Thread((Runnable)object).start();
            }
        }
        return super.performFinish();
    }

    public void printUI() {
        Object object;
        boolean bl;
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        ReportSource reportSource = new ReportSource(dataSourceManager);
        RenderDetails renderDetails = reportSource.getRawReport().getRenderDetails("application/x-print");
        if (renderDetails != null && renderDetails.isSet("ShowPrintDialog") && !(bl = PrinterUtil.showPrintDialog((Frame)(object = (ElixirFrame)Elixir.get(ElixirFrame.class)).getFrame(), (RenderDetails)renderDetails))) {
            return;
        }
        object = new CodeBlock((Object)this, "print");
        new Thread((Runnable)object).start();
    }

    public void print() {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("mime-type", "application/x-print");
            IPipelineFactory iPipelineFactory = (IPipelineFactory)Elixir.get(IPipelineFactory.class);
            Pipeline pipeline = iPipelineFactory.newPipeline(new MimeType("application/x-print"));
            DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
            ReportSource reportSource = new ReportSource(dataSourceManager);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            InteractivePrintResult interactivePrintResult = new InteractivePrintResult((Frame)elixirFrame.getFrame());
            this.setupPageRange((Result)interactivePrintResult);
            pipeline.process((Source)reportSource, (Result)interactivePrintResult);
        }
        catch (RenderException renderException) {
            ElixirJ.error(I18N.ERD.getString("RendererWizard.error-print") + String.valueOf((Object)renderException), renderException);
        }
        catch (TerminateException terminateException) {
            ElixirJ.error(terminateException.getMessage());
        }
    }

    public void glint() {
        Object object;
        Serializable serializable;
        boolean bl;
        ChooseRenderTypePage chooseRenderTypePage = (ChooseRenderTypePage)this.getPage("RenderType");
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        ReportSource reportSource = new ReportSource(dataSourceManager);
        Object object2 = null;
        boolean bl2 = bl = chooseRenderTypePage.isSave() && this.isValidPath(chooseRenderTypePage.getFilename());
        if (bl) {
            object2 = chooseRenderTypePage.getFilename();
            if (((String)object2).indexOf(".") < 0) {
                object2 = (String)object2 + ".glint";
            }
            serializable = new File((String)object2);
            ((File)serializable).getParentFile().mkdirs();
            try {
                object = new FileOutputStream((File)serializable);
                this.m_Result = new GlintResult((OutputStream)new BufferedOutputStream((OutputStream)object));
            }
            catch (IOException iOException) {
                m_Log.warn((Object)("Can't save to " + ((File)serializable).getAbsolutePath()));
                this.m_Result = new GlintResult();
            }
        } else {
            this.m_Result = new GlintResult();
        }
        this.setupPageRange(this.m_Result);
        serializable = new HashMap();
        serializable.put("mime-type", "application/x-glint");
        try {
            object = (IPipelineFactory)Elixir.get(IPipelineFactory.class);
            Pipeline pipeline = object.newPipeline(new MimeType("application/x-glint"));
            pipeline.process((Source)reportSource, this.m_Result);
            if (bl) {
                OutputStream outputStream = ((GlintResult)this.m_Result).getOutputStream();
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    FileInputStream fileInputStream = new FileInputStream((String)object2);
                    EyeReader eyeReader = new EyeReader((InputStream)fileInputStream);
                    ((GlintResult)this.m_Result).setResult((Object)eyeReader);
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    m_Log.error((Object)("Can't read glint data: " + String.valueOf(iOException)));
                }
            }
            this.launchViewer(null);
        }
        catch (RenderException renderException) {
            ElixirJ.error(I18N.ERD.getString("RendererWizard.error-render-glint") + String.valueOf((Object)renderException), renderException);
        }
        catch (TerminateException terminateException) {
            ElixirJ.error(terminateException.getMessage());
        }
    }

    public boolean isValidPath(String string) {
        File file = new File(string);
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
            return file2.exists();
        }
        return false;
    }

    public void output() {
        ChooseRenderTypePage chooseRenderTypePage = (ChooseRenderTypePage)this.getPage("RenderType");
        IRenderPage iRenderPage = (IRenderPage)chooseRenderTypePage.getNextPage();
        String string = iRenderPage.getMimeType();
        try {
            String string2 = this.output(string);
            this.launchViewer(string2);
        }
        catch (RenderException renderException) {
            ElixirJ.error(I18N.ERD.getString("RendererWizard.error-rendering") + string + ": " + String.valueOf((Object)renderException), renderException);
        }
        catch (TerminateException terminateException) {
            ElixirJ.error(terminateException.getMessage());
        }
        catch (IOException iOException) {
            ElixirJ.error(I18N.ERD.getString("RendererWizard.error-io") + string + ": " + String.valueOf(iOException), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String output(String string) throws IOException {
        String string2;
        ChooseRenderTypePage chooseRenderTypePage = (ChooseRenderTypePage)this.getPage("RenderType");
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        ReportSource reportSource = new ReportSource(dataSourceManager);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("mime-type", string);
        File file = null;
        FileOutputStream fileOutputStream = null;
        try {
            string2 = MIMETypes.getExtension(string);
            IPipelineFactory iPipelineFactory = (IPipelineFactory)Elixir.get(IPipelineFactory.class);
            Pipeline pipeline = iPipelineFactory.newPipeline(new MimeType(string));
            if (chooseRenderTypePage.isSave() && StringUtil.notEmpty(chooseRenderTypePage.getFilename())) {
                Object object = chooseRenderTypePage.getFilename();
                if (((String)object).indexOf(".") < 0) {
                    object = (String)object + string2;
                }
                file = new File((String)object);
                file.getParentFile().mkdirs();
            } else {
                file = File.createTempFile("erd", "temp" + string2);
                file.deleteOnExit();
            }
            fileOutputStream = new FileOutputStream(file);
            this.m_Result = new StreamedResult((OutputStream)fileOutputStream, new MimeType(string));
            this.m_Result.setResult((Object)file);
            this.setupPageRange(this.m_Result);
            m_Log.info((Object)"Starting Render");
            pipeline.process((Source)reportSource, this.m_Result);
        }
        catch (Throwable throwable) {
            try {
                m_Log.error((Object)("caught error " + String.valueOf(throwable)), throwable);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                FileUtil.close(fileOutputStream);
                m_Log.info((Object)"Render Complete");
                m_Log.info((Object)(file.getAbsolutePath() + " Output size = " + file.length() + " bytes"));
            }
        }
        FileUtil.close(fileOutputStream);
        m_Log.info((Object)"Render Complete");
        m_Log.info((Object)(file.getAbsolutePath() + " Output size = " + file.length() + " bytes"));
        if (MIMETypes.isArchiveMimeType(string)) {
            string2 = RendererWizard.unzip(file);
            return string2;
        }
        return null;
    }

    protected void setupPageRange(Result result) {
        ChooseRenderTypePage chooseRenderTypePage = (ChooseRenderTypePage)this.getPage("RenderType");
        String string = chooseRenderTypePage.getRange();
        if (StringUtil.notEmpty(string)) {
            result.setFeature("Result.Filter", string);
        }
    }

    protected boolean buildDynamicParameters() {
        Object object;
        Object object2;
        this.m_ArgumentMap.resetParameters();
        this.m_DynamicParameters.clear();
        Iterator iterator = this.m_Report.getParameterIterator();
        while (iterator.hasNext()) {
            object2 = (com.elixirtech.report2.raw.model.Parameter)iterator.next();
            if (!BooleanUtil.value(object2.isEnabled()) || "Result.Filter".equals(object = object2.getKey())) continue;
            this.m_ArgumentMap.extractParameters(object2.getValue());
        }
        object2 = this.m_ArgumentMap.getParameters();
        if (ParameterUtil.getParamCount((List)object2) > 0) {
            object = new ParameterUI((List<Parameter>)object2, (DSLookup)new ReportDSL(this.m_Report));
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard((IWizard)object);
            if (((Wizard)object).isFinished()) {
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    Parameter parameter = (Parameter)iterator2.next();
                    String string = ((ParameterUI)object).getValue(parameter.getName());
                    if (string == null) continue;
                    this.m_DynamicParameters.put(parameter.getName(), string);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    protected void setDynamicParameters(RawReport rawReport) {
        DynamicParameterCallback dynamicParameterCallback = new DynamicParameterCallback();
        Iterator iterator = rawReport.getParameterIterator();
        while (iterator.hasNext()) {
            com.elixirtech.report2.raw.model.Parameter parameter = (com.elixirtech.report2.raw.model.Parameter)iterator.next();
            if (!BooleanUtil.value(parameter.isEnabled())) continue;
            parameter.setValue(ArgumentMap.substitute((String)parameter.getValue(), (ArgumentMap.ICallback)dynamicParameterCallback));
        }
    }

    protected void launchViewer(String string) {
        ChooseRenderTypePage chooseRenderTypePage = (ChooseRenderTypePage)this.getPage("RenderType");
        if (this.m_Result != null && chooseRenderTypePage.isPreview()) {
            String string2 = this.m_Result.getMimeType().value();
            m_Log.info((Object)("Launch Viewer for " + string2));
            if (MimeTypes.GLINT().value().equals(string2)) {
                this.launchJavaViewer("com.elixirtech.glint.viewer.GlintCanvas");
            } else if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                if (desktop.isSupported(Desktop.Action.OPEN)) {
                    try {
                        File file = null;
                        file = string != null ? new File(string) : (File)((StreamedResult)this.m_Result).getResult();
                        m_Log.info((Object)("Desktop opening " + file.getAbsolutePath()));
                        desktop.open(file);
                    }
                    catch (IOException iOException) {
                        m_Log.error((Object)("Error opening file: " + String.valueOf(iOException)), (Throwable)iOException);
                        ElixirJ.userError("Error opening file: " + String.valueOf(iOException));
                    }
                }
            } else {
                ElixirJ.userError("Unable to open this file type");
            }
        }
    }

    protected void launchJavaViewer(String string) {
        try {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(string, true, classLoader);
            IViewerCanvas iViewerCanvas = (IViewerCanvas)clazz.newInstance();
            ChooseRenderTypePage chooseRenderTypePage = (ChooseRenderTypePage)this.getPage("RenderType");
            WizardRegistry.RenderType renderType = chooseRenderTypePage.getRenderType();
            JavaViewer javaViewer = new JavaViewer(renderType.name, iViewerCanvas);
            Object object = null;
            object = this.m_Result instanceof StreamedResult ? ((StreamedResult)this.m_Result).getResult() : (this.m_Result instanceof GlintResult ? ((GlintResult)this.m_Result).getEye() : this.m_Result);
            javaViewer.getToolBar().open(object);
            JFrame jFrame = javaViewer.getFrame();
            IApplication iApplication = (IApplication)Elixir.get(IApplication.class);
            jFrame.setIconImage(iApplication.getFrameIcon());
            jFrame.setLocationRelativeTo(elixirFrame.getFrame());
            jFrame.setVisible(true);
            jFrame.requestFocus();
        }
        catch (Exception exception) {
            ElixirJ.error(I18N.ERD.getString("RendererWizard.error-start-java") + String.valueOf(exception), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String unzip(File file) throws IOException {
        File file2 = null;
        try (ZipInputStream zipInputStream = null;){
            ZipEntry zipEntry;
            Object object = file.getName();
            int n = ((String)object).indexOf(46);
            object = n > 0 ? file.getName().substring(0, n) : (String)object + "output";
            file2 = new File(file.getParentFile(), (String)object);
            if (!file2.exists()) {
                file2.mkdir();
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            zipInputStream = new ZipInputStream(bufferedInputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    if ((file2 = new File(file2, zipEntry.getName())).exists()) continue;
                    file2.mkdirs();
                    continue;
                }
                RendererWizard.unzip(zipInputStream, file2, zipEntry.getName());
            }
        }
        return file2.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(ZipInputStream zipInputStream, File file, String string) throws IOException {
        File file2 = new File(file, string);
        File file3 = file2.getParentFile();
        if (!file3.exists()) {
            file3.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[512];
        int n = 0;
        try {
            while ((n = zipInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            fileOutputStream.close();
        }
    }

    private class ReportSource
    extends AbstractSource {
        private RawReport m_LocalCopy;

        public ReportSource(DataSourceManager dataSourceManager) {
            super(dataSourceManager);
            if (RendererWizard.this.m_Preserve) {
                this.m_LocalCopy = ReportLoader.deepCopy(RendererWizard.this.m_Report);
                RendererWizard.this.setDynamicParameters(this.m_LocalCopy);
            } else {
                this.m_LocalCopy = RendererWizard.this.m_Report;
                RendererWizard.this.setDynamicParameters(this.m_LocalCopy);
            }
            if (this.m_LocalCopy.isCacheAllProperties()) {
                CacheBuilder.build((RawReport)this.m_LocalCopy);
            }
        }

        public void addParameters(scala.collection.immutable.Map<String, String> map) {
            m_Log.debug((Object)"Called addParameters on RendererWizard.ReportSource");
        }

        public scala.collection.immutable.Map<String, String> getParameters() {
            return ElixirJ.toImmutableMap(RendererWizard.this.m_DynamicParameters);
        }

        public RawReport getRawReport() {
            return this.m_LocalCopy;
        }
    }

    private class DynamicParameterCallback
    implements ArgumentMap.ICallback {
        private DynamicParameterCallback() {
        }

        public String getValue(String string, String string2) {
            return RendererWizard.this.m_DynamicParameters.get(string);
        }
    }
}

