/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.ui.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.wizard.renderer.IRenderPage;
import com.elixirtech.wizard.renderer.RenderDetailsUtil;
import com.elixirtech.wizard.renderer.RendererWizard;
import javax.swing.JCheckBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class SWFPage
extends RelativeLayoutWizardPage
implements IRenderPage {
    private RawReport m_Report;
    private JSpinner m_FrameRate;
    private JCheckBox m_Protected;

    public SWFPage() {
        super("SWF", null);
    }

    @Override
    public String getMimeType() {
        return "application/x-shockwave-flash";
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Report = ((RendererWizard)iWizard).getReport();
        int n = 12;
        boolean bl = false;
        RenderDetails renderDetails = this.m_Report.getRenderDetails("application/x-shockwave-flash");
        if (renderDetails != null) {
            Parameter parameter;
            Parameter parameter2 = renderDetails.getParameter("FrameRate");
            if (parameter2 != null) {
                try {
                    n = Integer.parseInt(parameter2.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            bl = (parameter = renderDetails.getParameter("Protected")) != null && "Yes".equals(parameter.getValue());
        }
        this.m_FrameRate = new JSpinner(new SpinnerNumberModel(n, 0, 60, 1));
        this.m_FrameRate.setName("fr");
        this.m_Protected = SwingFactory.newCheckBox("prot");
        this.m_Protected.setSelected(bl);
        this.m_Component.add(SwingFactory.newLabel("fr-label"));
        this.m_Component.add(this.m_FrameRate);
        this.m_Component.add(this.m_Protected);
        this.stickTop("fr");
        this.vCenter("fr-label", "fr");
        this.stickLeft("fr-label");
        this.putRight("fr", "fr-label", 10);
        this.stickTop("prot");
        this.putRight("prot", "fr", 20);
        I18N.REPORT_UI_MAP.injectObject(null, this, "SWFPage");
        I18N.REPORT_UI_MAP.injectComponents("SWFPage.", this.m_Component);
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        RenderDetails renderDetails = this.m_Report.getRenderDetails("application/x-shockwave-flash");
        if (renderDetails == null) {
            renderDetails = new RenderDetails();
            renderDetails.setMimeType("application/x-shockwave-flash");
            this.m_Report.addRenderDetails(renderDetails);
        }
        boolean bl = false;
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "FrameRate", String.valueOf(this.m_FrameRate.getValue()));
        if (bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Protected", this.m_Protected.isSelected() ? "Yes" : "No")) {
            this.m_Report.setDirty(true);
        }
    }
}

