/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.Elixir;
import com.elixirtech.icons.RenderIcons;
import com.elixirtech.report2.IReportAccess;
import com.elixirtech.ui.IRenderable;
import com.elixirtech.ui.wizard.PageHolder;
import com.elixirtech.wizard.renderer.RendererWizard;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;

public class WizardRegistry {
    private static final boolean DEBUG = false;
    private static Set<RenderType> m_Renderers = new TreeSet<RenderType>();
    private static List<PageHolder> m_Pages = new ArrayList<PageHolder>();
    public static final String STANDARD = "Standard";
    public static final String WEB = "Web";
    public static final String OTHERS = "Others";

    public static void register(RenderType renderType) {
        m_Renderers.add(renderType);
    }

    public static void deregister(RenderType renderType) {
        m_Renderers.remove(renderType);
    }

    public static RenderType[] getTypes() {
        RenderType[] renderTypeArray = new RenderType[m_Renderers.size()];
        m_Renderers.toArray(renderTypeArray);
        return renderTypeArray;
    }

    public static void registerPage(String string, String string2, String string3, Icon icon) {
        m_Pages.add(new PageHolder(string, string2, string3, icon));
    }

    public static Iterator<PageHolder> getPageHolders() {
        return m_Pages.iterator();
    }

    static {
        IReportAccess iReportAccess = (IReportAccess)Elixir.get(IReportAccess.class);
        Icon icon = RendererWizard.ICON;
        WizardRegistry.registerPage("com.elixirtech.wizard.renderer.ChooseRenderTypePage", null, null, icon);
        if (iReportAccess.canRender("application/x-print")) {
            WizardRegistry.register(new RenderType(STANDARD, "Print", RenderIcons.PRINT, "Print"));
            WizardRegistry.registerPage("com.elixirtech.wizard.renderer.PrintPage", "Print Format", "Choose Print parameters", icon);
        }
        if (iReportAccess.canRender("application/pdf")) {
            WizardRegistry.register(new RenderType(STANDARD, "PDF", RenderIcons.PDF, "PDF"));
            WizardRegistry.registerPage("com.elixirtech.wizard.renderer.PDFPage", "Portable Document Format", "Choose PDF output parameters", icon);
            WizardRegistry.registerPage("com.elixirtech.wizard.renderer.PDFPage2", "Portable Document Format", "Choose a CJK Font Mapping File", icon);
        }
        if (iReportAccess.canRender("application/postscript")) {
            WizardRegistry.register(new RenderType(STANDARD, "PS", RenderIcons.PS, "PostScript"));
            WizardRegistry.registerPage("com.elixirtech.wizard.renderer.PSPage", "Postscript Format", "There are currently no Postscript output parameters", icon);
        }
        if (iReportAccess.canRender("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
            WizardRegistry.register(new RenderType(STANDARD, "XLSX", RenderIcons.XLSX, "XLSX"));
            WizardRegistry.registerPage("com.elixirtech.wizard.renderer.XLSXPage", "Excel (XLSX) Format", "Choose Excel output parameters", icon);
        }
        if (iReportAccess.canRender("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
            WizardRegistry.register(new RenderType(STANDARD, "DOCX", RenderIcons.DOCX, "DOCX"));
            WizardRegistry.registerPage("com.elixirtech.wizard.renderer.DocxPage", "Docx Format", "There are currently no Docx output parameters", icon);
        }
        if (iReportAccess.canRender("application/x-glint")) {
            WizardRegistry.register(new RenderType(STANDARD, "Glint", RenderIcons.GLINT, "Glint"));
            WizardRegistry.registerPage("com.elixirtech.wizard.renderer.GlintPage", "Glint Format", "There are currently no Glint output parameters", icon);
        }
        if (iReportAccess.canRender("text/csv")) {
            WizardRegistry.register(new RenderType(STANDARD, "CSV", RenderIcons.CSV, "CSV"));
            WizardRegistry.registerPage("com.elixirtech.wizard.renderer.CSVPage", null, null, icon);
        }
        if (iReportAccess.canRender("text/html")) {
            WizardRegistry.register(new RenderType(WEB, "HTML", RenderIcons.HTML, "HTML"));
            WizardRegistry.registerPage("com.elixirtech.wizard.renderer.HTMLPage", "HTML Format", "Choose HTML output parameters", icon);
        }
        if (iReportAccess.canRender("application/x-html-zip")) {
            WizardRegistry.register(new RenderType(WEB, "HTML-Zip", RenderIcons.HTML, "HTML-Zip"));
            WizardRegistry.registerPage("com.elixirtech.wizard.renderer.HTMLZipPage", "HTML-Zip Format", "Choose HTML-Zip output parameters", icon);
        }
        if (iReportAccess.canRender("text/xml")) {
            WizardRegistry.register(new RenderType(OTHERS, "XML", RenderIcons.XML, "XML"));
            WizardRegistry.registerPage("com.elixirtech.wizard.renderer.XMLPage", "XML Format", "Choose XML output parameters", icon);
        }
        if (iReportAccess.canRender("image/png") || iReportAccess.canRender("image/jpeg") || iReportAccess.canRender("application/x-png-zip") || iReportAccess.canRender("application/x-jpeg-zip")) {
            WizardRegistry.register(new RenderType(STANDARD, "Image", RenderIcons.IMAGE, "Image"));
            WizardRegistry.registerPage("com.elixirtech.wizard.renderer.ImagePage", "Image Format", "Choose Image type and output parameters", icon);
        }
        if (iReportAccess.canRender("application/x-svg-zip")) {
            WizardRegistry.register(new RenderType(WEB, "SVG-Zip", RenderIcons.SVG, "SVG-Zip"));
            WizardRegistry.registerPage("com.elixirtech.wizard.renderer.SVGZipPage", "SVG-Zip Format", "There are currently no SVG-Zip output parameters", icon);
        }
    }

    public static class RenderType
    implements Comparable<RenderType>,
    IRenderable {
        public String category;
        public String name;
        public Icon icon;
        public String dsClass;

        public RenderType(String string, String string2, Icon icon, String string3) {
            this.category = string;
            this.name = string2;
            this.icon = icon;
            this.dsClass = string3;
        }

        @Override
        public int compareTo(RenderType renderType) {
            return this.name.compareTo(renderType.name);
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

