/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.ui.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.StrBuffer;
import com.elixirtech.wizard.renderer.IRenderPage;
import com.elixirtech.wizard.renderer.RenderDetailsUtil;
import com.elixirtech.wizard.renderer.RendererWizard;
import java.awt.FlowLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class XLSPage
extends RelativeLayoutWizardPage
implements IRenderPage {
    public static String MULTIPLIER = "Multiplier";
    public static int DEFAULT_MULTIPLIER = 46;
    private static final String STREAMED = "Streamed";
    private static final String SECTIONED = "Sectioned";
    private static final String PAGED = "Paged";
    private static final String TREE = "Tree";
    private JTextField m_Multiplier;
    private RawReport m_Report;
    private JRadioButton m_Streamed;
    private JRadioButton m_Sectioned;
    private JRadioButton m_Paged;
    private JRadioButton m_Tree;
    private JCheckBox m_Snap;
    private JCheckBox m_ForceNumbersAsText;

    public XLSPage() {
        super("XLS", null);
    }

    @Override
    public String getMimeType() {
        return "application/vnd.ms-excel";
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Report = ((RendererWizard)iWizard).getReport();
        this.m_Streamed = SwingFactory.newRadioButton("streamed");
        this.m_Sectioned = SwingFactory.newRadioButton("sectioned");
        this.m_Paged = SwingFactory.newRadioButton("paged");
        this.m_Tree = SwingFactory.newRadioButton("tree");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_Streamed);
        buttonGroup.add(this.m_Sectioned);
        buttonGroup.add(this.m_Paged);
        buttonGroup.add(this.m_Tree);
        this.m_Component.add(this.m_Streamed);
        this.m_Component.add(this.m_Sectioned);
        this.m_Component.add(this.m_Paged);
        this.m_Component.add(this.m_Tree);
        this.stickTop("streamed");
        this.stickLeft("streamed");
        this.alignBelow("sectioned", "streamed");
        this.alignBelow("paged", "sectioned");
        this.alignBelow("tree", "paged");
        this.m_Snap = SwingFactory.newCheckBox("snap");
        this.m_Component.add(this.m_Snap);
        this.putBelow("snap", "tree");
        this.stickLeft("snap");
        this.m_ForceNumbersAsText = SwingFactory.newCheckBox("force");
        this.m_Component.add(this.m_ForceNumbersAsText);
        this.putBelow("force", "snap");
        this.stickLeft("force");
        this.m_Multiplier = new JTextField(10);
        this.m_Multiplier.setDocument(new NumberDoc());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        JLabel jLabel = new JLabel("Multiplier");
        jLabel.setName("multiplier-lbl");
        jPanel.add(jLabel);
        jPanel.add(this.m_Multiplier);
        this.m_Component.add("multiplier", jPanel);
        this.stickLeft("multiplier");
        this.putBelow("multiplier", "force");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string = null;
        RenderDetails renderDetails = this.m_Report.getRenderDetails("application/vnd.ms-excel");
        if (renderDetails != null) {
            bl = renderDetails.isSet(STREAMED);
            bl2 = renderDetails.isSet(SECTIONED);
            bl3 = renderDetails.isSet(PAGED);
            bl4 = renderDetails.isSet(TREE);
            bl5 = renderDetails.isSet("Snap");
            bl6 = renderDetails.isSet("ForceNumbersAsText");
            string = renderDetails.getParameterValue(MULTIPLIER, String.valueOf(DEFAULT_MULTIPLIER));
        }
        this.m_Streamed.setSelected(bl);
        this.m_Sectioned.setSelected(bl2);
        this.m_Paged.setSelected(bl3);
        this.m_Tree.setSelected(bl4);
        this.m_Snap.setSelected(bl5);
        this.m_Multiplier.setText(string);
        this.m_ForceNumbersAsText.setSelected(bl6);
        I18N.REPORT_UI_MAP.injectObject(null, this, "XLSPage");
        I18N.REPORT_UI_MAP.injectComponents("XLSPage.", this.m_Component);
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        RenderDetails renderDetails = this.m_Report.getRenderDetails("application/vnd.ms-excel");
        if (renderDetails == null) {
            renderDetails = new RenderDetails();
            renderDetails.setMimeType("application/vnd.ms-excel");
            this.m_Report.addRenderDetails(renderDetails);
        }
        boolean bl = false;
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, STREAMED, this.m_Streamed.isSelected() ? "Yes" : "No");
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, SECTIONED, this.m_Sectioned.isSelected() ? "Yes" : "No");
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, PAGED, this.m_Paged.isSelected() ? "Yes" : "No");
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, TREE, this.m_Tree.isSelected() ? "Yes" : "No");
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Snap", this.m_Snap.isSelected() ? "Yes" : "No");
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "ForceNumbersAsText", this.m_ForceNumbersAsText.isSelected() ? "Yes" : "No");
        if (bl |= RenderDetailsUtil.setRenderDetails(renderDetails, MULTIPLIER, this.m_Multiplier.getText())) {
            this.m_Report.setDirty(true);
        }
    }

    final class NumberDoc
    extends PlainDocument {
        NumberDoc() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            StrBuffer strBuffer = new StrBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!Character.isDigit(c)) continue;
                strBuffer.append(c);
            }
            super.insertString(n, strBuffer.toString(), attributeSet);
        }
    }
}

