/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.Encoding;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.ui.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.renderer.IRenderPage;
import com.elixirtech.wizard.renderer.RenderDetailsUtil;
import com.elixirtech.wizard.renderer.RendererWizard;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public class XMLPage
extends RelativeLayoutWizardPage
implements IRenderPage {
    private RawReport m_Report;
    private JComboBox m_Encoding;
    private JCheckBox m_Paged;
    private JCheckBox m_Indented;
    private JTextField m_XSLT;
    private JCheckBox m_XSLTEnabled;

    public XMLPage() {
        super("XML", null);
    }

    @Override
    public String getMimeType() {
        return "text/xml";
    }

    @Override
    public void setWizard(IWizard iWizard) {
        Object object;
        super.setWizard(iWizard);
        this.m_Report = ((RendererWizard)iWizard).getReport();
        this.m_XSLT = SwingFactory.newTextField("xslt");
        this.m_XSLTEnabled = SwingFactory.newCheckBox("xslt-enabled");
        this.m_Encoding = SwingFactory.newComboBox("encoding", Encoding.getAllNames());
        new Encoding.ComboBoxListener(this.m_Encoding);
        this.m_Encoding.setEditable(true);
        this.m_Paged = SwingFactory.newCheckBox("paged");
        this.m_Indented = SwingFactory.newCheckBox("indented");
        String string = "UTF-8";
        boolean bl = false;
        boolean bl2 = false;
        RenderDetails renderDetails = this.m_Report.getRenderDetails("text/xml");
        if (renderDetails != null) {
            this.m_XSLT.setText(renderDetails.getParameterValue("XSLT"));
            this.m_XSLTEnabled.setSelected(renderDetails.isSet("XSLTEnabled"));
            object = renderDetails.getParameter("Encoding");
            if (object != null) {
                string = object.getValue();
            }
            bl = renderDetails.isSet("Paged");
            bl2 = renderDetails.isSet("Indented");
        }
        this.m_Encoding.setSelectedItem(string);
        this.m_Paged.setSelected(bl);
        this.m_Indented.setSelected(bl2);
        this.m_Component.add(SwingFactory.newLabel("xslt-label"));
        this.m_Component.add(this.m_XSLT);
        this.m_Component.add(this.m_XSLTEnabled);
        this.m_Component.add(SwingFactory.newLabel("encoding-label"));
        this.m_Component.add(this.m_Encoding);
        this.m_Component.add(this.m_Paged);
        this.m_Component.add(this.m_Indented);
        this.stickTop("xslt");
        this.vCenter("xslt-label", "xslt");
        this.vCenter("xslt-enabled", "xslt");
        this.stickLeft("xslt-label");
        this.stickRight("xslt-enabled");
        this.putRight("xslt", "xslt-label,encoding-label", 10);
        this.putLeft("xslt", "xslt-enabled");
        this.alignBelow("encoding", "xslt", 10);
        this.vCenter("encoding-label", "encoding");
        this.stickLeft("encoding-label");
        this.stickRight("encoding");
        this.alignBelow("indented", "encoding");
        this.alignBelow("paged", "indented");
        I18N.REPORT_UI_MAP.injectObject(null, this, "XMLPage");
        I18N.REPORT_UI_MAP.injectComponents("XMLPage.", this.m_Component);
        object = new CodeBlock((Object)this, "checkEnabled");
        this.m_XSLT.getDocument().addDocumentListener((DocumentListener)object);
        this.m_XSLTEnabled.addItemListener((ItemListener)object);
        this.checkEnabled();
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        RenderDetails renderDetails = this.m_Report.getRenderDetails("text/xml");
        if (renderDetails == null) {
            renderDetails = new RenderDetails();
            renderDetails.setMimeType("text/xml");
            this.m_Report.addRenderDetails(renderDetails);
        }
        boolean bl = false;
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "XSLT", this.m_XSLT.getText());
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "XSLTEnabled", this.m_XSLTEnabled.isSelected() ? "Yes" : "No");
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Encoding", (String)this.m_Encoding.getSelectedItem());
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Paged", this.m_Paged.isSelected() ? "Yes" : "No");
        if (bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Indented", this.m_Indented.isSelected() ? "Yes" : "No")) {
            this.m_Report.setDirty(true);
        }
    }

    public void checkEnabled() {
        String string = this.m_XSLT.getText();
        if (StringUtil.isEmpty(string)) {
            this.m_XSLTEnabled.setSelected(false);
            this.m_XSLTEnabled.setEnabled(false);
        } else {
            this.m_XSLTEnabled.setEnabled(true);
        }
        boolean bl = !this.m_XSLTEnabled.isSelected();
        this.m_Encoding.setEnabled(bl);
        this.m_Indented.setEnabled(bl);
    }
}

