/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer.print;

import com.elixirtech.report2.print.PrintAttribute;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RenderDetails;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;

public class AttributeModel
extends AbstractListModel<Object> {
    private List<PrintAttribute> m_Attributes = new ArrayList<PrintAttribute>();

    public AttributeModel(RenderDetails renderDetails) {
        if (renderDetails != null) {
            for (Parameter parameter : renderDetails.getParameterMap().values()) {
                PrintAttribute printAttribute = PrintAttribute.create((String)parameter.getKey(), (String)parameter.getValue());
                if (printAttribute == null) continue;
                this.addAttribute(printAttribute);
            }
        }
    }

    @Override
    public int getSize() {
        return this.m_Attributes.size();
    }

    @Override
    public Object getElementAt(int n) {
        return this.m_Attributes.get(n);
    }

    public void addAttribute(PrintAttribute printAttribute) {
        assert (printAttribute != null) : "PrintAttribute is null";
        this.m_Attributes.add(printAttribute);
        Collections.sort(this.m_Attributes);
        int n = this.m_Attributes.indexOf(printAttribute);
        this.fireIntervalAdded(this, n, n);
    }

    public void removeAttribute(PrintAttribute printAttribute) {
        int n = this.m_Attributes.indexOf(printAttribute);
        if (n >= 0) {
            this.m_Attributes.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }
    }

    public void attributeChanged(PrintAttribute printAttribute) {
        int n = this.m_Attributes.indexOf(printAttribute);
        if (n >= 0) {
            this.fireContentsChanged(this, n, n);
        }
    }

    public boolean containsKey(String string) {
        for (PrintAttribute printAttribute : this.m_Attributes) {
            if (!printAttribute.getName().equals(string)) continue;
            return true;
        }
        return false;
    }
}

