/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer.print;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.print.PrintAttribute;
import com.elixirtech.report2.print.PrintChromacity;
import com.elixirtech.report2.print.PrintCopies;
import com.elixirtech.report2.print.PrintJobName;
import com.elixirtech.report2.print.PrintMediaTray;
import com.elixirtech.report2.print.PrintNumberUp;
import com.elixirtech.report2.print.PrintPageRange;
import com.elixirtech.report2.print.PrintPrintQuality;
import com.elixirtech.report2.print.PrintPrinterResolution;
import com.elixirtech.report2.print.PrintSheetCollate;
import com.elixirtech.report2.print.PrintSides;
import com.elixirtech.ui.EscapableDialog;
import com.elixirtech.ui.LCellRenderer;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.renderer.print.AttributeModel;
import com.elixirtech.wizard.renderer.print.PrintAttributeExtras;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrintAttributeDialog
extends EscapableDialog {
    private static final int NO_CHOICES = 9;
    private PrintAttribute[] CHOICES = PrintAttributeDialog.buildChoices();
    private AttributeModel m_Model;
    private PrintAttribute m_Choice;
    private JComboBox m_Choices = new JComboBox();
    private JPanel m_Center = new JPanel(new BorderLayout());
    private JComponent m_CurrentEditor;
    private JButton m_Ok = SwingFactory.newOkButton();
    private JButton m_Cancel = SwingFactory.newCancelButton();

    public PrintAttributeDialog(JDialog jDialog, AttributeModel attributeModel, PrintAttribute printAttribute) {
        super(jDialog);
        this.setName("PrintAttributeDialog");
        this.setModal(true);
        assert (attributeModel != null) : "AttributeModel is null";
        this.m_Model = attributeModel;
        this.m_Choice = printAttribute;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.add(SwingFactory.newLabel("PrintAttributeDialog-Attribute"));
        DefaultComboBoxModel<PrintAttribute> defaultComboBoxModel = new DefaultComboBoxModel<PrintAttribute>();
        if (this.m_Choice != null) {
            defaultComboBoxModel.addElement(this.m_Choice);
        } else {
            for (int i = 0; i < this.CHOICES.length; ++i) {
                if (this.m_Model.containsKey(this.CHOICES[i].getName())) continue;
                defaultComboBoxModel.addElement(this.CHOICES[i]);
            }
        }
        this.m_Choices.setModel(defaultComboBoxModel);
        this.m_Choices.setRenderer(new LCellRenderer());
        if (defaultComboBoxModel.getSize() > 0) {
            this.m_Choices.setSelectedIndex(0);
        }
        this.m_Choices.addItemListener(new CodeBlock((Object)this, "choiceMade"));
        jPanel.add(this.m_Choices);
        container.add((Component)jPanel, "North");
        this.m_Center.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 5));
        container.add((Component)this.m_Center, "Center");
        this.fillCenter();
        JPanel jPanel2 = new JPanel();
        this.m_Ok.addActionListener(new CodeBlock((Object)this, "ok"));
        jPanel2.add(this.m_Ok);
        this.m_Cancel.addActionListener(new CodeBlock((Object)this, "cancel"));
        jPanel2.add(this.m_Cancel);
        container.add((Component)jPanel2, "South");
        com.elixirtech.report2.ui.I18N.REPORT_UI_MAP.injectComponents(null, this);
    }

    public void choiceMade() {
        this.fillCenter();
    }

    public void ok() {
        try {
            if (this.m_Choice != null) {
                this.setFromEditor(this.m_Choice, this.m_CurrentEditor);
                this.m_Model.attributeChanged(this.m_Choice);
            } else {
                PrintAttribute printAttribute = (PrintAttribute)this.m_Choices.getSelectedItem();
                if (printAttribute != null) {
                    this.setFromEditor(printAttribute, this.m_CurrentEditor);
                    this.m_Model.addAttribute(printAttribute);
                }
            }
            this.dispose();
        }
        catch (Throwable throwable) {
            ElixirJ.userError(throwable.getMessage());
        }
    }

    public void cancel() {
        this.dispose();
    }

    public static int getTotalChoices() {
        return 9;
    }

    protected void fillCenter() {
        this.m_Center.removeAll();
        PrintAttribute printAttribute = (PrintAttribute)this.m_Choices.getSelectedItem();
        if (printAttribute != null) {
            this.m_Center.add((Component)new JLabel(I18N.ERD.getString("Print." + printAttribute.getName()) + ":"), "West");
            this.m_CurrentEditor = this.getEditor(printAttribute);
            this.m_Center.add((Component)this.m_CurrentEditor, "Center");
            this.m_Center.invalidate();
            this.m_Center.validate();
        }
    }

    private void setFromEditor(PrintAttribute printAttribute, JComponent jComponent) {
        PrintAttributeExtras.setFromEditor(printAttribute, jComponent);
    }

    private JComponent getEditor(PrintAttribute printAttribute) {
        return PrintAttributeExtras.getEditor(printAttribute);
    }

    private static PrintAttribute[] buildChoices() {
        PrintAttribute[] printAttributeArray = new PrintAttribute[]{new PrintChromacity(), new PrintCopies(), new PrintJobName(), new PrintMediaTray(), new PrintNumberUp(), new PrintPageRange(), new PrintPrinterResolution(), new PrintPrintQuality(), new PrintSides(), new PrintSheetCollate()};
        return printAttributeArray;
    }
}

