/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.report;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.repository.RepositoryTree;
import com.elixirtech.arch.repository.filter.TypeFilter;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.report2.I18N;
import com.elixirtech.repository.ExtraTodo;
import com.elixirtech.repository.TreeNode;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import com.elixirtech.wizard.report.ReportWizard;
import javax.swing.JCheckBox;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class ChooseDatasourcePage
extends RelativeLayoutWizardPage {
    public static final String NAME = "Choose DataSource";
    private RepositoryTree m_Tree;
    private JCheckBox m_PropogateParameters;

    public ChooseDatasourcePage() {
        super(NAME, "Choose Report");
        I18N.ERD_MAP.injectObject(null, this, "ChooseDatasourcePage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        Repository repository = (Repository)Elixir.get(Repository.class);
        this.m_Tree = RepositoryTree.apply("ChooseDataSourcePage", repository, new TypeFilter("ds"));
        this.m_Component.add(SwingFactory.newScrollPane("tree", this.m_Tree));
        this.m_PropogateParameters = SwingFactory.newCheckBox("propogate");
        this.m_Component.add(this.m_PropogateParameters);
        this.m_PropogateParameters.setSelected(true);
        this.stickLeft("tree");
        this.stickTop("tree");
        this.stickRight("tree");
        this.putAbove("tree", "propogate");
        this.stickBottom("propogate");
        this.hCenter("propogate");
        this.m_Tree.getSelectionModel().addTreeSelectionListener(new TSL());
        I18N.ERD_MAP.injectComponents("ChooseDatasourcePage.", this.m_Component);
    }

    public void itemSelected(FileObject fileObject) {
        ((ReportWizard)this.m_Wizard).setDataSourceName(fileObject.getPath().toString());
    }

    public boolean isPropogateParameters() {
        return this.m_PropogateParameters.isSelected();
    }

    @Override
    public void dispose() {
        if (this.m_Tree != null) {
            this.m_Tree.dispose();
            this.m_Tree = null;
        }
        super.dispose();
    }

    private class TSL
    implements TreeSelectionListener {
        private TSL() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getPath();
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            FileObject fileObject = ExtraTodo.getFileObject(treeNode);
            ChooseDatasourcePage.this.itemSelected(fileObject);
        }
    }
}

