/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.report;

import com.elixirtech.icons.WizardIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.WizardPage;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class ColumnarLayoutReportPage
extends WizardPage {
    public static final String NAME = "Columnar Layout Report";
    public static final String STEP = "Step";
    public static final String BLOCK = "Block";
    public static final String ALIGNLEFT = "AlignLeft";
    public static final String OUTLINE = "Outline";
    JLabel m_View = new JLabel(WizardIcons.COLUMNAR_STEP);
    JLabel m_ViewPaper;
    private ButtonGroup m_GroupOrientation = new ButtonGroup();
    private ButtonGroup m_GroupLayout = new ButtonGroup();
    JRadioButton m_Portrait;
    JRadioButton m_Landscape;
    JRadioButton m_Step;
    JRadioButton m_Block;
    JRadioButton m_AlignLeft;
    JRadioButton m_Outline;
    private JCheckBox m_IsKeepInOnePage;

    public ColumnarLayoutReportPage() {
        super(NAME, null);
        this.buildUI();
    }

    private void buildUI() {
        JPanel jPanel = new JPanel(new GridLayout(5, 1));
        jPanel.setBorder(this.border(I18N.ERD.getString("ColumnarLayoutReportPage.layout")));
        this.m_Step = SwingFactory.newRadioButton("stepped");
        jPanel.add(this.m_Step);
        this.m_Block = SwingFactory.newRadioButton("block");
        jPanel.add(this.m_Block);
        this.m_AlignLeft = SwingFactory.newRadioButton("alignleft");
        jPanel.add(this.m_AlignLeft);
        this.m_Outline = SwingFactory.newRadioButton("outline");
        jPanel.add(this.m_Outline);
        jPanel.add(new JPanel());
        JPanel jPanel2 = new JPanel(new GridLayout(6, 1));
        jPanel2.setBorder(this.border(I18N.ERD.getString("ColumnarLayoutReportPage.orientation")));
        this.m_Portrait = SwingFactory.newRadioButton("RPT.portrait");
        jPanel2.add(this.m_Portrait);
        this.m_Landscape = SwingFactory.newRadioButton("RPT.landscape");
        jPanel2.add(this.m_Landscape);
        FlipPaperAL flipPaperAL = new FlipPaperAL();
        this.m_Portrait.addActionListener(flipPaperAL);
        this.m_Landscape.addActionListener(flipPaperAL);
        this.m_ViewPaper = new JLabel(WizardIcons.PORTRAIT);
        jPanel2.add(this.m_ViewPaper);
        jPanel.add(new JPanel());
        jPanel.add(new JPanel());
        jPanel.add(new JPanel());
        jPanel.add(new JPanel());
        this.m_GroupOrientation.add(this.m_Portrait);
        this.m_GroupOrientation.add(this.m_Landscape);
        this.m_GroupLayout.add(this.m_Step);
        this.m_GroupLayout.add(this.m_Block);
        this.m_GroupLayout.add(this.m_AlignLeft);
        this.m_GroupLayout.add(this.m_Outline);
        FlipReportAL flipReportAL = new FlipReportAL();
        this.m_Step.addActionListener(flipReportAL);
        this.m_Block.addActionListener(flipReportAL);
        this.m_AlignLeft.addActionListener(flipReportAL);
        this.m_Outline.addActionListener(flipReportAL);
        this.m_Portrait.setSelected(true);
        this.m_Step.setSelected(true);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("Center", jPanel);
        jPanel3.add("East", jPanel2);
        this.m_IsKeepInOnePage = SwingFactory.newCheckBox("keepfieldsinpage");
        jPanel3.add("South", this.m_IsKeepInOnePage);
        this.m_IsKeepInOnePage.setVisible(false);
        this.m_IsKeepInOnePage.setSelected(true);
        this.m_Component.setLayout(new BorderLayout());
        this.m_Component.add("East", jPanel3);
        this.m_Component.add("Center", this.m_View);
        I18N.ERD_MAP.injectComponents("ColumnarLayoutReportPage.", this.m_Component);
        this.setTitle(I18N.ERD.getString("ColumnarLayoutReportPage.title"));
        this.setMessage(I18N.ERD.getString("ColumnarLayoutReportPage.message"));
    }

    protected Border border(String string) {
        return BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string);
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Wizard = iWizard;
    }

    public boolean isPortrait() {
        return this.m_Portrait.isSelected();
    }

    public String getLayout() {
        if (this.m_Step.isSelected()) {
            return STEP;
        }
        if (this.m_Block.isSelected()) {
            return BLOCK;
        }
        if (this.m_AlignLeft.isSelected()) {
            return ALIGNLEFT;
        }
        return OUTLINE;
    }

    public boolean isKeepInOnePage() {
        return this.m_IsKeepInOnePage.isSelected();
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    final class FlipPaperAL
    implements ActionListener {
        FlipPaperAL() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ColumnarLayoutReportPage.this.m_Landscape.isSelected()) {
                ColumnarLayoutReportPage.this.m_ViewPaper.setIcon(WizardIcons.LANDSCAPE);
            } else {
                ColumnarLayoutReportPage.this.m_ViewPaper.setIcon(WizardIcons.PORTRAIT);
            }
        }
    }

    final class FlipReportAL
    implements ActionListener {
        FlipReportAL() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ColumnarLayoutReportPage.this.m_Step.isSelected()) {
                ColumnarLayoutReportPage.this.m_View.setIcon(WizardIcons.COLUMNAR_STEP);
            } else if (ColumnarLayoutReportPage.this.m_Block.isSelected()) {
                ColumnarLayoutReportPage.this.m_View.setIcon(WizardIcons.COLUMNAR_BLOCK);
            } else if (ColumnarLayoutReportPage.this.m_AlignLeft.isSelected()) {
                ColumnarLayoutReportPage.this.m_View.setIcon(WizardIcons.COLUMNAR_ALIGNLEFT);
            } else if (ColumnarLayoutReportPage.this.m_Outline.isSelected()) {
                ColumnarLayoutReportPage.this.m_View.setIcon(WizardIcons.COLUMNAR_OUTLINE);
            }
        }
    }
}

