/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.report;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.report.FieldValue;
import com.elixirtech.wizard.report.SortDialog;
import com.elixirtech.wizard.report.StandardReportPage;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;

public class ColumnarSelectGroupingLevelPage
extends WizardPage
implements ActionListener {
    public static final String NAME = "Columnar Group Level Selection Page";
    private IWizard m_Wizard;
    private JList m_AvailableFields;
    private JList m_GroupLevelFields;
    private JButton m_Left = new JButton(StandardIcons.LEFT);
    private JButton m_Right = new JButton(StandardIcons.RIGHT);
    private JButton m_Up = new JButton(StandardIcons.UP);
    private JButton m_Down = new JButton(StandardIcons.DOWN);
    private JButton m_Options;
    protected DefaultListModel m_Field = new DefaultListModel();
    protected DefaultListModel m_FieldGroup = new DefaultListModel();
    protected String m_PageType;

    protected ColumnarSelectGroupingLevelPage(String string, String string2) {
        super(string, string2);
        this.buildUI();
    }

    public ColumnarSelectGroupingLevelPage() {
        super(NAME, "Columnar Set Field Sorting Page");
        this.m_PageType = "Columnar Select Field";
        this.buildUI();
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Wizard = iWizard;
    }

    @Override
    public void setVisible(boolean bl) {
        assert (this.m_PageType != null);
        StandardReportPage standardReportPage = (StandardReportPage)this.m_Wizard.getPage(this.m_PageType);
        if (bl) {
            AbstractTableModel abstractTableModel = standardReportPage.getChosenFieldModel();
            if (abstractTableModel != null) {
                FieldValue fieldValue;
                Object object;
                HashSet<String> hashSet = new HashSet<String>();
                this.m_Field.removeAllElements();
                int n = abstractTableModel.getRowCount();
                for (int i = 0; i < n; ++i) {
                    String string = (String)abstractTableModel.getValueAt(i, 0);
                    object = (String)abstractTableModel.getValueAt(i, 1);
                    fieldValue = new FieldValue(string, (String)object);
                    hashSet.add(string);
                    this.m_Field.addElement(fieldValue);
                }
                Object[] objectArray = this.m_FieldGroup.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    object = (FieldValue)objectArray[i];
                    if (hashSet.contains(((FieldValue)object).getName())) continue;
                    this.m_FieldGroup.removeElement(object);
                }
                Object[] objectArray2 = this.m_Field.toArray();
                for (int i = 0; i < objectArray2.length; ++i) {
                    fieldValue = (FieldValue)objectArray2[i];
                    if (!this.m_FieldGroup.contains(fieldValue)) continue;
                    this.m_Field.removeElement(fieldValue);
                }
                this.m_GroupLevelFields.setModel(this.m_FieldGroup);
                this.m_AvailableFields.setModel(this.m_Field);
                if (this.m_Field.size() > 0) {
                    this.m_AvailableFields.setSelectedIndex(0);
                }
            }
            this.updateButtons();
        }
    }

    public void remove() {
        Object e = this.m_GroupLevelFields.getSelectedValue();
        if (e != null) {
            this.m_Field.addElement(e);
            this.m_FieldGroup.removeElement(e);
            FieldValue fieldValue = (FieldValue)e;
            fieldValue.m_Group.setGroupFooterVisible(false);
            fieldValue.m_Group.setGroupHeaderVisible(false);
            fieldValue.m_Group.setSortOrder("None");
            this.m_AvailableFields.setSelectedValue(e, true);
            int n = this.m_FieldGroup.getSize();
            if (n > 0) {
                this.m_GroupLevelFields.setSelectedIndex(n - 1);
            }
        }
    }

    public void add() {
        Object e = this.m_AvailableFields.getSelectedValue();
        if (e != null) {
            this.m_FieldGroup.addElement(e);
            this.m_Field.removeElement(e);
            FieldValue fieldValue = (FieldValue)e;
            fieldValue.m_Group.setGroupFooterVisible(true);
            fieldValue.m_Group.setGroupHeaderVisible(true);
            fieldValue.m_Group.setSortOrder("Ascending");
            this.m_GroupLevelFields.setSelectedValue(e, true);
            if (this.m_Field.size() > 0) {
                this.m_AvailableFields.setSelectedIndex(0);
            }
        }
    }

    public void up() {
        Object e = this.m_GroupLevelFields.getSelectedValue();
        if (e != null) {
            int n = this.m_GroupLevelFields.getSelectedIndex();
            if (n < 1) {
                return;
            }
            this.m_FieldGroup.removeElement(e);
            this.m_FieldGroup.add(--n, e);
            this.m_GroupLevelFields.setSelectedIndex(n);
        }
    }

    public void down() {
        Object e = this.m_GroupLevelFields.getSelectedValue();
        int n = this.m_FieldGroup.getSize();
        if (e != null) {
            int n2 = this.m_GroupLevelFields.getSelectedIndex();
            if (n2 + 2 > n) {
                return;
            }
            this.m_FieldGroup.removeElement(e);
            this.m_FieldGroup.add(++n2, e);
            this.m_GroupLevelFields.setSelectedIndex(n2);
        }
    }

    public void setMoreGroupOption() {
        Object e = this.m_GroupLevelFields.getSelectedValue();
        if (e != null) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            SortDialog sortDialog = new SortDialog(elixirFrame.getFrame(), I18N.ERD.getString("ColumnarSelectGroupingLevelPage.sortdialog"), (FieldValue)e);
            sortDialog.setVisible(true);
        }
    }

    private void buildUI() {
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_AvailableFields = SwingFactory.newList("available-list");
        this.m_GroupLevelFields = SwingFactory.newList("group-level");
        CodeBlock codeBlock = new CodeBlock((Object)this, "updateButtons");
        this.m_AvailableFields.getSelectionModel().addListSelectionListener(codeBlock);
        this.m_GroupLevelFields.getSelectionModel().addListSelectionListener(codeBlock);
        this.m_Component.setLayout(new GridLayout(1, 2));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("North", SwingFactory.newLabel("availablefield-label"));
        JPanel jPanel2 = new JPanel(new GridLayout(6, 1));
        jPanel.add("Center", SwingFactory.newScrollPane("availablefield", this.m_AvailableFields));
        jPanel.add("East", jPanel2);
        jPanel2.add(new JPanel());
        jPanel2.add(this.m_Right);
        jPanel2.add(this.m_Left);
        jPanel2.add(this.m_Up);
        jPanel2.add(this.m_Down);
        jPanel2.add(new JPanel());
        this.m_Component.add(jPanel);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("North", SwingFactory.newLabel("grouplevel-label"));
        jPanel3.add("Center", SwingFactory.newScrollPane("group-level", this.m_GroupLevelFields));
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        this.m_Options = SwingFactory.newButton("groupoption-label");
        jPanel4.add(this.m_Options);
        jPanel3.add("South", jPanel4);
        this.m_Component.add(jPanel3);
        this.m_Left.addActionListener(this);
        this.m_Right.addActionListener(this);
        this.m_Up.addActionListener(this);
        this.m_Down.addActionListener(this);
        this.m_Options.addActionListener(this);
        I18N.ERD_MAP.injectComponents("ColumnarSelectGroupingLevelPage.", this.m_Component);
        I18N.ERD_MAP.injectObject(null, this, "ColumnarSelectGroupingLevelPage");
    }

    public void updateButtons() {
        int n = this.m_GroupLevelFields.getSelectedIndex();
        int n2 = this.m_GroupLevelFields.getModel().getSize();
        this.m_Left.setEnabled(n >= 0);
        this.m_Right.setEnabled(this.m_AvailableFields.getSelectedIndex() >= 0);
        this.m_Up.setEnabled(n > 0);
        this.m_Down.setEnabled(n >= 0 && n < n2 - 1);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_Left) {
            this.remove();
        } else if (object == this.m_Right) {
            this.add();
        } else if (object == this.m_Options) {
            this.setMoreGroupOption();
        } else if (object == this.m_Up) {
            this.up();
        } else if (object == this.m_Down) {
            this.down();
        }
        this.updateButtons();
    }

    public List<FieldValue> getSelectedDetailFields() {
        ArrayList<FieldValue> arrayList = new ArrayList<FieldValue>();
        int n = this.m_Field.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add((FieldValue)this.m_Field.get(i));
        }
        return arrayList;
    }

    public List<FieldValue> getSelectedGroupFields() {
        ArrayList<FieldValue> arrayList = new ArrayList<FieldValue>();
        int n = this.m_FieldGroup.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add((FieldValue)this.m_FieldGroup.get(i));
        }
        return arrayList;
    }
}

