/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.report;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.ui.ElxTabbedPane;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.report.labels.Label;
import com.elixirtech.wizard.report.labels.LabelDimPanel;
import com.elixirtech.wizard.report.labels.LabelPagePanel;
import com.elixirtech.wizard.report.labels.LabelPreviewPanel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;

public class MailingLabelSizePage
extends RelativeLayoutWizardPage {
    public static final String NAME = "MailingLabelSizePage";
    JComboBox m_LabelTypes;
    JCheckBox m_Custom;
    LabelDimPanel m_LabelPanel;
    LabelPagePanel m_PagePanel;
    LabelPreviewPanel m_PreviewPanel;
    private static Label[] LABELS;
    private static final ElxLoggerJ m_Log;

    public MailingLabelSizePage() {
        super(NAME, null);
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.loadLabels();
        this.m_LabelTypes = SwingFactory.newComboBox("type", LABELS);
        this.m_LabelTypes.addItemListener(new MailingLabelItemListener());
        this.m_Custom = SwingFactory.newCheckBox("custom");
        this.m_Custom.addActionListener(new CodeBlock((Object)this, "custom"));
        this.m_LabelPanel = new LabelDimPanel();
        this.m_PagePanel = new LabelPagePanel();
        this.m_PreviewPanel = new LabelPreviewPanel(this);
        ElxTabbedPane elxTabbedPane = new ElxTabbedPane();
        elxTabbedPane.addTab(I18N.ERD.getString("MailingLabelSizePage.label.title"), this.m_LabelPanel);
        elxTabbedPane.addTab(I18N.ERD.getString("MailingLabelSizePage.page.title"), this.m_PagePanel);
        elxTabbedPane.addTab(I18N.ERD.getString("MailingLabelSizePage.preview.title"), this.m_PreviewPanel);
        this.addLabel(SwingFactory.newLabel("type-label"));
        this.m_Component.add(this.m_LabelTypes);
        this.m_Component.add(this.m_Custom);
        this.m_Component.add("tabs", elxTabbedPane);
        this.stickTop("type");
        this.putRight("type", "type-label", 10);
        this.stickTop("custom");
        this.stickRight("custom");
        this.putLeft("type", "custom", -10);
        this.putBelow("tabs", "type", 5);
        this.stickLeft("tabs");
        this.stickRight("tabs");
        this.stickBottom("tabs");
        if (this.m_LabelTypes.getItemCount() > 0) {
            this.m_LabelTypes.setSelectedIndex(0);
            this.setLabel(LABELS[0]);
        }
        this.custom();
        I18N.ERD_MAP.injectComponents("MailingLabelSizePage.", this.m_Component);
        I18N.ERD_MAP.injectObject(null, this, NAME);
    }

    public void custom() {
        if (this.m_Custom.isSelected()) {
            this.m_LabelTypes.setEnabled(false);
            this.m_LabelPanel.setEnabled(true);
            this.m_PagePanel.setEnabled(true);
        } else {
            this.m_LabelTypes.setEnabled(true);
            this.m_LabelPanel.setEnabled(false);
            this.m_PagePanel.setEnabled(false);
            Label label = (Label)this.m_LabelTypes.getSelectedItem();
            this.setLabel(label);
        }
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    void updatePreview() {
        this.m_PreviewPanel.setLabel(this.getLabel());
    }

    public Label getLabel() {
        Label label = new Label();
        this.m_LabelPanel.getLabel(label);
        this.m_PagePanel.getLabel(label);
        return label;
    }

    void setLabel(Label label) {
        this.m_LabelPanel.setLabel(label);
        this.m_PagePanel.setLabel(label);
        this.m_PreviewPanel.setLabel(label);
    }

    public static PageSetup buildPageSetup(Label label, boolean bl) {
        PageSetup pageSetup = new PageSetup();
        pageSetup.setName("Label");
        pageSetup.setColumnCount(MailingLabelSizePage.calcColumnCount(label));
        pageSetup.setHorizontalPageCount(1);
        pageSetup.setPaper(label.m_PaperMedia);
        pageSetup.setOrientation(label.m_PaperOrientation);
        pageSetup.setRowSpacing(label.m_GapVertical.intValue());
        pageSetup.setColumnSpacing(label.m_GapHorizontal.intValue());
        pageSetup.setLeft(label.m_PageMarginLeft.intValue());
        pageSetup.setTop(label.m_PageMarginTop.intValue());
        pageSetup.setRight(label.m_PageMarginRight.intValue());
        pageSetup.setBottom(label.m_PageMarginBottom.intValue());
        pageSetup.setWidth(label.m_PaperWidth.intValue());
        pageSetup.setHeight(label.m_PaperHeight.intValue());
        if (bl) {
            MailingLabelSizePage.adjustRightMargin(label, pageSetup);
        }
        return pageSetup;
    }

    private static int calcColumnCount(Label label) {
        int n = "Portrait".equals(label.m_PaperOrientation) ? label.m_PaperWidth.intValue() : label.m_PaperHeight.intValue();
        int n2 = label.m_Width;
        if (n2 == 0) {
            return 1;
        }
        int n3 = label.m_GapHorizontal;
        if (n2 + n3 <= 0) {
            return 1;
        }
        int n4 = label.m_PageMarginLeft;
        int n5 = n - label.m_PageMarginRight;
        int n6 = n4 + n2 + n3;
        int n7 = 1;
        while (n6 + n2 <= n5) {
            n6 = n6 + n2 + n3;
            ++n7;
        }
        return n7;
    }

    private static void adjustRightMargin(Label label, PageSetup pageSetup) {
        int n = pageSetup.getColumnCount();
        int n2 = label.m_Width * n;
        if (n > 1) {
            n2 += label.m_GapHorizontal * (n - 1);
        }
        int n3 = pageSetup.getWidth() - pageSetup.getLeft() - n2;
        pageSetup.setRight(n3);
    }

    private void loadLabels() {
        if (LABELS == null) {
            ArrayList<Label> arrayList = new ArrayList<Label>();
            try {
                InputStream inputStream = ElixirJ.getConfigStream("labels.xml");
                SAXBuilder sAXBuilder = new SAXBuilder();
                Document document = sAXBuilder.build(inputStream);
                Element element = document.getRootElement();
                for (Element element2 : element.getChildren("label")) {
                    arrayList.add(Label.build(element2));
                }
            }
            catch (Exception exception) {
                m_Log.error((Object)("Can't read labels.xml: " + String.valueOf(exception)), (Throwable)exception);
            }
            LABELS = new Label[arrayList.size()];
            arrayList.toArray(LABELS);
        }
    }

    static {
        m_Log = ElxLoggerJ.getLogger(MailingLabelSizePage.class);
    }

    class MailingLabelItemListener
    implements ItemListener {
        MailingLabelItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Label label = (Label)MailingLabelSizePage.this.m_LabelTypes.getSelectedItem();
            MailingLabelSizePage.this.setLabel(label);
        }
    }
}

