/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.report;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.UnitField;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.wizard.report.ReportWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MobileScreenSizeTargetPage
extends WizardPage
implements ListSelectionListener {
    public static final String NAME = "Device Screen Size";
    private String m_CurrentID;
    private ReportWizard m_Wizard;
    private JList m_Sizes;
    private UnitField m_Width;
    private UnitField m_Height;
    private Map<String, DefaultListModel> m_ListOfSizes;
    public static ElxLoggerJ m_Logger = ElxLoggerJ.getLogger(MobileScreenSizeTargetPage.class);

    public MobileScreenSizeTargetPage() {
        super(NAME, "MobileSelectFieldPage");
        this.buildUI();
    }

    public void buildUI() {
        Object object;
        Object object2;
        Object object3;
        this.m_ListOfSizes = new HashMap<String, DefaultListModel>();
        try {
            object3 = ElixirJ.getConfigStream("mobilescreensize.xml");
            object2 = new SAXBuilder();
            object = object2.build((InputStream)object3);
            List list = object.getRootElement().getChildren("size");
            DefaultListModel defaultListModel = new DefaultListModel();
            DefaultListModel defaultListModel2 = new DefaultListModel();
            this.m_ListOfSizes.put("Handphone", defaultListModel);
            this.m_ListOfSizes.put("PDA", defaultListModel2);
            for (Element element : list) {
                DefaultListModel defaultListModel3;
                Size size = new Size();
                size.m_Category = element.getAttributeValue("category");
                size.m_Name = element.getText();
                try {
                    size.m_Width = Integer.decode(element.getAttributeValue("width"));
                    size.m_Height = Integer.decode(element.getAttributeValue("height"));
                }
                catch (Exception exception) {
                    m_Logger.error((Object)("Unable to set value" + String.valueOf(exception)));
                }
                if ((defaultListModel3 = this.m_ListOfSizes.get(size.m_Category)) == null) continue;
                defaultListModel3.addElement(size);
            }
        }
        catch (Exception exception) {
            m_Logger.error((Object)("Unable to load mobilescreensize.xml" + String.valueOf(exception)));
        }
        this.m_Sizes = SwingFactory.newList("sizes");
        this.m_Sizes.addListSelectionListener(this);
        object3 = SwingFactory.newScrollPane("scollpane-size", this.m_Sizes);
        ((JComponent)object3).setBorder(BorderFactory.createTitledBorder(I18N.ERD.getString("Mobile.DeviceScreenSizes")));
        this.m_Component.setLayout(new BorderLayout());
        this.m_Component.add("Center", (Component)object3);
        object2 = new JPanel();
        object = new ArchLayout();
        ((Container)object2).setLayout((LayoutManager)object);
        ((Container)object2).add(SwingFactory.newLabel("width-label"));
        ((Container)object2).add(SwingFactory.newLabel("height-label"));
        this.m_Width = UnitField.newUnitField("width");
        ((Container)object2).add(this.m_Width);
        this.m_Height = UnitField.newUnitField("height");
        ((Container)object2).add(this.m_Height);
        ((ArchLayout)object).stickTop("width");
        ((ArchLayout)object).stickLeft("width-label");
        ((ArchLayout)object).vCenter("width-label", "width");
        ((ArchLayout)object).putRight("width", "width-label,height-label", 5);
        ((ArchLayout)object).stickRight("width");
        ((ArchLayout)object).stickLeft("height-label");
        ((ArchLayout)object).stickRight("height");
        ((ArchLayout)object).alignBelow("height", "width");
        ((ArchLayout)object).vCenter("height-label", "height");
        this.m_Component.add("South", (Component)object2);
        I18N.ERD_MAP.injectComponents("MobileScreenSizeTargetPage.", this.m_Component);
        I18N.ERD_MAP.injectObject(null, this, "MobileScreenSizeTargetPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Height.addDocumentListener(new FieldWatcher(iWizard));
        this.m_Width.addDocumentListener(new FieldWatcher(iWizard));
        this.m_Wizard = (ReportWizard)iWizard;
    }

    @Override
    public void setVisible(boolean bl) {
        String string = this.m_Wizard.getReportId();
        DefaultListModel defaultListModel = this.m_ListOfSizes.get(string);
        if (defaultListModel != null && !string.equals(this.m_CurrentID)) {
            this.m_Sizes.setModel(defaultListModel);
            this.m_CurrentID = string;
        }
    }

    public Dimension getDimension() {
        return new Dimension(this.m_Width.getIntValue(), this.m_Height.getIntValue());
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object e = this.m_Sizes.getSelectedValue();
        if (e != null) {
            Size size = (Size)e;
            this.m_Width.setIntValue(size.m_Width);
            this.m_Height.setIntValue(size.m_Height);
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    @Override
    public boolean isPageComplete() {
        boolean bl = true;
        if (this.m_Width.getIntValue() <= 0) {
            bl = false;
            this.setError(I18N.ERD.getString("MobileScreenSizeTargetPage.width.error"));
        } else if (this.m_Height.getIntValue() <= 0) {
            bl = false;
            this.setError(I18N.ERD.getString("MobileScreenSizeTargetPage.height.error"));
        } else {
            this.setError(null);
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    protected static class Size {
        public String m_Category;
        public String m_Name;
        public int m_Width;
        public int m_Height;

        protected Size() {
        }

        public String toString() {
            return this.m_Name;
        }
    }
}

