/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.report;

import com.elixirtech.arch.Elixir;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.erd.reportdesigner.chunk.UiFactory;
import com.elixirtech.erd.reportdesigner.shape.BoxShape;
import com.elixirtech.erd.reportdesigner.shape.HBoxShape;
import com.elixirtech.erd.reportdesigner.shape.VBoxShape;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.IMasterPropertyList;
import com.elixirtech.property.IStyle;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Cell;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.Detail;
import com.elixirtech.report2.raw.model.Field;
import com.elixirtech.report2.raw.model.Format;
import com.elixirtech.report2.raw.model.Group;
import com.elixirtech.report2.raw.model.GroupFooter;
import com.elixirtech.report2.raw.model.GroupHeader;
import com.elixirtech.report2.raw.model.HBox;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.PageFooter;
import com.elixirtech.report2.raw.model.PageHeader;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.SectionFooter;
import com.elixirtech.report2.raw.model.SectionHeader;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.report2.raw.model.StyleItem;
import com.elixirtech.report2.raw.model.Table;
import com.elixirtech.report2.raw.model.TableBody;
import com.elixirtech.report2.raw.model.TableFooter;
import com.elixirtech.report2.raw.model.TableHeader;
import com.elixirtech.report2.raw.model.VBox;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.wizard.report.ColumnarLayoutReportPage;
import com.elixirtech.wizard.report.ColumnarSelectFieldPage;
import com.elixirtech.wizard.report.ColumnarSelectGroupingLevelPage;
import com.elixirtech.wizard.report.ColumnarSetFieldSortingPage;
import com.elixirtech.wizard.report.FieldValue;
import com.elixirtech.wizard.report.MailingLabelSizePage;
import com.elixirtech.wizard.report.MobileScreenSizeTargetPage;
import com.elixirtech.wizard.report.MobileSelectFieldPage;
import com.elixirtech.wizard.report.MobileSelectGroupLevelPage;
import com.elixirtech.wizard.report.MobileSetFieldSortingPage;
import com.elixirtech.wizard.report.ReportInfoPage;
import com.elixirtech.wizard.report.ReportWizard;
import com.elixirtech.wizard.report.StandardReportPage;
import com.elixirtech.wizard.report.labels.Label;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ReportFactory {
    static IMasterPropertyList m_MasterPropertyList;
    static Component m_Component;
    static final String DEFAULT_TEXT_FONT_FAMILY = "Serif";
    static final int DEFAULT_TEXT_FONTSIZE = 240;
    static final int DEFAULT_HEADER_TEXT_FONTSIZE = 400;
    static final int WIDTH = 0;
    static final int HEIGHT = 1;
    static final int TOP = 2;
    static final int LEFT = 3;
    static final int BOTTOM = 4;
    static final int RIGHT = 5;
    static final int WIDTH_LAYOUT = 6;
    static Name[] TEXT_ELEMENT_NAMES;

    ReportFactory() {
    }

    public static void createReport(ReportWizard reportWizard) {
        m_MasterPropertyList = (IMasterPropertyList)Elixir.get(IMasterPropertyList.class);
        m_Component = reportWizard.getPages()[0].getComponent();
        assert (m_MasterPropertyList != null);
        assert (m_Component != null);
        if ("Tabular".equals(reportWizard.getReportId())) {
            ReportFactory.createSimpleReport(reportWizard);
        } else if ("Table".equals(reportWizard.getReportId())) {
            ReportFactory.createTabularReport(reportWizard);
        } else if ("Labels".equals(reportWizard.getReportId())) {
            ReportFactory.createLabels(reportWizard);
        } else if ("Columnar".equals(reportWizard.getReportId())) {
            ReportFactory.createColumnarReport(reportWizard);
        } else if ("Handphone".equals(reportWizard.getReportId()) || "PDA".equals(reportWizard.getReportId())) {
            ReportFactory.createMobileReport(reportWizard);
        } else {
            ReportFactory.createBlankReport(reportWizard);
        }
        m_MasterPropertyList = null;
        m_Component = null;
    }

    private static void createSimpleReport(ReportWizard reportWizard) {
        HBoxShape hBoxShape;
        ControlSource controlSource;
        reportWizard.setDefaultValues("standard.rml");
        RawReport rawReport = reportWizard.getReport();
        Section section = reportWizard.getReport().getSection(0);
        Style[] styleArray = ReportFactory.createStyle(rawReport, "page", DEFAULT_TEXT_FONT_FAMILY, 240);
        Point point = new Point(20, 240);
        int[] nArray = ReportFactory.setupPage(rawReport, section, true, styleArray, point);
        SectionHeader sectionHeader = section.getSectionHeader();
        SectionFooter sectionFooter = section.getSectionFooter();
        sectionHeader.setGrowable(true);
        sectionHeader.setShrinkable(true);
        sectionFooter.setGrowable(true);
        sectionFooter.setHeight(400);
        sectionFooter.setShrinkable(true);
        Detail detail = section.getDetail();
        detail.removeAllRawElements();
        detail.setGrowable(true);
        detail.setShrinkable(true);
        detail.setHeight(400);
        StandardReportPage standardReportPage = (StandardReportPage)reportWizard.getPage("Standard Report");
        DataSchema dataSchema = standardReportPage.getDataSchema();
        String[] stringArray = standardReportPage.getChosenFields();
        if (stringArray.length < 1) {
            return;
        }
        Field[] fieldArray = ReportFactory.createFields(stringArray, "Literal", dataSchema);
        Field[] fieldArray2 = ReportFactory.createFields(stringArray, "Field", dataSchema);
        for (int i = 0; i < fieldArray2.length; ++i) {
            controlSource = fieldArray2[i].getControlSource();
            controlSource.setText(controlSource.getField());
        }
        Style style = ReportFactory.createTextElementStyle("simple.label", DEFAULT_TEXT_FONT_FAMILY, 240, Boolean.TRUE, Boolean.FALSE, null, null);
        controlSource = I18N.getName("RawElement.Growable");
        Name name = I18N.getName("RawElement.Shrinkable");
        Name name2 = I18N.getName("RawElement.PaddingLeft");
        Name name3 = I18N.getName("RawElement.PaddingRight");
        style.addStyleItem(ReportFactory.createStyleItem((Name)controlSource, Boolean.TRUE));
        style.addStyleItem(ReportFactory.createStyleItem(name2, 40));
        style.addStyleItem(ReportFactory.createStyleItem(name3, 40));
        Style style2 = ReportFactory.createTextElementStyle("simple.text", DEFAULT_TEXT_FONT_FAMILY, 240, Boolean.FALSE, Boolean.FALSE, null, null);
        style2.addStyleItem(ReportFactory.createStyleItem((Name)controlSource, Boolean.TRUE));
        style2.addStyleItem(ReportFactory.createStyleItem(name, Boolean.FALSE));
        style2.addStyleItem(ReportFactory.createStyleItem(name2, 40));
        style2.addStyleItem(ReportFactory.createStyleItem(name3, 40));
        Style[] styleArray2 = ReportFactory.createStyle(rawReport, "section", DEFAULT_TEXT_FONT_FAMILY, 400);
        ReportInfoPage reportInfoPage = (ReportInfoPage)reportWizard.getPage("Report Info");
        ReportFactory.setTitle(reportInfoPage.getReportName(), section, styleArray2, point);
        sectionHeader.setHeight(1200);
        rawReport.addStyle(style);
        rawReport.addStyle(style2);
        FontMetrics fontMetrics = ReportFactory.getFontMetric(style);
        ReportFactory.addBorderStyle(style);
        ReportFactory.addBorderStyle(style2);
        int n = nArray[6];
        int n2 = n / fieldArray2.length;
        int n3 = 0;
        HBox hBox = new HBox();
        hBox.setFill(true);
        hBox.setVisible(true);
        hBox.setHeight(400);
        hBox.setTop(800);
        hBox.setLeft(0);
        hBox.setWidth(n);
        sectionHeader.addRawElement((RawModelElement)hBox);
        HBox hBox2 = new HBox();
        hBox2.setFill(true);
        hBox2.setVisible(true);
        hBox2.setHeight(400);
        hBox2.setTop(0);
        hBox2.setLeft(0);
        hBox2.setWidth(n);
        detail.addRawElement((RawModelElement)hBox2);
        for (int i = 0; i < fieldArray2.length; ++i) {
            fieldArray[i].setStyle((IStyle)style);
            fieldArray2[i].setStyle((IStyle)style2);
            hBoxShape = new Cell();
            hBoxShape.setFill(true);
            hBoxShape.setTop(1);
            hBoxShape.setLeft(n3);
            hBoxShape.setWidth(n2);
            hBoxShape.setHeight(fontMetrics.getHeight() * 20);
            hBoxShape.addRawElement((RawModelElement)fieldArray[i]);
            hBox.addCell((Cell)hBoxShape);
            hBoxShape = new Cell();
            hBoxShape.setFill(true);
            hBoxShape.setTop(401);
            hBoxShape.setLeft(n3);
            hBoxShape.setWidth(n2);
            hBoxShape.setHeight(fontMetrics.getHeight() * 20);
            hBoxShape.addRawElement((RawModelElement)fieldArray2[i]);
            hBox2.addCell((Cell)hBoxShape);
            n3 += n2;
        }
        HBoxShape hBoxShape2 = (HBoxShape)UiFactory.current().buildShape((RawModelElement)hBox);
        hBoxShape2.layoutCells();
        hBoxShape = (HBoxShape)UiFactory.current().buildShape((RawModelElement)hBox2);
        hBoxShape.layoutCells();
    }

    public static void createTabularReport(ReportWizard reportWizard) {
        HBoxShape hBoxShape;
        ControlSource controlSource;
        reportWizard.setDefaultValues("standard.rml");
        RawReport rawReport = reportWizard.getReport();
        Section section = reportWizard.getReport().getSection(0);
        Style[] styleArray = ReportFactory.createStyle(rawReport, "page", DEFAULT_TEXT_FONT_FAMILY, 240);
        Point point = new Point(20, 2400);
        int[] nArray = ReportFactory.setupPage(rawReport, section, true, styleArray, point);
        SectionHeader sectionHeader = section.getSectionHeader();
        SectionFooter sectionFooter = section.getSectionFooter();
        sectionHeader.setGrowable(true);
        sectionHeader.setShrinkable(false);
        sectionFooter.setGrowable(true);
        sectionFooter.setShrinkable(true);
        Detail detail = section.getDetail();
        detail.removeAllRawElements();
        detail.setGrowable(true);
        detail.setShrinkable(true);
        StandardReportPage standardReportPage = (StandardReportPage)reportWizard.getPage("Standard Report");
        DataSchema dataSchema = standardReportPage.getDataSchema();
        String[] stringArray = standardReportPage.getChosenFields();
        if (stringArray.length < 1) {
            return;
        }
        Field[] fieldArray = ReportFactory.createFields(stringArray, "Literal", dataSchema);
        Field[] fieldArray2 = ReportFactory.createFields(stringArray, "Field", dataSchema);
        for (int i = 0; i < fieldArray2.length; ++i) {
            controlSource = fieldArray2[i].getControlSource();
            controlSource.setDataSource("Default");
            controlSource.setText("Default:" + controlSource.getField());
        }
        Style style = ReportFactory.createTextElementStyle("table.label", DEFAULT_TEXT_FONT_FAMILY, 240, Boolean.TRUE, Boolean.FALSE, null, null);
        controlSource = ReportFactory.createTextElementStyle("table.text", DEFAULT_TEXT_FONT_FAMILY, 240, Boolean.FALSE, Boolean.FALSE, null, null);
        style.addStyleItem(ReportFactory.createStyleItem(I18N.getName("RawElement.PaddingLeft"), 40));
        style.addStyleItem(ReportFactory.createStyleItem(I18N.getName("RawElement.PaddingRight"), 40));
        controlSource.addStyleItem(ReportFactory.createStyleItem(I18N.getName("RawElement.PaddingLeft"), 40));
        controlSource.addStyleItem(ReportFactory.createStyleItem(I18N.getName("RawElement.PaddingRight"), 40));
        rawReport.addStyle(style);
        rawReport.addStyle((Style)controlSource);
        FontMetrics fontMetrics = ReportFactory.getFontMetric(style);
        ReportFactory.addBorderStyle(style);
        ReportFactory.addBorderStyle((Style)controlSource);
        int n = (int)((double)nArray[6] * 0.95);
        Table table = new Table();
        table.setName("Table");
        table.setCache(section.getDataSource());
        section.setDataSource("");
        table.setGrowable(true);
        table.setShrinkable(true);
        TableHeader tableHeader = null;
        TableBody tableBody = null;
        TableFooter tableFooter = null;
        sectionHeader.addRawElement((RawModelElement)table);
        tableHeader = new TableHeader();
        table.setHeader(tableHeader);
        tableBody = new TableBody();
        table.setBody(tableBody);
        tableFooter = new TableFooter();
        table.setFooter(tableFooter);
        table.setLeft(0);
        table.setTop(0);
        table.setHeight(1200);
        table.setWidth(nArray[6]);
        tableHeader.setLeft(0);
        tableHeader.setTop(0);
        tableHeader.setHeight(400);
        tableHeader.setWidth(nArray[6]);
        tableBody.setLeft(0);
        tableBody.setTop(400);
        tableBody.setHeight(400);
        tableBody.setWidth(nArray[6]);
        tableFooter.setLeft(0);
        tableFooter.setTop(800);
        tableFooter.setHeight(400);
        tableFooter.setWidth(nArray[6]);
        int n2 = n / fieldArray2.length;
        int n3 = 0;
        HBox hBox = new HBox();
        hBox.setVisible(true);
        hBox.setHeight(400);
        hBox.setTop(0);
        hBox.setLeft(0);
        hBox.setWidth(n);
        hBox.setParent((IRawElementHolder)tableHeader);
        tableHeader.addRawElement((RawModelElement)hBox);
        HBox hBox2 = new HBox();
        hBox2.setVisible(true);
        hBox2.setHeight(400);
        hBox2.setTop(401);
        hBox2.setLeft(0);
        hBox2.setWidth(n);
        hBox2.setParent((IRawElementHolder)tableBody);
        tableBody.addRawElement((RawModelElement)hBox2);
        for (int i = 0; i < fieldArray2.length; ++i) {
            fieldArray[i].setStyle((IStyle)style);
            fieldArray2[i].setStyle((IStyle)controlSource);
            hBoxShape = new Cell();
            hBoxShape.setFill(true);
            hBoxShape.setTop(1);
            hBoxShape.setLeft(n3);
            hBoxShape.setWidth(n2);
            hBoxShape.setHeight(fontMetrics.getHeight() * 20);
            hBoxShape.addRawElement((RawModelElement)fieldArray[i]);
            hBox.addCell((Cell)hBoxShape);
            hBoxShape = new Cell();
            hBoxShape.setFill(true);
            hBoxShape.setTop(401);
            hBoxShape.setLeft(n3);
            hBoxShape.setWidth(n2);
            hBoxShape.setHeight(fontMetrics.getHeight() * 20);
            hBoxShape.addRawElement((RawModelElement)fieldArray2[i]);
            hBox2.addCell((Cell)hBoxShape);
            n3 += n2;
        }
        HBoxShape hBoxShape2 = (HBoxShape)UiFactory.current().buildShape((RawModelElement)hBox);
        hBoxShape2.layoutCells();
        hBoxShape = (HBoxShape)UiFactory.current().buildShape((RawModelElement)hBox2);
        hBoxShape.layoutCells();
    }

    private static void addBorderStyle(Style style) {
        Name name = I18N.getName("Rectangle.BorderLeft");
        Name name2 = I18N.getName("Rectangle.BorderRight");
        Name name3 = I18N.getName("Rectangle.BorderTop");
        Name name4 = I18N.getName("Rectangle.BorderBottom");
        style.addStyleItem(ReportFactory.createStyleItem(name, Boolean.TRUE));
        style.addStyleItem(ReportFactory.createStyleItem(name2, Boolean.TRUE));
        style.addStyleItem(ReportFactory.createStyleItem(name3, Boolean.TRUE));
        style.addStyleItem(ReportFactory.createStyleItem(name4, Boolean.TRUE));
        Name name5 = I18N.getName("RawElement.BorderStyle");
        Name name6 = I18N.getName("RawElement.BorderWidth");
        Name name7 = I18N.getName("RawElement.BorderColor");
        style.addStyleItem(ReportFactory.createStyleItem(name5, "Solid"));
        style.addStyleItem(ReportFactory.createStyleItem(name6, 20));
        style.addStyleItem(ReportFactory.createStyleItem(name7, "rgb(0,0,0)"));
    }

    public static void createColumnarReport(ReportWizard reportWizard) {
        reportWizard.setDefaultValues("standard.rml");
        RawReport rawReport = reportWizard.getReport();
        Section section = rawReport.getSection(0);
        ReportInfoPage reportInfoPage = (ReportInfoPage)reportWizard.getPage("Report Info");
        ColumnarSelectFieldPage columnarSelectFieldPage = (ColumnarSelectFieldPage)reportWizard.getPage("Columnar Select Field");
        ColumnarSelectGroupingLevelPage columnarSelectGroupingLevelPage = (ColumnarSelectGroupingLevelPage)reportWizard.getPage("Columnar Group Level Selection Page");
        ColumnarSetFieldSortingPage columnarSetFieldSortingPage = (ColumnarSetFieldSortingPage)reportWizard.getPage("Columnar Set Field Sorting Page");
        ColumnarLayoutReportPage columnarLayoutReportPage = (ColumnarLayoutReportPage)reportWizard.getPage("Columnar Layout Report");
        Field[] fieldArray = ReportFactory.createFields(columnarSelectFieldPage.getChosenFields(), "Literal", columnarSelectFieldPage.getDataSchema());
        Field[] fieldArray2 = ReportFactory.createFields(columnarSelectFieldPage.getChosenFields(), "Field", columnarSelectFieldPage.getDataSchema());
        Group[] groupArray = ReportFactory.createGroups(section, columnarSelectGroupingLevelPage.getSelectedGroupFields());
        ReportFactory.createSortGroups(section, columnarSetFieldSortingPage);
        Style[][] styleArray = ReportFactory.createGroupHeaderStyles(rawReport, groupArray.length, DEFAULT_TEXT_FONT_FAMILY, 400);
        Style[] styleArray2 = ReportFactory.createStyle(rawReport, "section", DEFAULT_TEXT_FONT_FAMILY, 400);
        Style[] styleArray3 = ReportFactory.createStyle(rawReport, "page", DEFAULT_TEXT_FONT_FAMILY, 240);
        Style[] styleArray4 = ReportFactory.createStyle(rawReport, "detail", DEFAULT_TEXT_FONT_FAMILY, 240);
        Point point = new Point(20, 240);
        int[] nArray = ReportFactory.setupPage(rawReport, section, columnarLayoutReportPage.isPortrait(), styleArray3, point);
        ReportFactory.setTitle(reportInfoPage.getReportName(), section, styleArray2, point);
        String string = columnarLayoutReportPage.getLayout();
        Detail detail = section.getDetail();
        if (detail == null) {
            detail = new Detail();
            section.setDetail(detail);
        }
        if (string.equals("Block")) {
            ReportFactory.doBlockLayout(rawReport.getPageSetup(0), nArray, columnarLayoutReportPage.isKeepInOnePage(), styleArray4, groupArray, section.getPageHeader(), detail, fieldArray, fieldArray2, point);
        } else if (string.equals("Step")) {
            ReportFactory.doStepLayout(rawReport.getPageSetup(0), nArray, columnarLayoutReportPage.isKeepInOnePage(), styleArray4, groupArray, styleArray, section.getPageHeader(), detail, fieldArray, fieldArray2, point);
        } else if (string.equals("Outline")) {
            ReportFactory.doOutlineLayout(false, rawReport.getPageSetup(0), groupArray, styleArray, detail, styleArray4, fieldArray, fieldArray2, point, nArray[6], columnarLayoutReportPage.isKeepInOnePage());
        } else if (string.equals("AlignLeft")) {
            ReportFactory.doOutlineLayout(true, rawReport.getPageSetup(0), groupArray, styleArray, detail, styleArray4, fieldArray, fieldArray2, point, nArray[6], columnarLayoutReportPage.isKeepInOnePage());
        }
    }

    private static void createMobileReport(ReportWizard reportWizard) {
        BoxShape boxShape;
        Cell cell;
        Cell cell2;
        Cell cell3;
        int n;
        Object object;
        String string;
        int n2;
        reportWizard.setDefaultValues("standard.rml");
        RawReport rawReport = reportWizard.getReport();
        Section section = reportWizard.getReport().getSection(0);
        PageHeader pageHeader = section.getPageHeader();
        PageFooter pageFooter = section.getPageFooter();
        if (pageHeader != null) {
            pageHeader.setVisible(false);
        }
        if (pageFooter != null) {
            pageFooter.setVisible(false);
        }
        SectionHeader sectionHeader = section.getSectionHeader();
        sectionHeader.setGrowable(true);
        sectionHeader.setShrinkable(false);
        ReportInfoPage reportInfoPage = (ReportInfoPage)reportWizard.getPage("Report Info");
        MobileScreenSizeTargetPage mobileScreenSizeTargetPage = (MobileScreenSizeTargetPage)reportWizard.getPage("Device Screen Size");
        Dimension dimension = mobileScreenSizeTargetPage.getDimension();
        PageSetup pageSetup = rawReport.getPageSetup(0);
        pageSetup.setWidth(dimension.width);
        pageSetup.setHeight(dimension.height);
        pageSetup.setRight(0);
        pageSetup.setLeft(0);
        pageSetup.setTop(0);
        pageSetup.setBottom(0);
        MobileSelectFieldPage mobileSelectFieldPage = (MobileSelectFieldPage)reportWizard.getPage("MobileSelectFieldPage");
        MobileSelectGroupLevelPage mobileSelectGroupLevelPage = (MobileSelectGroupLevelPage)reportWizard.getPage("MobileSelectGroupLevelPage");
        MobileSetFieldSortingPage mobileSetFieldSortingPage = (MobileSetFieldSortingPage)reportWizard.getPage("MobileSetFieldSortingPage");
        DataSchema dataSchema = mobileSelectFieldPage.getDataSchema();
        Field[] fieldArray = ReportFactory.createFields(mobileSelectFieldPage.getChosenFields(), "Literal", dataSchema);
        Field[] fieldArray2 = ReportFactory.createFields(mobileSelectFieldPage.getChosenFields(), "Field", dataSchema);
        Style[] styleArray = ReportFactory.createStyle(rawReport, "section", DEFAULT_TEXT_FONT_FAMILY, 400);
        ReportFactory.setTitle(reportInfoPage.getReportName(), section, styleArray, new Point(20, 0));
        Group[] groupArray = ReportFactory.createGroups(section, mobileSelectGroupLevelPage.getSelectedGroupFields());
        ReportFactory.createSortGroups(section, mobileSetFieldSortingPage);
        Detail detail = section.getDetail();
        if (detail == null) {
            detail = new Detail();
            section.setDetail(detail);
        }
        detail.setGrowable(true);
        detail.setShrinkable(true);
        detail.removeAllRawElements();
        Style[][] styleArray2 = ReportFactory.createGroupHeaderStyles(rawReport, groupArray.length, DEFAULT_TEXT_FONT_FAMILY, 398);
        Style[] styleArray3 = ReportFactory.createStyle(rawReport, "detail", DEFAULT_TEXT_FONT_FAMILY, 238);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n2 = 0; n2 < groupArray.length; ++n2) {
            arrayList.add(groupArray[n2].getField());
        }
        for (n2 = 0; n2 < groupArray.length; ++n2) {
            string = groupArray[n2].getField();
            object = groupArray[n2].getGroupHeader();
            HBox hBox = new HBox();
            FontMetrics fontMetrics = ReportFactory.getFontMetric(styleArray2[n2][0]);
            n = fontMetrics.getHeight() * 20;
            hBox.setVisible(true);
            hBox.setTop(0);
            hBox.setLeft(0);
            hBox.setFill(true);
            object.addRawElement((RawModelElement)hBox);
            hBox.setHeight(n);
            hBox.setWidth(dimension.width - 20);
            for (int i = 0; i < fieldArray2.length; ++i) {
                if (fieldArray2[i] == null || !fieldArray2[i].getName().equals(string)) continue;
                cell3 = ReportFactory.newCell(50, true);
                cell2 = ReportFactory.newCell(50, true);
                hBox.addCell(cell3);
                hBox.addCell(cell2);
                fieldArray[i].setStyle((IStyle)styleArray2[n2][0]);
                object.setHeight(n + 20);
                cell = new ControlSource(string);
                cell.setType("Field");
                cell.setField(string);
                object.setControlSource((ControlSource)cell);
                object.setTableOfContents(true);
                fieldArray[i].setFill(true);
                fieldArray[i].setHeight(n);
                cell3.addRawElement((RawModelElement)fieldArray[i]);
                fieldArray2[i].setStyle((IStyle)styleArray2[n2][1]);
                fieldArray2[i].setFill(true);
                fieldArray2[i].setHeight(n);
                cell2.addRawElement((RawModelElement)fieldArray2[i]);
                fieldArray[i] = null;
                fieldArray2[i] = null;
            }
            boxShape = (HBoxShape)UiFactory.current().buildShape((RawModelElement)hBox);
            ((HBoxShape)boxShape).layoutCells();
        }
        n2 = fieldArray2.length - groupArray.length;
        detail.setHeight(n2 * 20 * 10);
        string = new VBox();
        string.setTop(0);
        string.setLeft(0);
        string.setFill(true);
        detail.addRawElement((RawModelElement)string);
        object = ReportFactory.getFontMetric(styleArray3[0]);
        int n3 = ((FontMetrics)object).getHeight() * 20;
        int n4 = 0;
        for (n = 0; n < fieldArray2.length; ++n) {
            if (fieldArray2[n] == null) continue;
            fieldArray[n].setStyle((IStyle)styleArray3[0]);
            fieldArray2[n].setStyle((IStyle)styleArray3[1]);
            boxShape = new Cell();
            string.addCell((Cell)boxShape);
            boxShape.setWeight(100 / n2);
            cell3 = ReportFactory.newHBox(n4);
            boxShape.addRawElement((RawModelElement)cell3);
            cell2 = ReportFactory.newCell(50, true);
            cell = ReportFactory.newCell(50, true);
            cell2.addRawElement((RawModelElement)fieldArray[n]);
            fieldArray[n].setFill(true);
            fieldArray[n].setHeight(n3);
            cell.addRawElement((RawModelElement)fieldArray2[n]);
            fieldArray2[n].setFill(true);
            fieldArray2[n].setHeight(n3);
            cell3.addCell(cell2);
            cell3.addCell(cell);
            n4 += n3;
            HBoxShape hBoxShape = (HBoxShape)UiFactory.current().buildShape((RawModelElement)cell3);
            hBoxShape.layoutCells();
        }
        n = n4 + n3;
        string.setHeight(n);
        string.setWidth(dimension.width - 20);
        detail.setHeight(n + 100);
        boxShape = (VBoxShape)UiFactory.current().buildShape((RawModelElement)string);
        ((VBoxShape)boxShape).layoutCells();
    }

    private static Cell newCell(int n, boolean bl) {
        Cell cell = new Cell();
        cell.setWeight(n);
        cell.setFill(bl);
        return cell;
    }

    private static HBox newHBox(int n) {
        HBox hBox = new HBox();
        hBox.setVisible(true);
        hBox.setTop(n);
        hBox.setLeft(0);
        hBox.setFill(true);
        return hBox;
    }

    private static void doOutlineLayout(boolean bl, PageSetup pageSetup, Group[] groupArray, Style[][] styleArray, Detail detail, Style[] styleArray2, Field[] fieldArray, Field[] fieldArray2, Point point, int n, boolean bl2) {
        int n2;
        int n3;
        int n4;
        Serializable serializable;
        Object object;
        int n5;
        int n6 = point.x;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < groupArray.length; ++i) {
            arrayList.add(groupArray[i].getField());
        }
        int[] nArray = new int[fieldArray.length];
        int n7 = 0;
        Object object2 = null;
        for (n5 = 0; n5 < groupArray.length; ++n5) {
            String string = groupArray[n5].getField();
            object = groupArray[n5].getGroupHeader();
            for (int i = 0; i < fieldArray2.length; ++i) {
                if (fieldArray2[i] == null || !fieldArray2[i].getName().equals(string)) continue;
                object.addRawElement((RawModelElement)fieldArray[i]);
                object.addRawElement((RawModelElement)fieldArray2[i]);
                serializable = ReportFactory.getFontMetric(styleArray[n5][0]);
                fieldArray[i].setStyle((IStyle)styleArray[n5][0]);
                int n8 = ((FontMetrics)serializable).getHeight() * 20;
                n4 = ((FontMetrics)serializable).stringWidth(string) * 20 + 20;
                fieldArray2[i].setStyle((IStyle)styleArray[n5][1]);
                fieldArray[i].setHeight(n8);
                fieldArray2[i].setHeight(n8);
                fieldArray[i].setWidth(n4);
                fieldArray2[i].setWidth(n4 * 2);
                fieldArray[i].setTop(n8 / 2);
                fieldArray2[i].setTop(n8 / 2);
                fieldArray[i].setLeft(n6);
                fieldArray2[i].setLeft(n4 + n4 / 2 + n6);
                nArray[n5] = n4;
                fieldArray[i] = null;
                fieldArray2[i] = null;
                object.setHeight(n8 * 2);
                object2 = object;
                if (bl) continue;
                n6 += n4;
            }
        }
        n5 = n6;
        int n9 = 0;
        if (object2 != null) {
            n9 = object2.getHeight() / 2 * 3;
        }
        object = new ArrayList();
        ArrayList<Field> arrayList2 = new ArrayList<Field>();
        serializable = new ArrayList();
        FontMetrics fontMetrics = ReportFactory.getFontMetric(styleArray2[0]);
        n4 = fontMetrics.getHeight() * 20;
        for (n3 = 0; n3 < fieldArray2.length; ++n3) {
            if (fieldArray2[n3] == null) continue;
            fieldArray[n3].setStyle((IStyle)styleArray2[0]);
            fieldArray2[n3].setStyle((IStyle)styleArray2[1]);
            if (object2 != null) {
                object2.addRawElement((RawModelElement)fieldArray[n3]);
            }
            detail.addRawElement((RawModelElement)fieldArray2[n3]);
            fieldArray[n3].setHeight(n4);
            fieldArray2[n3].setHeight(n4);
            if (object2 != null) {
                object2.setHeight(n9);
            }
            fieldArray[n3].setTop(n9 * 2 / 3);
            fieldArray2[n3].setTop(20);
            n2 = fontMetrics.stringWidth(fieldArray[n3].getName()) * 20;
            fieldArray[n3].setWidth(n2);
            fieldArray2[n3].setWidth(n2);
            n7 += n2;
            ((ArrayList)object).add(fieldArray[n3]);
            arrayList2.add(fieldArray2[n3]);
            ((ArrayList)serializable).add(n2);
        }
        if (n7 > n && !bl2) {
            pageSetup.setHorizontalPageCount(2);
        } else {
            n7 = n - n5;
            n3 = n7 / ((ArrayList)serializable).size();
            for (n2 = 0; n2 < ((ArrayList)serializable).size(); ++n2) {
                Field field = (Field)arrayList2.get(n2);
                field.setWidth(n3);
                field.setLeft(n5);
                Field field2 = (Field)((ArrayList)object).get(n2);
                field2.setWidth(n3);
                field2.setLeft(n5);
                n5 += n3;
            }
        }
        if (fieldArray.length > 0) {
            detail.setHeight(n4);
        } else {
            detail.setHeight(0);
        }
    }

    private static void doStepLayout(PageSetup pageSetup, int[] nArray, boolean bl, Style[] styleArray, Group[] groupArray, Style[][] styleArray2, PageHeader pageHeader, Detail detail, Field[] fieldArray, Field[] fieldArray2, Point point) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < groupArray.length; ++i) {
            arrayList.add(groupArray[i].getField());
        }
        int[] nArray2 = new int[fieldArray.length];
        int n2 = 0;
        for (n = 0; n < fieldArray.length; ++n) {
            fieldArray[n].setStyle((IStyle)styleArray[0]);
            nArray2[n] = ReportFactory.setDimension(fieldArray[n], fieldArray2[n], styleArray);
            if (arrayList.contains(fieldArray2[n].getName())) continue;
            detail.addRawElement((RawModelElement)fieldArray2[n]);
            n2 += nArray2[n];
        }
        for (n = 0; n < groupArray.length; ++n) {
            String string = groupArray[n].getField();
            GroupHeader groupHeader = groupArray[n].getGroupHeader();
            for (int i = 0; i < fieldArray2.length; ++i) {
                if (!fieldArray2[i].getName().equals(string)) continue;
                fieldArray2[i].setStyle((IStyle)styleArray2[n][1]);
                FontMetrics fontMetrics = ReportFactory.getFontMetric(styleArray2[n][1]);
                int n3 = fontMetrics.getHeight() * 20;
                fieldArray2[i].setHeight(n3);
                groupHeader.addRawElement((RawModelElement)fieldArray2[i]);
                groupHeader.setHeight(n3 * 2);
            }
        }
        ReportFactory.doLayoutBlockFields(n2, nArray[6], nArray2, pageSetup, bl, fieldArray, fieldArray2, point);
        if (fieldArray.length > 0) {
            detail.setHeight(fieldArray[0].getHeight());
        } else {
            detail.setHeight(0);
        }
    }

    private static void doBlockLayout(PageSetup pageSetup, int[] nArray, boolean bl, Style[] styleArray, Group[] groupArray, PageHeader pageHeader, Detail detail, Field[] fieldArray, Field[] fieldArray2, Point point) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < groupArray.length; ++i) {
            groupArray[i].getGroupHeader().setHeight(0);
            groupArray[i].getGroupHeader().setGrowable(false);
            arrayList.add(groupArray[i].getField());
        }
        int[] nArray2 = new int[fieldArray.length];
        int n = 0;
        for (int i = 0; i < fieldArray.length; ++i) {
            fieldArray[i].setStyle((IStyle)styleArray[0]);
            pageHeader.addRawElement((RawModelElement)fieldArray[i]);
            nArray2[i] = ReportFactory.setDimension(fieldArray[i], fieldArray2[i], styleArray);
            if (arrayList.contains(fieldArray2[i].getName())) {
                fieldArray2[i].setHideDuplicates(true);
            }
            detail.addRawElement((RawModelElement)fieldArray2[i]);
            n += nArray2[i];
        }
        ReportFactory.doLayoutBlockFields(n, nArray[6], nArray2, pageSetup, bl, fieldArray, fieldArray2, point);
        if (fieldArray.length > 0) {
            detail.setHeight(fieldArray[0].getHeight());
        }
    }

    static void doLayoutBlockFields(int n, int n2, int[] nArray, PageSetup pageSetup, boolean bl, Field[] fieldArray, Field[] fieldArray2, Point point) {
        int n3;
        int n4 = point.x;
        if (n + point.x > n2) {
            if (!bl) {
                pageSetup.setHorizontalPageCount(2);
            } else {
                n = n2 - n4;
                n3 = n / fieldArray.length;
                for (var10_10 = 0; var10_10 < nArray.length; ++var10_10) {
                    nArray[var10_10] = n3;
                    fieldArray[var10_10].setWidth(n3);
                    fieldArray2[var10_10].setWidth(n3);
                }
            }
        } else {
            n = n2 - n4;
            n3 = n / fieldArray.length;
            for (var10_10 = 0; var10_10 < nArray.length; ++var10_10) {
                nArray[var10_10] = n3;
                fieldArray[var10_10].setWidth(n3);
                fieldArray2[var10_10].setWidth(n3);
            }
        }
        for (n3 = 0; n3 < fieldArray.length; ++n3) {
            fieldArray[n3].setLeft(n4);
            fieldArray[n3].setTop(0);
            fieldArray2[n3].setLeft(n4);
            fieldArray2[n3].setTop(0);
            n4 += nArray[n3];
        }
    }

    public static int setDimension(Field field, Field field2, Style[] styleArray) {
        FontMetrics fontMetrics = ReportFactory.getFontMetric(styleArray[0]);
        int n = fontMetrics.getHeight() * 20;
        String string = field.getName();
        int n2 = fontMetrics.stringWidth(string) * 20;
        field.setWidth(n2);
        field.setHeight(n);
        field.setStyle((IStyle)styleArray[0]);
        field2.setWidth(n2);
        field2.setHeight(n);
        field2.setStyle((IStyle)styleArray[1]);
        return n2;
    }

    private static void setTitle(String string, Section section, Style[] styleArray, Point point) {
        SectionHeader sectionHeader = section.getSectionHeader();
        if (sectionHeader == null) {
            sectionHeader = new SectionHeader();
            section.setSectionHeader(sectionHeader);
        }
        Field field = ReportFactory.createField(string, "Literal", styleArray[0]);
        FontMetrics fontMetrics = ReportFactory.getFontMetric(styleArray[0]);
        int n = fontMetrics.stringWidth(string) * 20 * 2;
        int n2 = fontMetrics.getHeight() * 20;
        field.setHeight(n2);
        field.setWidth(n);
        field.setLeft(point.x);
        field.setTop(point.y);
        section.getSectionHeader().setHeight(n2 * 2);
        section.getSectionHeader().addRawElement((RawModelElement)field);
        SectionFooter sectionFooter = section.getSectionFooter();
        if (sectionFooter == null) {
            sectionFooter = new SectionFooter();
            section.setSectionFooter(sectionFooter);
        }
        sectionHeader.setGrowable(true);
        sectionHeader.setHeight(n2 + 40);
        sectionFooter.setGrowable(true);
        sectionFooter.setHeight(0);
    }

    private static Style[][] createGroupHeaderStyles(RawReport rawReport, int n, String string, int n2) {
        Style[][] styleArray = new Style[n][2];
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = new Object[6];
            objectArray[0] = string;
            n2 = n2 > 12 ? n2 - 2 : 12;
            objectArray[1] = n2;
            objectArray[2] = Boolean.TRUE;
            objectArray[3] = Boolean.FALSE;
            objectArray[4] = StandardColor.STD_BLACK.toString();
            objectArray[5] = Boolean.FALSE;
            styleArray[i][0] = ReportFactory.createStyle("group" + i + ".label", TEXT_ELEMENT_NAMES, objectArray);
            rawReport.addStyle(styleArray[i][0]);
            styleArray[i][1] = ReportFactory.createStyle("group" + i + ".text", TEXT_ELEMENT_NAMES, new Object[]{string, n2, Boolean.FALSE, Boolean.FALSE, StandardColor.STD_BLACK.toString(), Boolean.FALSE});
            rawReport.addStyle(styleArray[i][1]);
        }
        return styleArray;
    }

    private static Style[] createStyle(RawReport rawReport, String string, String string2, int n) {
        Style[] styleArray = new Style[2];
        styleArray[0] = ReportFactory.createStyle(string + ".label", TEXT_ELEMENT_NAMES, new Object[]{string2, n, Boolean.TRUE, Boolean.FALSE, StandardColor.STD_BLACK.toString(), Boolean.FALSE});
        styleArray[0].addStyleItem(ReportFactory.createStyleItem(I18N.getName("RawElement.PaddingLeft"), 40));
        styleArray[0].addStyleItem(ReportFactory.createStyleItem(I18N.getName("RawElement.PaddingRight"), 40));
        styleArray[1] = ReportFactory.createStyle(string + ".text", TEXT_ELEMENT_NAMES, new Object[]{string2, n, Boolean.FALSE, Boolean.FALSE, StandardColor.STD_BLACK.toString(), Boolean.FALSE});
        styleArray[1].addStyleItem(ReportFactory.createStyleItem(I18N.getName("RawElement.PaddingLeft"), 40));
        styleArray[1].addStyleItem(ReportFactory.createStyleItem(I18N.getName("RawElement.PaddingRight"), 40));
        rawReport.addStyle(styleArray[0]);
        rawReport.addStyle(styleArray[1]);
        return styleArray;
    }

    private static int[] setupPage(RawReport rawReport, Section section, boolean bl, Style[] styleArray, Point point) {
        int[] nArray = new int[7];
        PageSetup pageSetup = rawReport.getPageSetup(0);
        nArray[2] = pageSetup.getTop();
        nArray[3] = pageSetup.getLeft();
        nArray[4] = pageSetup.getBottom();
        nArray[5] = pageSetup.getRight();
        String string = pageSetup.getOrientation();
        int n = pageSetup.getWidth();
        int n2 = pageSetup.getHeight();
        if (bl) {
            pageSetup.setOrientation("Portrait");
            if (string.equals("Landscape")) {
                pageSetup.setWidth(n2);
                pageSetup.setHeight(n);
            }
        } else {
            pageSetup.setOrientation("Landscape");
            if (string.equals("Portrait")) {
                pageSetup.setWidth(n2);
                pageSetup.setHeight(n);
            }
        }
        nArray[0] = pageSetup.getWidth();
        nArray[1] = pageSetup.getHeight();
        nArray[6] = nArray[0] - nArray[3] - nArray[5];
        FontMetrics fontMetrics = ReportFactory.getFontMetric(styleArray[1]);
        Field field = ReportFactory.createField("Date", "Script", styleArray[1]);
        field.getControlSource().setText("new java.util.Date()");
        Format format = new Format();
        format.setType("Date/Time");
        format.setDateFormat("Full");
        field.setFormat(format);
        int n3 = fontMetrics.stringWidth("   new java.util.Date()         ") * 20 + 120;
        int n4 = fontMetrics.getHeight() * 20;
        field.setTop(point.y);
        field.setLeft(point.x);
        field.setHeight(n4);
        field.setWidth(n3);
        Field field2 = ReportFactory.createField("Page", "Script", styleArray[1]);
        field2.getControlSource().setText("\"${#} of ${##}\"");
        field2.setTextAlign("Right");
        n3 = fontMetrics.stringWidth(" ${#} of ${##} ") * 2 * 20;
        field2.setTop(point.y);
        field2.setLeft(nArray[6] - n3 - point.x);
        field2.setHeight(n4);
        field2.setWidth(n3);
        section.setShowPageFooter(true);
        section.setShowPageHeader(true);
        PageFooter pageFooter = section.getPageFooter();
        if (pageFooter == null) {
            pageFooter = new PageFooter();
            section.setPageFooter(pageFooter);
        }
        pageFooter.setHeight(n4 + point.y * 2);
        pageFooter.addRawElement((RawModelElement)field);
        pageFooter.addRawElement((RawModelElement)field2);
        PageHeader pageHeader = section.getPageHeader();
        if (pageHeader == null) {
            pageHeader = new PageHeader();
            section.setPageHeader(pageHeader);
        }
        pageHeader.setHeight(n4 + point.y * 2);
        return nArray;
    }

    private static Group[] createSortGroups(Section section, ColumnarSetFieldSortingPage columnarSetFieldSortingPage) {
        Object[][] objectArray = columnarSetFieldSortingPage.getValues();
        ArrayList<Group> arrayList = new ArrayList<Group>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i][0] == null) continue;
            FieldValue fieldValue = (FieldValue)objectArray[i][0];
            String string = objectArray[i][1].toString();
            Group group = fieldValue.m_Group;
            group.setSortOrder(string);
            group.setGroupFooterVisible(false);
            group.setGroupHeaderVisible(false);
            arrayList.add(group);
            section.addGroup(group);
        }
        return arrayList.toArray(new Group[arrayList.size()]);
    }

    private static Group[] createGroups(Section section, List<FieldValue> list) {
        Group[] groupArray = new Group[list.size()];
        for (int i = 0; i < groupArray.length; ++i) {
            GroupHeader groupHeader;
            FieldValue fieldValue = list.get(i);
            groupArray[i] = fieldValue.m_Group;
            if (groupArray[i].isGroupHeaderVisible()) {
                groupHeader = new GroupHeader();
                groupHeader.setHeaderNo(i);
                groupHeader.setKeepTogether(true);
                groupArray[i].setGroupHeader(groupHeader);
            }
            if (groupArray[i].isGroupFooterVisible()) {
                groupHeader = new GroupFooter();
                groupHeader.setKeepTogether(true);
                groupHeader.setHeight(0);
                groupArray[i].setGroupFooter((GroupFooter)groupHeader);
            }
            section.addGroup(groupArray[i]);
        }
        return groupArray;
    }

    static Field[] createFields(String[] stringArray, String string, DataSchema dataSchema) {
        Field[] fieldArray = new Field[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = dataSchema.getColumnIndex(stringArray[i]);
            DataType dataType = dataSchema.getColumnType(n);
            fieldArray[i] = ReportFactory.createField(stringArray[i], string, null);
            if (!dataType.isNumeric()) continue;
            fieldArray[i].setTextAlign("Right");
        }
        return fieldArray;
    }

    public static void createLabels(ReportWizard reportWizard) {
        PageFooter pageFooter;
        PageHeader pageHeader;
        reportWizard.setDefaultValues("standard.rml");
        Section section = reportWizard.getReport().getSection(0);
        section.setShowSectionHeader(false);
        section.setShowSectionFooter(false);
        SectionHeader sectionHeader = section.getSectionHeader();
        if (sectionHeader != null) {
            sectionHeader.removeAllRawElements();
        }
        if ((pageHeader = section.getPageHeader()) != null) {
            pageHeader.setVisible(false);
        }
        if ((pageFooter = section.getPageFooter()) != null) {
            pageFooter.setVisible(false);
        }
        MailingLabelSizePage mailingLabelSizePage = (MailingLabelSizePage)reportWizard.getPage("MailingLabelSizePage");
        Label label = mailingLabelSizePage.getLabel();
        PageSetup pageSetup = MailingLabelSizePage.buildPageSetup(label, true);
        reportWizard.getReport().addPageSetup(pageSetup);
        section.setPageSetup(pageSetup.getName());
        int n = label.m_Width;
        int n2 = label.m_Height;
        int n3 = label.m_OffsetLeft;
        int n4 = label.m_OffsetTop;
        Detail detail = section.getDetail();
        detail.setKeepTogether(true);
        detail.setGrowable(false);
        detail.setShrinkable(false);
        detail.removeAllRawElements();
        detail.setHeight(n2);
        String[] stringArray = ((StandardReportPage)reportWizard.getPage("Mailing Label Select Field")).getChosenFields();
        int n5 = n4;
        int n6 = (n - n3 * 2) / 3;
        int n7 = n6 * 2;
        int n8 = 320;
        Style style = ReportFactory.createTextElementStyle("Detail.Label", null, 240, Boolean.TRUE, Boolean.FALSE, null, null);
        Style style2 = ReportFactory.createTextElementStyle("Detail.Text", null, 240, Boolean.FALSE, Boolean.FALSE, null, null);
        reportWizard.getReport().addStyle(style);
        reportWizard.getReport().addStyle(style2);
        for (int i = 0; i < stringArray.length; ++i) {
            Field field = ReportFactory.createField(stringArray[i], "Literal", style, n3, n5, n6 - 40, n8);
            detail.addRawElement((RawModelElement)field);
            Field field2 = ReportFactory.createField(stringArray[i], "Field", style2, n6 + n3, n5, n7 - 20, n8);
            detail.addRawElement((RawModelElement)field2);
            n5 += n8;
        }
    }

    public static FontMetrics getFontMetric(Style style) {
        String string = style.getProperty(TEXT_ELEMENT_NAMES[0]).getValue().toString();
        int n = (Integer)style.getProperty(TEXT_ELEMENT_NAMES[1]).getValue();
        boolean bl = (Boolean)style.getProperty(TEXT_ELEMENT_NAMES[2]).getValue();
        boolean bl2 = (Boolean)style.getProperty(TEXT_ELEMENT_NAMES[3]).getValue();
        Object object = "-";
        if (bl) {
            object = (String)object + "BOLD";
        }
        if (bl2) {
            object = (String)object + "ITALIC";
        }
        if (((String)object).length() > 1) {
            object = (String)object + "-";
        }
        String string2 = string + (String)object + n / 20;
        Font font = Font.decode(string2);
        FontMetrics fontMetrics = m_Component.getFontMetrics(font);
        return fontMetrics;
    }

    static Field createField(String string, String string2, String string3, Style style) {
        Field field = ReportFactory.createField(string2, string3, style);
        field.setName(string);
        return field;
    }

    static Field createField(String string, String string2, Style style) {
        Field field = new Field();
        field.setName(string);
        if (style != null) {
            field.setStyle((IStyle)style);
        }
        ControlSource controlSource = new ControlSource(string);
        controlSource.setType(string2);
        controlSource.setField(string);
        field.setControlSource(controlSource);
        return field;
    }

    static Field createField(String string, String string2, Style style, int n, int n2, int n3, int n4) {
        Field field = ReportFactory.createField(string, string2, style);
        field.setLeft(n);
        field.setTop(n2);
        field.setWidth(n3);
        field.setHeight(n4);
        return field;
    }

    public static Style createTextElementStyle(String string, String string2, Integer n, Boolean bl, Boolean bl2, String string3, Boolean bl3) {
        Object[] objectArray = new Object[]{string2, n, bl, bl2, string3, bl3};
        return ReportFactory.createStyle(string, TEXT_ELEMENT_NAMES, objectArray);
    }

    static Style createStyle(String string, Name[] nameArray, Object[] objectArray) {
        Style style = new Style();
        style.setName(string);
        for (int i = 0; i < nameArray.length; ++i) {
            if (objectArray[i] == null) continue;
            style.addStyleItem(ReportFactory.createStyleItem(nameArray[i], objectArray[i]));
        }
        return style;
    }

    static StyleItem createStyleItem(Name name, Object object) {
        PropertyType propertyType = m_MasterPropertyList.getPropertyType(name);
        StyleItem styleItem = new StyleItem();
        styleItem.setName(name.getName());
        styleItem.setValue(propertyType.toString(object));
        return styleItem;
    }

    static RawModelElement getElement(RawElementHolder rawElementHolder, Class<?> clazz) {
        Iterator iterator = rawElementHolder.getRawElementIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!e.getClass().equals(clazz)) continue;
            return (RawModelElement)e;
        }
        return null;
    }

    public static void createBlankReport(ReportWizard reportWizard) {
        reportWizard.setDefaultValues("blank.rml");
    }

    static {
        TEXT_ELEMENT_NAMES = new Name[]{I18N.getName("TextElement.FontName"), I18N.getName("TextElement.FontSize"), I18N.getName("TextElement.FontBold"), I18N.getName("TextElement.FontItalic"), I18N.getName("TextElement.FontColor"), I18N.getName("TextElement.FontUnderline")};
    }
}

