/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.report;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.report.ReportWizard;
import javax.swing.BorderFactory;
import javax.swing.JTextField;

public class ReportInfoPage
extends WizardPage {
    public static final String NAME = "Report Info";
    private JTextField m_ReportName;
    private JTextField m_Description;

    public ReportInfoPage() {
        super(NAME, "Choose DataSource");
    }

    public String getReportName() {
        return this.m_ReportName.getText().replaceAll("\t", " ").trim();
    }

    public String getDescription() {
        return this.m_Description.getText();
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        ArchLayout archLayout = new ArchLayout();
        this.m_Component.setLayout(archLayout);
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Component.add(SwingFactory.newLabel("name-label"));
        this.m_ReportName = SwingFactory.newTextField("name");
        this.m_ReportName.getDocument().addDocumentListener(new FieldWatcher(this.m_Wizard));
        this.m_Component.add(this.m_ReportName);
        this.m_Component.add(SwingFactory.newLabel("desc-label"));
        this.m_Description = SwingFactory.newTextField("desc");
        this.m_Component.add(this.m_Description);
        archLayout.stickLeft("name-label");
        archLayout.stickTop("name");
        archLayout.vCenter("name-label", "name");
        archLayout.putRight("name", "name-label,desc-label", 10);
        archLayout.stickRight("name");
        archLayout.stickLeft("desc-label");
        archLayout.alignBelow("desc", "name");
        archLayout.vCenter("desc-label", "desc");
        archLayout.stickRight("desc");
        I18N.ERD_MAP.injectComponents("ReportInfoPage.", this.m_Component);
        I18N.ERD_MAP.injectObject(null, this, "ReportInfoPage");
    }

    @Override
    public boolean isPageComplete() {
        String string = this.m_ReportName.getText().replaceAll("\t", " ").trim();
        boolean bl = StringUtil.notEmpty(string);
        if (bl) {
            if (string.contains("/")) {
                bl = false;
                this.setError(I18N.ERD.getString("Wizard.name-slash"));
            } else if (((ReportWizard)this.m_Wizard).isValidNewName(string)) {
                this.setError(null);
            } else {
                bl = false;
                this.setError(I18N.ERD.getString("Wizard.name-used"));
            }
        } else {
            this.setError(I18N.ERD.getString("Wizard.name-required"));
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }
}

