/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.report;

import com.brunchboy.util.swing.relativelayout.AttributeConstraint;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.repository.RepositoryConverter;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.editor.JEditor;
import com.elixirtech.editor.REJavaScriptTypes;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.ReportLoader;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.UnitField;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.OnePageWizard;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.wizard.report.SecurityPage;
import java.io.IOException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.StyledEditorKit;

public class ReportPropertiesPage
extends RelativeLayoutWizardPage
implements OnePageWizard.Page {
    private static final String PANEL_VIEW = "PanelView";
    private RawReport m_Report;
    private JTextField m_ReportName;
    private JTextField m_Description;
    private JTabbedPane m_Tabs;
    private JPanel m_Options;
    private ScriptPanel m_Scripts;
    private JCheckBox m_KeepPageCount;
    private JCheckBox m_CacheAllProperties;
    private JCheckBox m_GridEnabled;
    private JCheckBox m_GridVisible;
    private UnitField m_GridX;
    private UnitField m_GridY;
    private JCheckBox m_DisableCSVAutoWrap;
    private JCheckBox m_DisableExcelAutoWrap;

    public ReportPropertiesPage(RawReport rawReport) {
        super("ReportProperties", "Security");
        this.m_Report = rawReport;
    }

    public RawReport getReport() {
        return this.m_Report;
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_ReportName = this.addField("name", new JLabel());
        this.m_ReportName.setText(this.m_Report.getName());
        this.m_ReportName.getDocument().addDocumentListener(new FieldWatcher(this.m_Wizard));
        this.m_Description = this.addField("desc", new JLabel());
        this.m_Description.setText(this.m_Report.getDescription());
        this.m_Options = this.buildOptions();
        this.m_Scripts = new ScriptPanel(this.m_Report);
        this.m_Tabs = SwingFactory.newTabbedPane("tabs");
        this.m_Tabs.addTab(I18N.ERD.getString("ReportPropertiesPage.OPTIONS"), this.m_Options);
        this.m_Tabs.addTab(I18N.ERD.getString("ReportPropertiesPage.SCRIPTS"), this.m_Scripts);
        this.m_Component.add(this.m_Tabs);
        this.stickTop("name");
        this.putRight("name", "name-label,desc-label", 10);
        this.alignBelow("desc", "name");
        this.putBelow("tabs", "desc", 5);
        this.stickLeft("tabs");
        this.stickRight("tabs");
        this.stickBottom("tabs");
        I18N.ERD_MAP.injectComponents("ReportPropertiesPage.", this.m_Component);
        I18N.ERD_MAP.injectObject(null, this, "ReportPropertiesPage");
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            SecurityPage securityPage = (SecurityPage)this.m_Wizard.getPage("Security");
            this.m_Tabs.setVisible(!securityPage.isHideInternals());
            this.checkEnabled();
        }
    }

    public void checkEnabled() {
        SecurityPage securityPage = (SecurityPage)this.m_Wizard.getPage("Security");
        boolean bl = !securityPage.isReadOnly();
        SwingUtil.setEnabled(this.m_ReportName, bl);
        SwingUtil.setEnabled(this.m_Description, bl);
        SwingUtil.setEnabled(this.m_Options, bl);
        SwingUtil.setEnabled(this.m_Scripts, bl);
        if (bl) {
            boolean bl2 = this.m_GridEnabled.isSelected();
            this.m_GridX.setEnabled(bl2);
            this.m_GridY.setEnabled(bl2);
        }
    }

    private JPanel buildOptions() {
        ArchLayout archLayout = new ArchLayout();
        JPanel jPanel = new JPanel(archLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_KeepPageCount = SwingFactory.newCheckBox("keep");
        this.m_KeepPageCount.setSelected(this.m_Report.isKeepPageCount());
        jPanel.add(this.m_KeepPageCount);
        this.m_CacheAllProperties = SwingFactory.newCheckBox("cache");
        this.m_CacheAllProperties.setSelected(this.m_Report.isCacheAllProperties());
        jPanel.add(this.m_CacheAllProperties);
        this.m_GridEnabled = SwingFactory.newCheckBox("grid-enabled");
        this.m_GridVisible = SwingFactory.newCheckBox("grid-visible");
        jPanel.add(SwingFactory.newLabel("gridx-label"));
        jPanel.add(SwingFactory.newLabel("gridy-label"));
        this.m_GridX = new UnitField("gridx");
        this.m_GridY = new UnitField("gridy");
        this.m_GridEnabled.setSelected(this.m_Report.isGridEnabled());
        this.m_GridVisible.setSelected(this.m_Report.isGridVisible());
        this.m_GridX.setValue(this.m_Report.getGridX());
        this.m_GridY.setValue(this.m_Report.getGridY());
        this.m_GridEnabled.addItemListener(new CodeBlock((Object)this, "checkEnabled"));
        jPanel.add(this.m_GridEnabled);
        jPanel.add(this.m_GridVisible);
        jPanel.add(this.m_GridX);
        jPanel.add(this.m_GridY);
        this.m_DisableCSVAutoWrap = SwingFactory.newCheckBox("csv-wrap");
        this.m_DisableExcelAutoWrap = SwingFactory.newCheckBox("excel-wrap");
        this.m_DisableCSVAutoWrap.setSelected(this.m_Report.isDisableCSVAutoWrap());
        this.m_DisableExcelAutoWrap.setSelected(this.m_Report.isDisableExcelAutoWrap());
        jPanel.add(this.m_DisableCSVAutoWrap);
        jPanel.add(this.m_DisableExcelAutoWrap);
        archLayout.stickTop("keep");
        archLayout.stickLeft("keep");
        archLayout.alignBelow("cache", "keep");
        archLayout.alignBelow("csv-wrap", "cache", 5);
        archLayout.alignBelow("excel-wrap", "csv-wrap");
        archLayout.alignBelow("grid-enabled", "excel-wrap", 5);
        archLayout.alignBelow("grid-visible", "grid-enabled");
        archLayout.stickLeft("gridx-label");
        archLayout.vCenter("gridx-label", "gridx");
        archLayout.stickLeft("gridy-label");
        archLayout.vCenter("gridy-label", "gridy");
        archLayout.putBelow("gridx", "grid-visible");
        archLayout.putRight("gridx", "gridx-label,gridy-label", 10);
        archLayout.alignBelow("gridy", "gridx");
        return jPanel;
    }

    @Override
    public boolean isPageComplete() {
        this.setError(null);
        boolean bl = true;
        String string = this.m_ReportName.getText().replaceAll("\t", " ").trim();
        if (StringUtil.isEmpty(string)) {
            this.setError(I18N.ERD.getString("Wizard.name-required"));
            bl = false;
        } else if (string.contains("/")) {
            this.setError(I18N.ERD.getString("Wizard.name-slash"));
            bl = false;
        } else {
            if (string.endsWith(".rml")) {
                string = string.substring(0, string.length() - 4);
            }
            if (StringUtil.isEmpty(string)) {
                this.setError(I18N.ERD.getString("Wizard.name-required"));
                bl = false;
            } else {
                FileObject fileObject = RepositoryConverter.toFO(this.m_Report.getFileObject());
                FileObject fileObject2 = fileObject.getParent();
                FileObject fileObject3 = fileObject2.getChildJ(string + ".rml");
                if (fileObject3 != null && !Objects.equals(fileObject3.getName(), fileObject.getName())) {
                    this.setError(I18N.ERD.getString("Wizard.name-mustbeunique"));
                    bl = false;
                }
            }
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public boolean performFinish() {
        this.m_Report.setDescription(this.m_Description.getText());
        this.m_Report.setKeepPageCount(this.m_KeepPageCount.isSelected());
        this.m_Report.setCacheAllProperties(this.m_CacheAllProperties.isSelected());
        boolean bl = this.m_GridEnabled.isSelected();
        this.m_Report.setGridEnabled(bl);
        this.m_Report.setGridVisible(this.m_GridVisible.isSelected());
        this.m_Report.setGridX(this.m_GridX.getIntValue());
        this.m_Report.setGridY(this.m_GridY.getIntValue());
        this.m_Report.setDisableCSVAutoWrap(this.m_DisableCSVAutoWrap.isSelected());
        this.m_Report.setDisableExcelAutoWrap(this.m_DisableExcelAutoWrap.isSelected());
        this.m_Scripts.performFinish();
        this.m_Report.setDirty(true);
        SecurityPage securityPage = (SecurityPage)this.m_Wizard.getPage("Security");
        securityPage.doFinish();
        String string = this.m_Report.getName();
        String string2 = this.m_ReportName.getText().replaceAll("\t", " ").trim();
        if (string2.endsWith(".rml")) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        if (!string.equals(string2)) {
            try {
                FileObject fileObject = RepositoryConverter.toFO(this.m_Report.getFileObject());
                Path path = fileObject.getPath().parent().child(string2 + ".rml");
                ReportLoader.writeRML(this.m_Report, fileObject.rename(string2 + ".rml"));
                this.m_Report.notifyChanged("RawReport.Name");
            }
            catch (IOException iOException) {
                ElixirJ.error(I18N.ERD.getString("ReportPropertiesPage.error-save") + string2 + ".rml : " + String.valueOf(iOException), iOException);
            }
        } else if (!this.isOpen()) {
            try {
                FileObject fileObject = RepositoryConverter.toFO(this.m_Report.getFileObject());
                ReportLoader.writeRML(this.m_Report, fileObject);
            }
            catch (IOException iOException) {
                ElixirJ.error(I18N.ERD.getString("ReportPropertiesPage.error-save") + " : " + String.valueOf(iOException), iOException);
            }
        }
        return true;
    }

    protected boolean isOpen() {
        FileObject fileObject = RepositoryConverter.toFO(this.m_Report.getFileObject());
        return ((IViewModel)Elixir.get(IViewModel.class)).isOpen(fileObject);
    }

    private static class ScriptPanel
    extends JPanel {
        private final RawReport m_Report;
        private final JEditor m_OnRenderBegin;
        private final JEditor m_OnRenderEnd;

        public ScriptPanel(RawReport rawReport) {
            this.m_Report = rawReport;
            ArchLayout archLayout = new ArchLayout();
            this.setLayout(archLayout);
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            StyledEditorKit styledEditorKit = REJavaScriptTypes.kit();
            String string = this.getScriptString(this.m_Report.getOnRenderBegin());
            String string2 = this.getScriptString(this.m_Report.getOnRenderEnd());
            this.m_OnRenderBegin = new JEditor(string, styledEditorKit);
            this.m_OnRenderEnd = new JEditor(string2, styledEditorKit);
            this.add(SwingFactory.newLabel("begin-label"));
            this.add(SwingFactory.newLabel("end-label"));
            this.add(SwingFactory.newScrollPane("begin", this.m_OnRenderBegin));
            this.add(SwingFactory.newScrollPane("end", this.m_OnRenderEnd));
            archLayout.putRight("begin", "begin-label,end-label", 10);
            archLayout.stickTop("begin");
            archLayout.stickRight("begin");
            archLayout.stickLeft("begin-label");
            archLayout.vCenter("begin-label", "begin");
            archLayout.stickLeft("end-label");
            archLayout.vCenter("end-label", "end");
            archLayout.addConstraint("begin", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.VERTICAL_CENTER));
            archLayout.alignBelow("end", "begin");
            archLayout.stickRight("end");
            archLayout.stickBottom("end");
        }

        public void performFinish() {
            this.m_Report.setOnRenderBegin(this.toScript(this.m_OnRenderBegin.getText()));
            this.m_Report.setOnRenderEnd(this.toScript(this.m_OnRenderEnd.getText()));
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.m_OnRenderBegin.setEnabled(bl);
            this.m_OnRenderEnd.setEnabled(bl);
        }

        protected String getScriptString(Script script) {
            if (script == null) {
                return "";
            }
            return script.getText();
        }

        protected Script toScript(String string) {
            if (StringUtil.isEmpty(string)) {
                return null;
            }
            return new Script("javascript", string);
        }
    }
}

