/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.report;

import com.elixirtech.arch.repository.RepositoryConverter;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.wizard.report.ReportPropertiesPage;
import com.elixirtech.wizard.report.SecurityPage;

public class ReportPropertiesWizard
extends Wizard {
    private final ReportPropertiesPage m_PropertiesPage;
    private final SecurityPage m_SecurityPage;

    public ReportPropertiesWizard(RawReport rawReport) {
        super(I18N.ERD.getString("ReportPropertiesPage.title"));
        this.m_PropertiesPage = new ReportPropertiesPage(rawReport);
        this.m_SecurityPage = new SecurityPage(rawReport);
        this.m_Pages.add(this.m_PropertiesPage);
        this.m_Pages.add(this.m_SecurityPage);
        this.m_PropertiesPage.setWizard(this);
        this.m_SecurityPage.setWizard(this);
    }

    @Override
    public boolean canFinish() {
        RMLFileObject rMLFileObject = this.m_PropertiesPage.getReport().getFileObject();
        if (rMLFileObject != null && !RepositoryConverter.toFO(rMLFileObject).canWrite()) {
            return false;
        }
        return super.canFinish();
    }

    @Override
    public boolean performFinish() {
        super.performFinish();
        return this.m_PropertiesPage.performFinish();
    }
}

