/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.report;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.repository.RepositoryConverter;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.erd.reportdesigner.ReportTab;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.RMLSAXUtil;
import com.elixirtech.report2.raw.ReportLoader;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.ui.ImageManager;
import com.elixirtech.util.StringUtil;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.wizard.ConfigWizard;
import com.elixirtech.wizard.report.ChooseDatasourcePage;
import com.elixirtech.wizard.report.ReportFactory;
import com.elixirtech.wizard.report.ReportInfoPage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.swing.Icon;

public class ReportWizard
extends ConfigWizard {
    private static final String BASE = "com/elixirtech/icons/erWizards/";
    private static final String DSBASE = "com/elixirtech/icons/datasource/";
    private String m_DataSourceName;
    private String m_ReportId;
    private RawReport m_Report;
    private FileObject m_Parent;
    private FileObject m_Child;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ReportWizard.class);

    public ReportWizard(FileObject fileObject) {
        super(I18N.ERD.getString("ReportWizard.title"));
        this.m_Parent = fileObject;
        I18N.ERD_MAP.injectObject(null, this, "ReportWizard");
    }

    @Override
    protected InputStream getConfigStream() {
        return this.getClass().getClassLoader().getResourceAsStream("com/elixirtech/wizard/report/resources/report-config.xml");
    }

    @Override
    public Icon getIconResource(String string) {
        if (string.startsWith("ds ")) {
            return ImageManager.getIconResource(DSBASE + string);
        }
        return ImageManager.getIconResource(BASE + string);
    }

    public void setDataSourceName(String string) {
        this.m_DataSourceName = string;
    }

    public String getDataSourceName() {
        return this.m_DataSourceName;
    }

    public void setReportId(String string) {
        this.m_ReportId = string;
    }

    public String getReportId() {
        return this.m_ReportId;
    }

    @Override
    public boolean canFinish() {
        return this.getContainer().getCurrentPage().isPageComplete();
    }

    @Override
    public boolean performCancel() {
        return super.performCancel();
    }

    @Override
    public boolean performFinish() {
        if (super.performFinish()) {
            this.createReport();
            ReportInfoPage reportInfoPage = (ReportInfoPage)this.getPage("Report Info");
            try {
                Object object = reportInfoPage.getReportName();
                if (!((String)object).endsWith(".rml")) {
                    object = (String)object + ".rml";
                }
                this.m_Report.setDescription(reportInfoPage.getDescription());
                FileObject fileObject = this.m_Parent.createData((String)object);
                ReportLoader.writeRML(this.m_Report, fileObject);
                RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
                repositoryExplorer.select(fileObject);
                final IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
                iViewModel.openFile(fileObject, new Runnable(){

                    @Override
                    public void run() {
                        IPanelView iPanelView = iViewModel.getCurrentView();
                        if (iPanelView instanceof ReportTab) {
                            ((ReportTab)iPanelView).showDesigner();
                        }
                    }
                });
                return true;
            }
            catch (IOException iOException) {
                ElixirJ.error("Unable to save report", iOException);
            }
        }
        return false;
    }

    public RawReport getReport() {
        return this.m_Report;
    }

    public boolean isValidNewName(String object) {
        if (this.m_Child != null && this.m_Report.getName().equals(object)) {
            return true;
        }
        if (!((String)object).endsWith(".rml")) {
            object = (String)object + ".rml";
        }
        return this.m_Parent.getChild((String)object).isEmpty();
    }

    protected void createReport() {
        ReportFactory.createReport(this);
        ChooseDatasourcePage chooseDatasourcePage = (ChooseDatasourcePage)this.getPage("Choose DataSource");
        if (chooseDatasourcePage != null && chooseDatasourcePage.isPropogateParameters()) {
            this.propogateParameters();
        }
        chooseDatasourcePage.dispose();
    }

    void setDefaultValues(String string) {
        try {
            InputStream inputStream = this.getTemplateInputStream(string);
            this.m_Report = RMLSAXUtil.readRML((InputStream)inputStream);
            if (this.m_Child != null) {
                this.m_Report.setFileObject(RepositoryConverter.toFO(this.m_Child));
            }
            if (StringUtil.notEmpty(this.m_DataSourceName)) {
                DataSource dataSource = new DataSource();
                dataSource.setName("Default");
                dataSource.setDataSourceName(this.m_DataSourceName);
                this.m_Report.addDataSource(dataSource);
                this.m_Report.getSection(0).setDataSource(dataSource.getName());
            }
        }
        catch (IOException iOException) {
            m_Log.error((Object)("Can't read  report " + string), (Throwable)iOException);
        }
    }

    InputStream getTemplateInputStream(String string) throws IOException {
        File file = new File(this.getTemplateDir(), string);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream("resources/templates/" + string);
    }

    protected File getTemplateDir() {
        File file = ElixirJ.getHomeDir();
        return new File(file, "resources" + File.separator + "templates");
    }

    protected void propogateParameters() {
        if (StringUtil.notEmpty(this.m_DataSourceName)) {
            DataSource dataSource = this.m_Report.getDataSource("Default");
            DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
            try {
                IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, this.m_DataSourceName);
                List list = iDataSource.getParameters();
                for (Parameter parameter : list) {
                    String string = parameter.getName();
                    if (string.startsWith("elixir.report.ds")) continue;
                    String string2 = parameter.getType();
                    String string3 = parameter.getDefaultValue();
                    String string4 = "${" + string;
                    if (string2.length() > 0 || string3.length() > 0) {
                        string4 = string4 + "#" + string2 + "#" + string3;
                    }
                    string4 = string4 + "}";
                    com.elixirtech.report2.raw.model.Parameter parameter2 = new com.elixirtech.report2.raw.model.Parameter();
                    parameter2.setKey(string);
                    parameter2.setValue("${" + string + "}");
                    dataSource.addParameter(parameter2);
                    com.elixirtech.report2.raw.model.Parameter parameter3 = new com.elixirtech.report2.raw.model.Parameter();
                    parameter3.setKey(string);
                    parameter3.setValue(string4);
                    parameter3.setEnabled(Boolean.TRUE);
                    this.m_Report.addParameter(parameter3);
                }
            }
            catch (Throwable throwable) {
                ElixirJ.error("Can't propagate parameters: " + String.valueOf(throwable), throwable);
            }
        }
    }

    public FileObject getParent() {
        return this.m_Parent;
    }

    public FileObject getChild() {
        return this.m_Child;
    }
}

