/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.report;

import com.elixirtech.arch.ISecurity;
import com.elixirtech.arch.repository.RepositoryConverter;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Security;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.wizard.BasicSecurityPage;

public class SecurityPage
extends BasicSecurityPage {
    private final RawReport m_Report;

    public SecurityPage(RawReport rawReport) {
        assert (rawReport != null);
        this.m_Report = rawReport;
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.init();
    }

    @Override
    protected ISecurity getSecurity() {
        Security security = this.m_Report.getSecurity();
        FileObject fileObject = RepositoryConverter.toFO(this.m_Report.getFileObject());
        if (fileObject != null && !fileObject.canWrite()) {
            security.setReadOnly(true);
            this.setReadOnly(true);
        }
        return security;
    }

    @Override
    protected void setReadOnly(boolean bl) {
        if (!bl) {
            FileObject fileObject = RepositoryConverter.toFO(this.m_Report.getFileObject());
            if (fileObject != null && !fileObject.canWrite()) {
                super.setReadOnly(true);
            }
        } else {
            super.setReadOnly(bl);
        }
    }

    @Override
    protected void setDirty(boolean bl) {
        this.m_Report.setDirty(bl);
    }

    @Override
    protected String getModuleName() {
        return "Report";
    }
}

