/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.report;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.grouping.GrouperFactory;
import com.elixirtech.erd.UIConstants;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.report.FieldValue;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SortDialog
extends JDialog {
    private FieldValue m_Field;
    private boolean m_IsOk;
    private ArchLayout m_Layout;
    private JComboBox m_Name;
    private I18NComboBox m_SortOrder;
    private I18NComboBox m_GroupOn;
    private JTextField m_GroupData;
    private JLabel m_DataLabel;
    private JCheckBox m_ShowGroupHeader;
    private JCheckBox m_ShowGroupFooter;
    private JButton m_Ok;
    private JButton m_Cancel;

    public SortDialog(JFrame jFrame, String string, FieldValue fieldValue) {
        super((Frame)jFrame, true);
        this.setTitle(string);
        this.m_Field = fieldValue;
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.buildUI(), "Center");
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.buildButtons(jPanel);
        this.getContentPane().add((Component)jPanel, "South");
        I18N.ERD_MAP.injectComponents("SortDialog.", this);
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    public void ok() {
        this.m_Field.m_Group.setField((String)this.m_Name.getSelectedItem());
        this.m_Field.m_Group.setSortOrder(this.m_SortOrder.getSelectedId());
        this.m_Field.m_Group.setGroupOn(this.m_GroupOn.getSelectedId());
        if (this.m_GroupData.isVisible()) {
            this.m_Field.m_Group.setGroupData(this.m_GroupData.getText());
        } else {
            this.m_Field.m_Group.setGroupData("");
        }
        this.m_Field.m_Group.setGroupHeaderVisible(this.m_ShowGroupHeader.isSelected());
        this.m_Field.m_Group.setGroupFooterVisible(this.m_ShowGroupFooter.isSelected());
        this.m_IsOk = true;
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public boolean isOk() {
        return this.m_IsOk;
    }

    protected JPanel buildUI() {
        this.m_Layout = new ArchLayout();
        JPanel jPanel = new JPanel(this.m_Layout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Name = SwingFactory.newComboBox("name", this.getNames());
        jPanel.add(this.m_Name);
        this.m_Name.setSelectedItem(this.m_Field.m_Group.getField());
        this.m_SortOrder = I18NComboBox.apply(I18NComboBox.buildNames(UIConstants.IDS, I18N.ERD, UIConstants.KEYS));
        jPanel.add("sortOrder", this.m_SortOrder);
        this.m_SortOrder.setSelectedId(this.m_Field.m_Group.getSortOrder());
        this.m_GroupOn = I18NComboBox.apply(this.getGroupOn());
        jPanel.add("groupOn", this.m_GroupOn);
        this.m_GroupOn.setSelectedId(this.m_Field.m_Group.getGroupOn());
        this.m_GroupData = SwingFactory.newTextField("groupData", 32);
        jPanel.add(this.m_GroupData);
        this.m_GroupData.setText(this.m_Field.m_Group.getGroupData());
        this.m_ShowGroupHeader = SwingFactory.newCheckBox("SORT.show-group-header");
        jPanel.add(this.m_ShowGroupHeader);
        this.m_ShowGroupHeader.setSelected(this.m_Field.m_Group.isGroupHeaderVisible());
        this.m_ShowGroupFooter = SwingFactory.newCheckBox("SORT.show-group-footer");
        jPanel.add(this.m_ShowGroupFooter);
        this.m_ShowGroupFooter.setSelected(this.m_Field.m_Group.isGroupFooterVisible());
        this.m_Name.addItemListener(new CodeBlock((Object)this, "updateGroupOn"));
        this.m_GroupOn.addItemListener(new CodeBlock((Object)this, "updateGroupData"));
        jPanel.add(SwingFactory.newLabel("UI.name"));
        jPanel.add(SwingFactory.newLabel("SORT.sort-order"));
        jPanel.add(SwingFactory.newLabel("SORT.group-on"));
        this.m_DataLabel = SwingFactory.newLabel("SORT.group-interval");
        jPanel.add(this.m_DataLabel);
        this.m_Layout.stickLeft("UI.name");
        this.m_Layout.vCenter("UI.name", "name");
        this.m_Layout.stickLeft("SORT.sort-order");
        this.m_Layout.vCenter("SORT.sort-order", "sortOrder");
        this.m_Layout.stickLeft("SORT.group-on");
        this.m_Layout.vCenter("SORT.group-on", "groupOn");
        this.m_Layout.stickLeft("SORT.group-interval");
        this.m_Layout.vCenter("SORT.group-interval", "groupData");
        this.m_Layout.stickTop("name");
        this.m_Layout.putRight("name", "UI.name,SORT.sort-order,SORT.group-on,SORT.group-interval");
        this.m_Layout.stickRight("name");
        this.m_Layout.alignBelow("sortOrder", "name");
        this.m_Layout.stickRight("sortOrder");
        this.m_Layout.alignBelow("groupOn", "sortOrder");
        this.m_Layout.stickRight("groupOn");
        this.m_Layout.alignBelow("groupData", "groupOn");
        this.m_Layout.stickRight("groupData");
        this.m_Layout.alignBelow("SORT.show-group-header", "groupData", 5);
        this.m_Layout.putBelow("SORT.show-group-footer", "groupData", 5);
        this.m_Layout.putRight("SORT.show-group-footer", "SORT.show-group-header", 10);
        this.updateCombos();
        return jPanel;
    }

    protected void buildButtons(JPanel jPanel) {
        this.m_Ok = SwingFactory.newOkButton(new CodeBlock((Object)this, "ok"));
        jPanel.add(this.m_Ok);
        this.m_Cancel = SwingFactory.newCancelButton(new CodeBlock((Object)this, "cancel"));
        jPanel.add(this.m_Cancel);
    }

    public void updateCombos() {
        this.updateGroupOn();
        this.updateGroupData();
    }

    public void updateGroupOn() {
        Object object = this.m_GroupOn.getSelectedItem();
        this.m_GroupOn.setModel(new DefaultComboBoxModel<Name>(this.getGroupOn()));
        this.m_GroupOn.setSelectedItem(object);
        if (this.m_GroupOn.getSelectedIndex() < 0 && this.m_GroupOn.getItemCount() > 0) {
            this.m_GroupOn.setSelectedIndex(0);
        }
    }

    public void updateGroupData() {
        String string = this.m_GroupOn.getSelectedId();
        if (string == null || string.equals("All") || string.equals("Each Value") || string.equals("None")) {
            this.m_DataLabel.setText("");
            this.m_GroupData.setVisible(false);
        } else if (string.equals("Range")) {
            this.m_DataLabel.setText(I18N.ERD.getString("SortDialog.Range"));
            this.m_GroupData.setVisible(true);
        } else if (string.equals("Substring")) {
            this.m_DataLabel.setText(I18N.ERD.getString("SortDialog.StartEnd"));
            this.m_GroupData.setVisible(true);
        } else {
            this.m_DataLabel.setText(I18N.ERD.getString("SortDialog.GroupInterval"));
            this.m_GroupData.setVisible(true);
        }
    }

    private String[] getNames() {
        return new String[]{this.m_Field.m_Name};
    }

    private Name[] getGroupOn() {
        int n = this.m_Name.getSelectedIndex();
        if (n < 0) {
            return new Name[0];
        }
        DataType dataType = DataType.getInstance((String)this.m_Field.m_DataType);
        return com.elixirtech.wizard.sort.SortDialog.getGroupDisplayNames(GrouperFactory.getGroupOnNames((DataType)dataType));
    }
}

