/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.report;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.report.ReportWizard;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class StandardReportPage
extends RelativeLayoutWizardPage
implements ListSelectionListener {
    private DataSchema m_DataSchema;
    private String m_DataSourceName;
    private JLabel m_DSLabel;
    private JTable m_Fields = SwingFactory.newTable();
    private FieldModel m_FieldModel;
    private JTable m_ChosenFields = SwingFactory.newTable();
    private FieldModel m_ChosenFieldModel;
    private JButton m_Add = new JButton(StandardIcons.RIGHT);
    private JButton m_AddAll = new JButton(StandardIcons.RIGHT_ALL);
    private JButton m_Remove = new JButton(StandardIcons.LEFT);
    private JButton m_RemoveAll = new JButton(StandardIcons.LEFT_ALL);
    private JButton m_Up = new JButton(StandardIcons.UP);
    private JButton m_Down = new JButton(StandardIcons.DOWN);
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(StandardReportPage.class);
    static final String[] COLUMNS = new String[]{"TableModel.Name", "TableModel.Type"};

    public StandardReportPage(String string, String string2) {
        super(string, string2);
    }

    public StandardReportPage() {
        super("Standard Report", null);
        this.setTitle(I18N.ERD.getString("StandardReportPage.title"));
        this.setMessage(I18N.ERD.getString("StandardReportPage.message"));
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        JLabel jLabel = SwingFactory.newLabel("ds-label");
        this.m_Component.add(jLabel);
        jLabel.setHorizontalAlignment(0);
        this.m_DSLabel = jLabel;
        jLabel = SwingFactory.newLabel("report-label");
        this.m_Component.add(jLabel);
        jLabel.setHorizontalAlignment(0);
        this.m_Component.add(SwingFactory.newScrollPane("fields", this.m_Fields));
        this.m_Component.add(SwingFactory.newScrollPane("chosen-fields", this.m_ChosenFields));
        this.m_Fields.getSelectionModel().addListSelectionListener(this);
        this.m_ChosenFields.getSelectionModel().addListSelectionListener(this);
        JPanel jPanel = new JPanel(new GridLayout(6, 1));
        jPanel.add(this.m_Add);
        jPanel.add(this.m_AddAll);
        jPanel.add(this.m_Remove);
        jPanel.add(this.m_RemoveAll);
        jPanel.add(this.m_Up);
        jPanel.add(this.m_Down);
        this.m_Add.addActionListener(new CodeBlock((Object)this, "add"));
        this.m_AddAll.addActionListener(new CodeBlock((Object)this, "addAll"));
        this.m_Remove.addActionListener(new CodeBlock((Object)this, "remove"));
        this.m_RemoveAll.addActionListener(new CodeBlock((Object)this, "removeAll"));
        this.m_Up.addActionListener(new CodeBlock((Object)this, "up"));
        this.m_Down.addActionListener(new CodeBlock((Object)this, "down"));
        this.m_Component.add("buttons", jPanel);
        this.stickTop("ds-label");
        this.stickTop("report-label");
        this.stickLeft("ds-label");
        this.setWidth("ds-label", "fields");
        this.stickRight("report-label");
        this.setWidth("report-label", "chosen-fields");
        this.putBelow("fields", "ds-label,report-label");
        this.putBelow("buttons", "ds-label,report-label");
        this.putBelow("chosen-fields", "ds-label,report-label");
        this.stickLeft("fields");
        this.putLeft("fields", "buttons");
        this.stickBottom("fields");
        this.hCenter("buttons");
        this.stickBottom("buttons");
        this.putRight("chosen-fields", "buttons");
        this.stickRight("chosen-fields");
        this.stickBottom("chosen-fields");
        this.m_Layout.layoutContainer(this.m_Component);
        I18N.ERD_MAP.injectComponents("StandardReportPage.", this.m_Component);
    }

    public String[] getChosenFields() {
        if (this.m_ChosenFieldModel != null) {
            List<Row> list = this.m_ChosenFieldModel.getItems();
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = list.get((int)i).name;
            }
            return stringArray;
        }
        return new String[0];
    }

    public AbstractTableModel getChosenFieldModel() {
        return this.m_ChosenFieldModel;
    }

    public DataSchema getDataSchema() {
        return this.m_DataSchema;
    }

    public void add() {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        int[] nArray = this.m_Fields.getSelectedRows();
        List<Row> list = this.m_FieldModel.getItems();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(list.get(nArray[i]));
        }
        this.m_ChosenFieldModel.getItems().addAll(arrayList);
        list.removeAll(arrayList);
        this.update();
    }

    public void addAll() {
        List<Row> list = this.m_FieldModel.getItems();
        this.m_ChosenFieldModel.getItems().addAll(list);
        list.clear();
        this.update();
    }

    public void remove() {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        int[] nArray = this.m_ChosenFields.getSelectedRows();
        List<Row> list = this.m_ChosenFieldModel.getItems();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(list.get(nArray[i]));
        }
        this.m_FieldModel.getItems().addAll(arrayList);
        list.removeAll(arrayList);
        this.update();
    }

    public void removeAll() {
        List<Row> list = this.m_ChosenFieldModel.getItems();
        this.m_FieldModel.getItems().addAll(list);
        list.clear();
        this.update();
    }

    public void up() {
        int n = this.m_ChosenFields.getSelectedRow();
        if (n < 1) {
            return;
        }
        List<Row> list = this.m_ChosenFieldModel.getItems();
        Row row = list.remove(n);
        list.add(n - 1, row);
        this.update();
        this.m_ChosenFields.setRowSelectionInterval(n - 1, n - 1);
    }

    public void down() {
        int n = this.m_ChosenFields.getRowCount();
        int n2 = this.m_ChosenFields.getSelectedRow();
        if (n2 >= 0 && n2 < n - 1) {
            List<Row> list = this.m_ChosenFieldModel.getItems();
            Row row = list.remove(n2);
            list.add(n2 + 1, row);
            this.update();
            this.m_ChosenFields.setRowSelectionInterval(n2 + 1, n2 + 1);
        }
    }

    @Override
    public boolean isPageComplete() {
        return this.m_ChosenFieldModel != null && this.m_ChosenFieldModel.getItems().size() > 0;
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.m_ChosenFieldModel != null && super.canFlipToNextPage() && this.m_ChosenFieldModel.getItems().size() > 0;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            String string = ((ReportWizard)this.m_Wizard).getDataSourceName();
            if (string != null && !string.equals(this.m_DataSourceName)) {
                this.m_DataSourceName = string;
                int n = string.lastIndexOf("/");
                if (n >= 0) {
                    string = string.substring(n + 1);
                }
                this.m_DSLabel.setText(string);
                this.buildModels();
            }
            this.updateButtons();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
    }

    protected void update() {
        this.m_FieldModel.update();
        this.m_ChosenFieldModel.update();
        this.updateButtons();
    }

    protected void updateButtons() {
        boolean bl = this.m_Fields.getSelectedRow() >= 0;
        boolean bl2 = this.m_ChosenFields.getSelectedRow() >= 0;
        this.m_Add.setEnabled(bl);
        this.m_AddAll.setEnabled(this.m_Fields.getRowCount() > 0);
        this.m_Remove.setEnabled(bl2);
        this.m_RemoveAll.setEnabled(this.m_ChosenFields.getRowCount() > 0);
        this.m_Up.setEnabled(this.m_ChosenFields.getRowCount() > 0);
        this.m_Down.setEnabled(this.m_ChosenFields.getRowCount() > 0);
        IWizardContainer iWizardContainer = this.m_Wizard.getContainer();
        if (iWizardContainer != null) {
            iWizardContainer.updateButtons();
        }
    }

    protected void buildModels() {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        try {
            IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, this.m_DataSourceName);
            this.m_DataSchema = iDataSource.getSchema();
            this.m_FieldModel = new FieldModel(this.m_DataSchema);
            this.m_Fields.setModel(this.m_FieldModel);
            this.m_ChosenFieldModel = new FieldModel();
            this.m_ChosenFields.setModel(this.m_ChosenFieldModel);
        }
        catch (Throwable throwable) {
            m_Log.error((Object)("Can't read datasource " + this.m_DataSourceName));
        }
    }

    private class FieldModel
    extends ElxTableModel {
        private List<Row> m_Items;

        public FieldModel() {
            super(I18N.ERD, COLUMNS);
            this.m_Items = new ArrayList<Row>();
        }

        public FieldModel(DataSchema dataSchema) {
            this();
            this.buildItems(dataSchema);
        }

        @Override
        public int getRowCount() {
            return this.m_Items.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Row row = this.m_Items.get(n);
            if (n2 == 0) {
                return row.name;
            }
            return I18N.getDataTypeName(row.type);
        }

        public List<Row> getItems() {
            return this.m_Items;
        }

        public void update() {
            this.fireTableDataChanged();
        }

        protected void buildItems(DataSchema dataSchema) {
            if (dataSchema != null) {
                this.m_Items.clear();
                int n = dataSchema.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    Row row = new Row(dataSchema.getColumnName(i), dataSchema.getColumnType(i));
                    this.m_Items.add(row);
                }
            }
        }
    }

    private static class Row
    implements Comparable<Object> {
        public String name;
        public DataType type;

        public Row(String string, DataType dataType) {
            this.name = string;
            this.type = dataType;
        }

        @Override
        public final int compareTo(Object object) {
            if (object instanceof Row) {
                return this.name.compareTo(((Row)object).name);
            }
            return -1;
        }
    }
}

