/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.report.labels;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.erd.reportdesigner.pagesetup.Paper;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.CurrentTab;
import com.elixirtech.ui.LabelledPanel;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.TitledBorder;
import com.elixirtech.ui.UnitField;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.report.labels.Label;
import java.awt.GridLayout;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class LabelPagePanel
extends JPanel
implements CurrentTab {
    private ArchLayout m_Layout;
    private JComboBox m_PageSizes;
    private JRadioButton m_Portrait;
    private JRadioButton m_Landscape;
    private UnitField m_PageWidth;
    private UnitField m_PageHeight;
    private UnitField m_LeftMargin;
    private UnitField m_TopMargin;
    private UnitField m_RightMargin;
    private UnitField m_BottomMargin;
    public static final Paper[] PAPERS = new Paper[]{new Paper(MediaSizeName.ISO_A4), new Paper(MediaSizeName.ISO_A3), new Paper(MediaSizeName.ISO_A5), new Paper(MediaSizeName.NA_LETTER), new Paper(MediaSizeName.NA_LEGAL), new Paper(MediaSizeName.ISO_B5), new Paper("custom")};

    public LabelPagePanel() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Layout = new ArchLayout();
        this.setLayout(this.m_Layout);
        this.m_PageSizes = SwingFactory.newComboBox("paper", PAPERS);
        this.m_Portrait = SwingFactory.newRadioButton("portrait");
        this.m_Landscape = SwingFactory.newRadioButton("landscape");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_Portrait);
        buttonGroup.add(this.m_Landscape);
        CodeBlock codeBlock = new CodeBlock((Object)this, "update");
        this.m_PageSizes.addItemListener(codeBlock);
        this.m_Portrait.addItemListener(codeBlock);
        this.m_Landscape.addItemListener(codeBlock);
        this.m_Layout.addLabel((JComponent)this, "paper", SwingFactory.newLabel("paper-label"));
        this.m_Layout.addLabel((JComponent)this, "width", SwingFactory.newLabel("width-label"));
        this.m_Layout.addLabel((JComponent)this, "height", SwingFactory.newLabel("height-label"));
        this.add(this.m_PageSizes);
        this.add(this.m_Portrait);
        this.add(this.m_Landscape);
        this.m_PageWidth = UnitField.newUnitField("width");
        this.add(this.m_PageWidth);
        this.m_PageHeight = UnitField.newUnitField("height");
        this.add(this.m_PageHeight);
        this.m_PageWidth.setColumns(6);
        this.m_PageHeight.setColumns(6);
        this.m_Layout.stickTop("paper");
        this.m_Layout.putRight("paper", "paper-label,width-label,height-label", 10);
        this.m_Layout.stickTop("portrait");
        this.m_Layout.stickTop("landscape");
        this.m_Layout.putRight("portrait", "paper", 10);
        this.m_Layout.putRight("landscape", "portrait", 5);
        this.m_Layout.alignBelow("width", "paper");
        this.m_Layout.alignBelow("height", "width");
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setBorder(new TitledBorder(SwingFactory.newLabel("margin-label")));
        LabelledPanel labelledPanel = new LabelledPanel();
        this.m_LeftMargin = UnitField.newUnitField("left");
        labelledPanel.addItem("left", SwingFactory.newLabel("left"), this.m_LeftMargin);
        this.m_TopMargin = UnitField.newUnitField("top");
        labelledPanel.addItem("top", SwingFactory.newLabel("top"), this.m_TopMargin);
        LabelledPanel labelledPanel2 = new LabelledPanel();
        this.m_RightMargin = UnitField.newUnitField("right");
        labelledPanel2.addItem("right", SwingFactory.newLabel("right"), this.m_RightMargin);
        this.m_BottomMargin = UnitField.newUnitField("bottom");
        labelledPanel2.addItem("bottom", SwingFactory.newLabel("bottom"), this.m_BottomMargin);
        this.m_LeftMargin.setColumns(6);
        this.m_TopMargin.setColumns(6);
        this.m_RightMargin.setColumns(6);
        this.m_BottomMargin.setColumns(6);
        jPanel.add(labelledPanel);
        jPanel.add(labelledPanel2);
        this.add("margins", jPanel);
        this.m_Layout.putBelow("margins", "height", 10);
        this.m_Layout.stickLeft("margins");
        this.m_Layout.stickRight("margins");
        this.update();
        I18N.ERD_MAP.injectComponents("LabelPagePanel.", this);
        I18N.ERD_MAP.injectObject(null, this, "LabelPagePanel");
    }

    @Override
    public void setCurrent(boolean bl) {
    }

    public void setLabel(Label label) {
        this.m_PageSizes.setSelectedItem(this.getPaper(label.m_PaperMedia));
        if ("Portrait".equals(label.m_PaperOrientation)) {
            this.m_Portrait.setSelected(true);
        } else {
            this.m_Landscape.setSelected(true);
        }
        this.m_PageWidth.setValue(label.m_PaperWidth);
        this.m_PageHeight.setValue(label.m_PaperHeight);
        this.m_LeftMargin.setValue(label.m_PageMarginLeft);
        this.m_TopMargin.setValue(label.m_PageMarginTop);
        this.m_RightMargin.setValue(label.m_PageMarginRight);
        this.m_BottomMargin.setValue(label.m_PageMarginBottom);
        this.update();
    }

    public void getLabel(Label label) {
        label.m_PaperMedia = ((Paper)this.m_PageSizes.getSelectedItem()).getName();
        label.m_PaperOrientation = this.m_Portrait.isSelected() ? "Portrait" : "Landscape";
        label.m_PaperWidth = this.m_PageWidth.getValue();
        label.m_PaperHeight = this.m_PageHeight.getValue();
        label.m_PageMarginLeft = this.m_LeftMargin.getValue();
        label.m_PageMarginTop = this.m_TopMargin.getValue();
        label.m_PageMarginRight = this.m_RightMargin.getValue();
        label.m_PageMarginBottom = this.m_BottomMargin.getValue();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_PageSizes.setEnabled(bl);
        this.m_Portrait.setEnabled(bl);
        this.m_Landscape.setEnabled(bl);
        this.m_PageWidth.setEnabled(bl);
        this.m_PageHeight.setEnabled(bl);
        this.m_LeftMargin.setEnabled(bl);
        this.m_TopMargin.setEnabled(bl);
        this.m_RightMargin.setEnabled(bl);
        this.m_BottomMargin.setEnabled(bl);
        this.update();
    }

    public void update() {
        boolean bl;
        boolean bl2 = bl = this.m_PageSizes.getSelectedIndex() == PAPERS.length - 1;
        if (!bl) {
            Paper paper = (Paper)this.m_PageSizes.getSelectedItem();
            if (this.m_Portrait.isSelected()) {
                this.m_PageWidth.setValue(paper.getWidth());
                this.m_PageHeight.setValue(paper.getHeight());
            } else {
                this.m_PageWidth.setValue(paper.getHeight());
                this.m_PageHeight.setValue(paper.getWidth());
            }
        }
        if (!this.isEnabled()) {
            bl = false;
        }
        this.m_PageWidth.setEnabled(bl);
        this.m_PageHeight.setEnabled(bl);
    }

    private Paper getPaper(String string) {
        for (int i = 0; i < PAPERS.length; ++i) {
            if (!PAPERS[i].getName().equals(string)) continue;
            return PAPERS[i];
        }
        return PAPERS[PAPERS.length - 1];
    }
}

