/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.rtf;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.erd.reportdesigner.ERDAction;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.JFileChooserEx;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.FileUtil;
import com.elixirtech.wizard.data.LiteralPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;

public class RTFLiteralPanel
extends LiteralPanel {
    public RTFLiteralPanel(ControlSource controlSource) {
        super(controlSource);
        Box box = new Box(1);
        JButton jButton = SwingFactory.newButton("open", new OpenAction());
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setToolTipText(I18N.ERD.getString("Rtf.LoadAsLiteral.Tip"));
        box.add(jButton);
        this.add((Component)box, "West");
    }

    private class OpenAction
    extends ERDAction {
        public OpenAction() {
            super("Open");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooserEx jFileChooserEx = new JFileChooserEx();
            jFileChooserEx.addFilter(".rtf", I18N.ERD.getString("Rtf.RichTextFormatFiles"));
            int n = jFileChooserEx.showOpenDialog(RTFLiteralPanel.this);
            if (n == 0) {
                File file = jFileChooserEx.getSelectedFile();
                try {
                    RTFLiteralPanel.this.setText(FileUtil.load(file).trim());
                }
                catch (IOException iOException) {
                    ElixirJ.error(I18N.ERD.getString("Error.error-load-rtf") + String.valueOf(iOException), iOException);
                }
            }
        }
    }
}

