/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.rtf;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.erd.reportdesigner.ERDAction;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.JFileChooserEx;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.FileUtil;
import com.elixirtech.util.StrBuffer;
import com.elixirtech.wizard.data.ScriptPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.Box;
import javax.swing.JButton;

public class RTFScriptPanel
extends ScriptPanel {
    public RTFScriptPanel(ControlSource controlSource) {
        super(controlSource);
        Box box = new Box(1);
        JButton jButton = SwingFactory.newDotsButton("dots", new OpenAction());
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setToolTipText(I18N.ERD.getString("Rtf.LoadAsScript.Tip"));
        box.add(jButton);
        this.add((Component)box, "West");
        I18N.ERD_MAP.injectComponents("RTFScriptPanel.", this);
    }

    private class OpenAction
    extends ERDAction {
        public OpenAction() {
            super("Open");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooserEx jFileChooserEx = new JFileChooserEx();
            jFileChooserEx.addFilter(".rtf", I18N.ERD.getString("Rtf.RichTextFormatFiles"));
            int n = jFileChooserEx.showOpenDialog(RTFScriptPanel.this);
            if (n == 0) {
                File file = jFileChooserEx.getSelectedFile();
                try {
                    String string;
                    String string2 = FileUtil.load(file);
                    StringReader stringReader = new StringReader(string2);
                    BufferedReader bufferedReader = new BufferedReader(stringReader);
                    StrBuffer strBuffer = new StrBuffer();
                    while ((string = bufferedReader.readLine()) != null) {
                        if ((string = string.trim()).length() == 0) continue;
                        if (strBuffer.length() > 0) {
                            strBuffer.append("+\n");
                        }
                        strBuffer.append('\"');
                        strBuffer.append(string.replace("\\", "\\\\"));
                        strBuffer.append('\"');
                    }
                    RTFScriptPanel.this.m_Editor.setText(strBuffer.toString());
                }
                catch (IOException iOException) {
                    ElixirJ.error(I18N.ERD.getString("Error.error-load-rtf") + String.valueOf(iOException), iOException);
                }
            }
        }
    }
}

