/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.svg;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.repository.RepositoryChooser;
import com.elixirtech.arch.repository.filter.TypeFilter;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.jdom.output.Format;
import com.elixirtech.jdom.output.XMLOutputter;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.SVG;
import com.elixirtech.repository.TreeNodeFilter;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SVGTab
extends TabComponent
implements ActionListener {
    private JTextField m_Location;
    private JTextArea m_SVGText;
    private SVG m_SVG;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SVGTab.class);

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("SVGTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("SVGTab.message");
    }

    @Override
    public void performFinish() {
        this.m_SVG.setLocation(this.m_Location.getText());
        this.m_SVG.setImage(null);
        String string = StringUtil.normalize(this.m_SVGText.getText().trim());
        if (string.length() > 0) {
            try {
                SAXBuilder sAXBuilder = new SAXBuilder();
                Document document = sAXBuilder.build((Reader)new StringReader(string));
                this.m_SVG.setDocument(document);
            }
            catch (Exception exception) {
                ElixirJ.userError(I18N.ERD.getString("SVGTab.error-parse") + String.valueOf(exception));
            }
        } else {
            this.m_SVG.setDocument(null);
        }
    }

    public SVGTab(SVG sVG) {
        Object object;
        JButton jButton;
        this.m_SVG = sVG;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Location = SwingFactory.newTextField("location");
        this.m_Location.setText(this.m_SVG.getLocation());
        this.m_SVGText = new JTextArea();
        Document document = this.m_SVG.getDocument();
        if (document != null && document.hasRootElement()) {
            jButton = new XMLOutputter(Format.getPrettyFormat());
            object = new StringWriter();
            try {
                jButton.output(document, (Writer)object);
                this.m_SVGText.setText(((StringWriter)object).toString());
            }
            catch (Exception exception) {
                m_Log.error((Object)("Unable to load SVG Document: " + String.valueOf(exception)), (Throwable)exception);
            }
        }
        jButton = SwingFactory.newDotsButton("dots", this);
        this.setLayout(new BorderLayout());
        object = new JPanel(new BorderLayout());
        ((Container)object).add("West", SwingFactory.newLabel("location-label"));
        ((Container)object).add("Center", this.m_Location);
        ((Container)object).add("East", jButton);
        this.add("North", (Component)object);
        this.add("Center", SwingFactory.newScrollPane("svg-text", this.m_SVGText));
        I18N.ERD_MAP.injectComponents("SVGTab.", this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        RepositoryChooser repositoryChooser = new RepositoryChooser((Frame)elixirFrame.getFrame(), I18N.ERD.getString("SVGTab.choose-resource.title"), (TreeNodeFilter)new TypeFilter("svg"));
        repositoryChooser.setLocationRelativeTo(this);
        elixirFrame.showModal(repositoryChooser);
        if (repositoryChooser.isOk()) {
            this.m_Location.setText("repository:" + String.valueOf(repositoryChooser.getSelection().getPath()));
        }
    }
}

