/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.tab;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.ITextElement;
import com.elixirtech.ui.JColorChooserEx;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.UnitField;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class FontTab
extends TabComponent
implements ActionListener {
    private ITextElement m_Element;
    SampleProvider m_SampleProvider;
    JComboBox m_FontName;
    UnitField m_FontSize;
    JCheckBox m_FontIsBold;
    JCheckBox m_FontIsItalic;
    JCheckBox m_FontIsUnderline;
    JCheckBox m_FontIsStrikethrough;
    JTextField m_FontColor;
    FontSample m_FontSample;

    public FontTab(ITextElement iTextElement, SampleProvider sampleProvider) {
        this.m_Element = iTextElement;
        this.m_SampleProvider = sampleProvider;
        ArchLayout archLayout = new ArchLayout();
        this.setLayout(archLayout);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        CodeBlock codeBlock = new CodeBlock((Object)this, "refresh");
        this.add(SwingFactory.newLabel("name-label"));
        this.add(SwingFactory.newLabel("size-label"));
        this.add(SwingFactory.newLabel("color-label"));
        this.add(SwingFactory.newLabel("style-label"));
        this.m_FontName = SwingFactory.newComboBox("name", this.getFonts());
        this.add(this.m_FontName);
        this.m_FontSize = UnitField.newPointUnitField();
        this.add("size", this.m_FontSize);
        this.m_FontIsBold = SwingFactory.newCheckBox("bold");
        this.add(this.m_FontIsBold);
        this.m_FontIsItalic = SwingFactory.newCheckBox("italic");
        this.add(this.m_FontIsItalic);
        this.m_FontIsUnderline = SwingFactory.newCheckBox("underline");
        this.add(this.m_FontIsUnderline);
        this.m_FontIsStrikethrough = SwingFactory.newCheckBox("strikethrough");
        this.add(this.m_FontIsStrikethrough);
        this.m_FontColor = SwingFactory.newTextField("color");
        this.add(this.m_FontColor);
        this.add("dots", SwingFactory.newDotsButton("dots", this));
        this.m_FontSample = new FontSample();
        this.add("sample", this.m_FontSample);
        this.m_FontName.setEditable(true);
        this.m_FontName.addItemListener(codeBlock);
        this.m_FontSize.addDocumentListener(codeBlock);
        this.m_FontIsBold.addItemListener(codeBlock);
        this.m_FontIsItalic.addItemListener(codeBlock);
        this.m_FontIsUnderline.addItemListener(codeBlock);
        this.m_FontIsStrikethrough.addItemListener(codeBlock);
        this.m_FontColor.getDocument().addDocumentListener(codeBlock);
        archLayout.stickTop("name");
        archLayout.stickLeft("name-label");
        archLayout.vCenter("name-label", "name");
        archLayout.stickRight("name");
        archLayout.putRight("name", "name-label,size-label,style-label,color-label", 10);
        archLayout.alignBelow("size", "name", 5);
        archLayout.stickLeft("size-label");
        archLayout.vCenter("size-label", "size");
        archLayout.stickLeft("style-label");
        archLayout.vCenter("style-label", "bold");
        archLayout.alignBelow("bold", "size", 5);
        archLayout.vCenter("italic", "bold");
        archLayout.vCenter("underline", "italic");
        archLayout.vCenter("strikethrough", "underline");
        archLayout.putRight("italic", "bold", 10);
        archLayout.putRight("underline", "italic", 10);
        archLayout.putRight("strikethrough", "underline", 10);
        archLayout.alignBelow("color", "bold", 5);
        archLayout.vCenter("color-label", "color");
        archLayout.stickLeft("color-label");
        archLayout.stickRight("dots");
        archLayout.putLeft("color", "dots");
        archLayout.putBelow("dots", "underline", 5);
        archLayout.setHeight("dots", "color");
        archLayout.putBelow("sample", "color", 5);
        archLayout.stickLeft("sample");
        archLayout.stickRight("sample");
        archLayout.stickBottom("sample");
        this.m_FontName.setSelectedItem(this.m_Element.getFontName());
        this.m_FontSize.setValue(this.m_Element.getFontSize());
        this.m_FontIsBold.setSelected(this.m_Element.isFontBold());
        this.m_FontIsItalic.setSelected(this.m_Element.isFontItalic());
        this.m_FontIsUnderline.setSelected(this.m_Element.isFontUnderline());
        this.m_FontIsStrikethrough.setSelected(this.m_Element.isFontStrikethrough());
        Color color = StandardColor.lookup(this.m_Element.getFontColor());
        this.m_FontColor.setText(StandardColor.getColorName(color));
        I18N.ERD_MAP.injectComponents("FontTab.", this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color = StandardColor.lookup(this.m_Element.getFontColor());
        Color color2 = JColorChooserEx.showDialog(this, color);
        this.m_FontColor.setText(StandardColor.getColorName(color2));
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public void entered() {
        this.refresh();
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("FontTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("FontTab.message");
    }

    @Override
    public void performFinish() {
        String string = (String)this.m_FontName.getSelectedItem();
        int n = this.m_FontSize.getIntValue();
        boolean bl = this.m_FontIsBold.isSelected();
        boolean bl2 = this.m_FontIsItalic.isSelected();
        boolean bl3 = this.m_FontIsUnderline.isSelected();
        boolean bl4 = this.m_FontIsStrikethrough.isSelected();
        Color color = StandardColor.lookup(this.m_FontColor.getText());
        String string2 = StandardColor.getColorName(color);
        if (!this.m_Element.getFontName().equals(string)) {
            this.m_Element.setFontName(string);
        }
        if (this.m_Element.getFontSize() != n) {
            this.m_Element.setFontSize(n);
        }
        if (this.m_Element.isFontBold() != bl) {
            this.m_Element.setFontBold(bl);
        }
        if (this.m_Element.isFontItalic() != bl2) {
            this.m_Element.setFontItalic(bl2);
        }
        if (this.m_Element.isFontUnderline() != bl3) {
            this.m_Element.setFontUnderline(bl3);
        }
        if (this.m_Element.isFontStrikethrough() != bl4) {
            this.m_Element.setFontStrikethrough(bl4);
        }
        if (!this.m_Element.getFontColor().equals(string2)) {
            this.m_Element.setFontColor(string2);
        }
    }

    protected String[] getFonts() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.getAvailableFontFamilyNames();
    }

    public void refresh() {
        this.m_FontSample.repaint();
    }

    public static interface SampleProvider {
        public String getText();
    }

    private class FontSample
    extends JComponent {
        private FontSample() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n;
            Dimension dimension = this.getSize();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            String string = (String)FontTab.this.m_FontName.getSelectedItem();
            int n2 = 0;
            if (FontTab.this.m_FontIsBold.isSelected()) {
                n2 |= 1;
            }
            if (FontTab.this.m_FontIsItalic.isSelected()) {
                n2 |= 2;
            }
            if ((n = FontTab.this.m_FontSize.getIntValue()) < 0) {
                n = 0;
            }
            Font font = new Font(string, n2, n / 20);
            font = font.deriveFont((float)n / 20.0f);
            graphics.setFont(font);
            Color color = StandardColor.lookup(FontTab.this.m_FontColor.getText());
            graphics.setColor(color);
            String string2 = FontTab.this.m_SampleProvider.getText();
            if (StringUtil.isEmpty(string2)) {
                string2 = "Sample Text";
            }
            AttributedString attributedString = new AttributedString(string2);
            attributedString.addAttribute(TextAttribute.FONT, font);
            if (FontTab.this.m_FontIsUnderline.isSelected()) {
                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (FontTab.this.m_FontIsStrikethrough.isSelected()) {
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            attributedString.addAttribute(TextAttribute.FOREGROUND, color);
            Graphics2D graphics2D = (Graphics2D)graphics;
            TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
            float f = textLayout.getAdvance();
            float f2 = textLayout.getAscent();
            float f3 = ((float)dimension.width - f) / 2.0f;
            float f4 = ((float)dimension.height + f2) / 2.0f;
            textLayout.draw(graphics2D, f3, f4);
        }
    }

    public static class SimpleSampleProvider
    implements SampleProvider {
        private String m_SampleText = I18N.ERD.getString("SampleProvider.SampleText");

        @Override
        public String getText() {
            return this.m_SampleText;
        }
    }
}

