/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.tab;

import com.elixirtech.editor.JEditor;
import com.elixirtech.editor.REJavaScriptTypes;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.IRenderScriptHolder;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.StyledEditorKit;

public class ScriptTab
extends TabComponent {
    private IRenderScriptHolder m_Element;
    private boolean m_IsChunk;
    private JEditor m_RenderIf;
    private JEditor m_OnRenderBegin;
    private JEditor m_OnRenderEnd;
    private JEditor m_OnLayout;

    public ScriptTab(IRenderScriptHolder iRenderScriptHolder) {
        this.m_Element = iRenderScriptHolder;
        this.m_IsChunk = this.m_Element instanceof Chunk;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        int n = this.m_IsChunk ? 4 : 3;
        JPanel jPanel = new JPanel(new GridLayout(n, 1));
        jPanel.add(SwingFactory.newLabel("render-if"));
        jPanel.add(SwingFactory.newLabel("on-render-begin"));
        jPanel.add(SwingFactory.newLabel("on-render-end"));
        if (this.m_IsChunk) {
            jPanel.add(SwingFactory.newLabel("on-layout"));
        }
        String string = this.getScriptString(this.m_Element.getRenderIf());
        String string2 = this.getScriptString(this.m_Element.getOnRenderBegin());
        String string3 = this.getScriptString(this.m_Element.getOnRenderEnd());
        JPanel jPanel2 = new JPanel(new GridLayout(n, 1));
        StyledEditorKit styledEditorKit = REJavaScriptTypes.kit();
        this.m_RenderIf = new JEditor(string, styledEditorKit);
        jPanel2.add(SwingFactory.newScrollPane("scroll-renderif", this.m_RenderIf));
        this.m_OnRenderBegin = new JEditor(string2, styledEditorKit);
        jPanel2.add(SwingFactory.newScrollPane("scroll-render-begin", this.m_OnRenderBegin));
        this.m_OnRenderEnd = new JEditor(string3, styledEditorKit);
        jPanel2.add(SwingFactory.newScrollPane("scroll-render-end", this.m_OnRenderEnd));
        if (this.m_IsChunk) {
            String string4 = this.getScriptString(((Chunk)this.m_Element).getOnLayout());
            this.m_OnLayout = new JEditor(string4, styledEditorKit);
            jPanel2.add(new JScrollPane(this.m_OnLayout));
        }
        this.add((Component)jPanel, "West");
        this.add((Component)jPanel2, "Center");
        I18N.ERD_MAP.injectComponents("ScriptTab.", this);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("ScriptTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("ScriptTab.title");
    }

    @Override
    public void performFinish() {
        this.m_Element.setRenderIf(this.toScript(this.m_RenderIf.getText()));
        this.m_Element.setOnRenderBegin(this.toScript(this.m_OnRenderBegin.getText()));
        this.m_Element.setOnRenderEnd(this.toScript(this.m_OnRenderEnd.getText()));
        if (this.m_IsChunk) {
            ((Chunk)this.m_Element).setOnLayout(this.toScript(this.m_OnLayout.getText()));
        }
    }

    protected String getScriptString(Script script) {
        if (script == null) {
            return "";
        }
        return script.getText();
    }

    protected Script toScript(String string) {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        return new Script("javascript", string);
    }
}

