/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.table;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.erd.reportdesigner.chunk.UiFactory;
import com.elixirtech.erd.reportdesigner.shape.HBoxShape;
import com.elixirtech.i18n.Name;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.property.IMasterPropertyList;
import com.elixirtech.property.IStyle;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Cell;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.Field;
import com.elixirtech.report2.raw.model.HBox;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.report2.raw.model.StyleItem;
import com.elixirtech.report2.raw.model.Table;
import com.elixirtech.report2.raw.model.TableBody;
import com.elixirtech.report2.raw.model.TableHeader;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.util.CodeBlock;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TableSelectFieldTab
extends TabComponent
implements ListSelectionListener {
    static Name[] BORDER_ELEMENT_NAMES = new Name[]{I18N.getName("RawElement.BorderStyle")};
    static IMasterPropertyList MPL = (IMasterPropertyList)Elixir.get(IMasterPropertyList.class);
    private RawReport m_RawReport;
    private DataSchema m_DataSchema;
    private JTable m_Fields = SwingFactory.newTable();
    private FieldModel m_FieldModel;
    private JTable m_ChosenFields = SwingFactory.newTable();
    private FieldModel m_ChosenFieldModel;
    private String m_Cache;
    private Table m_Table;
    private ArchLayout m_Layout;
    private JButton m_Add = new JButton(StandardIcons.RIGHT);
    private JButton m_AddAll = new JButton(StandardIcons.RIGHT_ALL);
    private JButton m_Remove = new JButton(StandardIcons.LEFT);
    private JButton m_RemoveAll = new JButton(StandardIcons.LEFT_ALL);
    private JButton m_Up = new JButton(StandardIcons.UP);
    private JButton m_Down = new JButton(StandardIcons.DOWN);
    static final String[] COLUMNS = new String[]{"TableModel.Name"};
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(TableSelectFieldTab.class);

    public TableSelectFieldTab(Table table) {
        this.m_Table = table;
        this.m_Layout = new ArchLayout();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(this.m_Layout);
        JPanel jPanel = new JPanel(new GridLayout(6, 1));
        jPanel.add(this.m_Add);
        jPanel.add(this.m_AddAll);
        jPanel.add(this.m_Remove);
        jPanel.add(this.m_RemoveAll);
        jPanel.add(this.m_Up);
        jPanel.add(this.m_Down);
        this.m_Add.addActionListener(new CodeBlock((Object)this, "add"));
        this.m_AddAll.addActionListener(new CodeBlock((Object)this, "addAll"));
        this.m_Remove.addActionListener(new CodeBlock((Object)this, "remove"));
        this.m_RemoveAll.addActionListener(new CodeBlock((Object)this, "removeAll"));
        this.m_Up.addActionListener(new CodeBlock((Object)this, "up"));
        this.m_Down.addActionListener(new CodeBlock((Object)this, "down"));
        JLabel jLabel = null;
        jLabel = SwingFactory.newLabel("ds-label");
        this.add(jLabel);
        jLabel.setAlignmentX(0.0f);
        jLabel = SwingFactory.newLabel("report-label");
        this.add(jLabel);
        jLabel.setAlignmentX(0.0f);
        this.add(SwingFactory.newScrollPane("fields", this.m_Fields));
        this.add("buttons", jPanel);
        this.add(SwingFactory.newScrollPane("chosen-fields", this.m_ChosenFields));
        this.m_Layout.stickTop("ds-label");
        this.m_Layout.stickTop("report-label");
        this.m_Layout.stickLeft("ds-label");
        this.m_Layout.setWidth("ds-label", "fields");
        this.m_Layout.stickRight("report-label");
        this.m_Layout.setWidth("report-label", "chosen-fields");
        this.m_Layout.putBelow("fields", "ds-label,report-label");
        this.m_Layout.putBelow("buttons", "ds-label,report-label");
        this.m_Layout.putBelow("chosen-fields", "ds-label,report-label");
        this.m_Layout.stickLeft("fields");
        this.m_Layout.putLeft("fields", "buttons");
        this.m_Layout.stickBottom("fields");
        this.m_Layout.hCenter("buttons");
        this.m_Layout.stickBottom("buttons");
        this.m_Layout.putRight("chosen-fields", "buttons");
        this.m_Layout.stickRight("chosen-fields");
        this.m_Layout.stickBottom("chosen-fields");
        this.m_ChosenFields.getSelectionModel().addListSelectionListener(this);
        this.m_Fields.getSelectionModel().addListSelectionListener(this);
        this.m_Layout.layoutContainer(this);
        I18N.ERD_MAP.injectComponents("TableSelectFieldTab.", this);
    }

    private void updateTable(String string) {
        block3: {
            RawReport rawReport = (RawReport)this.m_Table.getResourceProvider();
            DataSource dataSource = rawReport.getDataSource(string);
            DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
            try {
                IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, dataSource.getDataSourceName());
                this.m_DataSchema = iDataSource.getSchema();
                this.m_FieldModel = new FieldModel(this.m_DataSchema);
                this.m_Fields.setModel(this.m_FieldModel);
                this.m_ChosenFieldModel = new FieldModel();
                this.m_ChosenFields.setModel(this.m_ChosenFieldModel);
            }
            catch (Exception exception) {
                m_Log.warn((Object)("Can't read datasource " + string));
                if (this.m_FieldModel != null) {
                    this.m_FieldModel.m_Items.clear();
                }
                if (this.m_ChosenFieldModel == null) break block3;
                this.m_ChosenFieldModel.m_Items.clear();
            }
        }
    }

    protected void update() {
        if (this.m_FieldModel != null) {
            this.m_FieldModel.update();
        }
        if (this.m_ChosenFieldModel != null) {
            this.m_ChosenFieldModel.update();
            this.updateButtons();
        }
    }

    protected void updateButtons() {
        boolean bl = this.m_Fields.getSelectedRow() >= 0;
        boolean bl2 = this.m_ChosenFields.getSelectedRow() >= 0;
        this.m_Add.setEnabled(bl);
        this.m_AddAll.setEnabled(this.m_Fields.getRowCount() > 0);
        this.m_Remove.setEnabled(bl2);
        this.m_RemoveAll.setEnabled(this.m_ChosenFields.getRowCount() > 0);
        this.m_Up.setEnabled(this.m_ChosenFields.getRowCount() > 0);
        this.m_Down.setEnabled(this.m_ChosenFields.getRowCount() > 0);
    }

    public void add() {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        int[] nArray = this.m_Fields.getSelectedRows();
        List<Row> list = this.m_FieldModel.getItems();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(list.get(nArray[i]));
        }
        this.m_ChosenFieldModel.getItems().addAll(arrayList);
        list.removeAll(arrayList);
        this.update();
    }

    public void addAll() {
        List<Row> list = this.m_FieldModel.getItems();
        this.m_ChosenFieldModel.getItems().addAll(list);
        list.clear();
        this.update();
    }

    public void remove() {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        int[] nArray = this.m_ChosenFields.getSelectedRows();
        List<Row> list = this.m_ChosenFieldModel.getItems();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(list.get(nArray[i]));
        }
        this.m_FieldModel.getItems().addAll(arrayList);
        list.removeAll(arrayList);
        this.update();
    }

    @Override
    public void removeAll() {
        List<Row> list = this.m_ChosenFieldModel.getItems();
        this.m_FieldModel.getItems().addAll(list);
        list.clear();
        this.update();
    }

    public void up() {
        int n = this.m_ChosenFields.getSelectedRow();
        if (n < 1) {
            return;
        }
        List<Row> list = this.m_ChosenFieldModel.getItems();
        Row row = list.remove(n);
        list.add(n - 1, row);
        this.update();
        this.m_ChosenFields.setRowSelectionInterval(n - 1, n - 1);
    }

    public void down() {
        int n = this.m_ChosenFields.getRowCount();
        int n2 = this.m_ChosenFields.getSelectedRow();
        if (n2 >= 0 && n2 < n - 1) {
            List<Row> list = this.m_ChosenFieldModel.getItems();
            Row row = list.remove(n2);
            list.add(n2 + 1, row);
            this.update();
            this.m_ChosenFields.setRowSelectionInterval(n2 + 1, n2 + 1);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("TableSelectFieldTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("TableSelectFieldTab.name");
    }

    static Style createStyle(String string, Name[] nameArray, Object[] objectArray) {
        Style style = new Style();
        style.setName(string);
        for (int i = 0; i < nameArray.length; ++i) {
            if (objectArray[i] == null) continue;
            style.addStyleItem(TableSelectFieldTab.createStyleItem(nameArray[i], objectArray[i]));
        }
        return style;
    }

    static StyleItem createStyleItem(Name name, Object object) {
        PropertyType propertyType = MPL.getPropertyType(name);
        StyleItem styleItem = new StyleItem();
        styleItem.setName(name.getName());
        styleItem.setValue(propertyType.toString(object));
        return styleItem;
    }

    @Override
    public void performFinish() {
        Object object;
        ControlSource controlSource;
        if (this.m_ChosenFieldModel == null) {
            return;
        }
        int n = this.m_ChosenFieldModel.getRowCount();
        if (n == 0) {
            return;
        }
        String[] stringArray = this.m_ChosenFieldModel.getFieldNames();
        Field[] fieldArray = TableSelectFieldTab.createFields(stringArray, "Literal", this.m_DataSchema);
        Field[] fieldArray2 = TableSelectFieldTab.createFields(stringArray, "Field", this.m_DataSchema);
        for (int i = 0; i < fieldArray2.length; ++i) {
            controlSource = fieldArray2[i].getControlSource();
            controlSource.setDataSource(this.m_Cache);
            controlSource.setText(this.m_Cache + ":" + controlSource.getField());
        }
        this.m_RawReport = (RawReport)this.m_Table.getResourceProvider();
        Style style = this.m_RawReport.getStyle("table.label");
        controlSource = this.m_RawReport.getStyle("table.field");
        if (style == null) {
            style = TableSelectFieldTab.createStyle("table.label", BORDER_ELEMENT_NAMES, new String[]{"Solid"});
            this.m_RawReport.addStyle(style);
        }
        if (controlSource == null) {
            controlSource = TableSelectFieldTab.createStyle("table.field", BORDER_ELEMENT_NAMES, new String[]{"Solid"});
            this.m_RawReport.addStyle((Style)controlSource);
        }
        this.m_Table.setGrowable(true);
        this.m_Table.setShrinkable(true);
        this.m_Table.setName(this.m_Table.getCache());
        TableHeader tableHeader = new TableHeader();
        tableHeader.setHeight(400);
        UiFactory.current().buildShape((RawModelElement)tableHeader);
        TableBody tableBody = new TableBody();
        tableBody.setTop(401);
        tableBody.setHeight(400);
        UiFactory.current().buildShape((RawModelElement)tableBody);
        this.m_Table.setHeader(tableHeader);
        this.m_Table.setBody(tableBody);
        HBox hBox = new HBox();
        hBox.setFill(true);
        hBox.setVisible(true);
        hBox.setHeight(400);
        hBox.setLeft(this.m_Table.getLeft());
        tableHeader.addRawElement((RawModelElement)hBox);
        HBox hBox2 = new HBox();
        hBox2.setFill(true);
        hBox2.setVisible(true);
        tableBody.addRawElement((RawModelElement)hBox2);
        for (int i = 0; i < n; ++i) {
            object = new Cell();
            object.setFill(true);
            object.addRawElement((RawModelElement)fieldArray[i]);
            fieldArray[i].setStyle((IStyle)style);
            hBox.addCell((Cell)object);
            object = new Cell();
            object.setFill(true);
            object.addRawElement((RawModelElement)fieldArray2[i]);
            fieldArray2[i].setStyle((IStyle)controlSource);
            hBox2.addCell((Cell)object);
        }
        HBoxShape hBoxShape = (HBoxShape)UiFactory.current().buildShape((RawModelElement)hBox);
        hBoxShape.layoutCells();
        object = (HBoxShape)UiFactory.current().buildShape((RawModelElement)hBox2);
        ((HBoxShape)object).layoutCells();
        UiFactory.current().buildShape((RawModelElement)this.m_Table);
    }

    static Field[] createFields(String[] stringArray, String string, DataSchema dataSchema) {
        Field[] fieldArray = new Field[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = dataSchema.getColumnIndex(stringArray[i]);
            DataType dataType = dataSchema.getColumnType(n);
            fieldArray[i] = TableSelectFieldTab.createField(stringArray[i], string, null);
            if (dataType.isNumeric()) {
                fieldArray[i].setTextAlign("Right");
            }
            if (!"Literal".equals(string)) continue;
            fieldArray[i].setTextAlign("Center");
            fieldArray[i].setVerticalAlign("Center");
        }
        return fieldArray;
    }

    static Field createField(String string, String string2, Style style) {
        Field field = new Field();
        field.setName(string);
        if (style != null) {
            field.setStyle((IStyle)style);
        }
        ControlSource controlSource = new ControlSource(string);
        controlSource.setType(string2);
        controlSource.setField(string);
        field.setControlSource(controlSource);
        return field;
    }

    @Override
    public void entered() {
        String string = this.m_Table.getCache();
        if (this.m_Cache == null || !this.m_Cache.equals(string)) {
            this.m_Cache = string;
            this.updateTable(this.m_Cache);
            this.update();
            this.m_Layout.layoutContainer(this);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
    }

    public class FieldModel
    extends ElxTableModel {
        private List<Row> m_Items;

        public FieldModel() {
            super(I18N.ERD, COLUMNS);
            this.m_Items = new ArrayList<Row>();
        }

        public FieldModel(DataSchema dataSchema) {
            this();
            this.buildItems(dataSchema);
        }

        @Override
        public int getRowCount() {
            return this.m_Items.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Row row = this.m_Items.get(n);
            if (n2 == 0) {
                return row.name;
            }
            return I18N.getDataTypeName(row.type);
        }

        public List<Row> getItems() {
            return this.m_Items;
        }

        public String[] getFieldNames() {
            String[] stringArray = new String[this.m_Items.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                Row row = this.m_Items.get(i);
                stringArray[i] = row.name;
            }
            return stringArray;
        }

        public void update() {
            this.fireTableDataChanged();
        }

        protected void buildItems(DataSchema dataSchema) {
            if (dataSchema != null) {
                this.m_Items.clear();
                int n = dataSchema.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    Row row = new Row(dataSchema.getColumnName(i), dataSchema.getColumnType(i));
                    this.m_Items.add(row);
                }
            }
        }
    }

    public static class Row
    implements Comparable<Object> {
        public String name;
        public DataType type;

        public Row(String string, DataType dataType) {
            this.name = string;
            this.type = dataType;
        }

        @Override
        public int compareTo(Object object) {
            if (object instanceof Row) {
                return this.name.compareTo(((Row)object).name);
            }
            return -1;
        }
    }
}

