/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.table;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Table;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.util.WizardUtil;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;

public class TableTab
extends TabComponent {
    private Table m_Table;
    private ArchLayout m_Layout;
    private JComboBox m_DataSources;
    private JCheckBox m_ShowIfEmpty;
    private JRadioButton m_OverAll;
    private JRadioButton m_OverGroup;
    private JRadioButton m_OverRecord;

    public TableTab(Table table) {
        this.m_Table = table;
        this.m_Layout = new ArchLayout();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(this.m_Layout);
        this.m_DataSources = SwingFactory.newComboBox("ds", this.getDataSources());
        this.add(this.m_DataSources);
        this.m_DataSources.setEditable(true);
        this.add(SwingFactory.newLabel("DS.label"));
        this.add(SwingFactory.newButton("ADD.dots", new CodeBlock((Object)this, "addDataSource")));
        this.m_ShowIfEmpty = SwingFactory.newCheckBox("empty");
        this.add(this.m_ShowIfEmpty);
        this.m_OverAll = SwingFactory.newRadioButton("DSGROUP.over-all");
        this.add(this.m_OverAll);
        this.m_OverGroup = SwingFactory.newRadioButton("DSGROUP.over-group");
        this.add(this.m_OverGroup);
        this.m_OverRecord = SwingFactory.newRadioButton("DSGROUP.over-record");
        this.add(this.m_OverRecord);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_OverAll);
        buttonGroup.add(this.m_OverGroup);
        buttonGroup.add(this.m_OverRecord);
        this.m_Layout.stickLeft("DS.label");
        this.m_Layout.vCenter("DS.label", "ds");
        this.m_Layout.stickTop("ds");
        this.m_Layout.putRight("ds", "DS.label", 10);
        this.m_Layout.stickTop("ADD.dots");
        this.m_Layout.stickRight("ADD.dots");
        this.m_Layout.setHeight("ADD.dots", "ds");
        this.m_Layout.putLeft("ds", "ADD.dots");
        this.m_Layout.alignBelow("DSGROUP.over-all", "ds");
        this.m_Layout.putRight("DSGROUP.over-group", "DSGROUP.over-all", 10);
        this.m_Layout.vCenter("DSGROUP.over-group", "DSGROUP.over-all");
        this.m_Layout.putRight("DSGROUP.over-record", "DSGROUP.over-group", 10);
        this.m_Layout.vCenter("DSGROUP.over-record", "DSGROUP.over-group");
        this.m_Layout.alignBelow("empty", "DSGROUP.over-all", 10);
        this.m_DataSources.setSelectedItem(this.m_Table.getCache());
        this.m_ShowIfEmpty.setSelected(this.m_Table.isShowEmptyTable());
        String string = this.m_Table.getDataRange();
        if ("Group".equals(string)) {
            this.m_OverGroup.setSelected(true);
        } else if ("Record".equals(string)) {
            this.m_OverRecord.setSelected(true);
        } else {
            this.m_OverAll.setSelected(true);
        }
        I18N.ERD_MAP.injectComponents("TableTab.", this);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("TableTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("TableTab.message");
    }

    @Override
    public void performFinish() {
        this.exited();
        if (this.m_ShowIfEmpty.isSelected() != this.m_Table.isShowEmptyTable()) {
            this.m_Table.setShowEmptyTable(this.m_ShowIfEmpty.isSelected());
        }
        if (this.m_OverAll.isSelected()) {
            this.m_Table.setDataRange("All");
        } else if (this.m_OverGroup.isSelected()) {
            this.m_Table.setDataRange("Group");
        } else {
            this.m_Table.setDataRange("Record");
        }
    }

    @Override
    public void exited() {
        String string = (String)this.m_DataSources.getEditor().getItem();
        if (!string.equals(this.m_Table.getCache())) {
            this.m_Table.setCache(string);
        }
    }

    private String[] getDataSources() {
        RawReport rawReport = (RawReport)this.m_Table.getResourceProvider();
        return WizardUtil.getDataSourceNames(rawReport);
    }

    public void addDataSource() {
        RawReport rawReport = (RawReport)this.m_Table.getResourceProvider();
        WizardUtil.addDS(rawReport, this.m_DataSources);
    }
}

