/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.text;

import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.IControlSourceHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.wizard.data.FieldPanel;
import com.elixirtech.wizard.data.IDataPanel;
import com.elixirtech.wizard.data.LiteralPanel;
import com.elixirtech.wizard.data.OperationPanel;
import com.elixirtech.wizard.data.ScriptPanel;
import com.elixirtech.wizard.data.URLPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class FieldTab
extends TabComponent
implements ItemListener {
    private static final String[] TYPES = new String[]{"Field", "Operation", "Script", "URL", "Literal"};
    private static final String[] TYPE_KEYS = new String[]{"ControlSource.FIELD", "ControlSource.OPERATION", "ControlSource.SCRIPT", "ControlSource.URL", "ControlSource.LITERAL"};
    protected IControlSourceHolder m_CSHolder;
    protected I18NComboBox m_Type;
    protected CardLayout m_CardLayout;
    protected JPanel m_Center;
    protected IDataPanel[] m_Panels;

    public FieldTab(IControlSourceHolder iControlSourceHolder) {
        assert (iControlSourceHolder instanceof RawModelElement);
        this.m_CSHolder = iControlSourceHolder;
        ControlSource controlSource = this.m_CSHolder.getControlSource();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.buildNorth();
        this.add((Component)jPanel, "North");
        this.buildPanels(controlSource);
        this.m_CardLayout = new CardLayout();
        this.m_Center = new JPanel(this.m_CardLayout);
        Name[] nameArray = this.getTypes();
        for (int i = 0; i < this.m_Panels.length; ++i) {
            this.m_Center.add(nameArray[i].getName(), (JPanel)((Object)this.m_Panels[i]));
        }
        this.add((Component)this.m_Center, "Center");
        this.m_Type.addItemListener(this);
        this.m_Type.setSelectedId(controlSource.getType());
        if (this.m_Type.getSelectedIndex() < 0) {
            this.m_Type.setSelectedIndex(0);
        }
        I18N.ERD_MAP.injectComponents("FieldTab.", this);
    }

    protected Name[] getTypes() {
        return I18NComboBox.buildNames(TYPES, I18N.ERD, TYPE_KEYS);
    }

    protected JPanel buildNorth() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(SwingFactory.newLabel("field-type"));
        this.m_Type = I18NComboBox.apply(this.getTypes());
        jPanel.add(this.m_Type);
        return jPanel;
    }

    public void update() {
        this.m_CardLayout.show(this.m_Center, this.m_Type.getSelectedId());
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
        for (int i = 0; i < this.m_Panels.length; ++i) {
            ((JPanel)((Object)this.m_Panels[i])).setEnabled(bl);
        }
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("FieldTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("FieldTab.message");
    }

    @Override
    public boolean containsProperty(String string) {
        return "Field.ControlSource".equals(string);
    }

    @Override
    public void performFinish() {
        ControlSource controlSource = this.m_Panels[this.m_Type.getSelectedIndex()].getControlSource();
        this.m_CSHolder.setControlSource(controlSource);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.update();
    }

    protected void buildPanels(ControlSource controlSource) {
        RawModelElement rawModelElement = (RawModelElement)this.m_CSHolder;
        RawReport rawReport = (RawReport)rawModelElement.getResourceProvider();
        this.m_Panels = new IDataPanel[5];
        this.m_Panels[0] = new FieldPanel(rawReport, rawModelElement, controlSource);
        this.m_Panels[1] = new OperationPanel(rawReport, rawModelElement, controlSource);
        this.m_Panels[2] = new ScriptPanel(controlSource);
        this.m_Panels[3] = new URLPanel(controlSource, new String[]{"Text"});
        this.m_Panels[4] = new LiteralPanel(controlSource);
    }
}

