/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.text;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Format;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class FormatPanel
extends JPanel {
    Options m_Options;
    Builder m_Details;
    Pattern m_Pattern;
    NumberPanel m_NumberPanel;
    DateTimePanel m_DateTimePanel;
    CodeBlock m_Mediator;
    Locale m_Locale;
    static final String[] TYPE_NAMES = new String[]{"None", "Currency", "Percent", "Number", "Date/Time"};
    static final String[] NAMES = new String[]{"Format.None", "Format.Currency", "Format.Percent", "Format.Number", "Format.DateTime"};
    static final String[] PANEL_TYPES = new String[]{"None", "Number", "Number", "Number", "DateTime"};
    static final String[] CHOICES = new String[]{"None", "Full", "Short", "Medium", "Long"};
    static final String[] KEYS = new String[]{"Format.NONE", "Format.FULL", "Format.SHORT", "Format.MEDIUM", "Format.LONG"};

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        FormatPanel formatPanel = new FormatPanel();
        jFrame.getContentPane().add(formatPanel);
        jFrame.pack();
        formatPanel.setFormat(null, null);
        jFrame.setVisible(true);
    }

    public FormatPanel() {
        this.setLayout(new BorderLayout());
        this.m_Mediator = new CodeBlock((Object)this, "update");
        this.m_Options = new Options();
        this.m_Details = new Builder();
        this.m_Pattern = new Pattern();
        this.add((Component)this.m_Options, "North");
        this.add((Component)this.m_Details, "Center");
        this.add((Component)this.m_Pattern, "South");
        I18N.ERD_MAP.injectComponents("FormatPanel.", this);
    }

    public void setFormat(Locale locale, Format format) {
        Locale locale2 = this.m_Locale = locale != null ? locale : Locale.getDefault();
        if (format != null) {
            this.m_Options.setType(format.getType());
            String string = format.getCustomPattern();
            if (StringUtil.notEmpty(string)) {
                this.m_NumberPanel.setDefault();
                this.m_DateTimePanel.setDefault();
                this.m_Pattern.setFormat(format);
            } else {
                this.m_NumberPanel.setFormat(format);
                this.m_DateTimePanel.setFormat(format);
                this.m_Pattern.setFormat(format);
            }
        } else {
            this.m_NumberPanel.setDefault();
            this.m_DateTimePanel.setDefault();
            this.m_Pattern.setValues(null, null);
        }
        this.update();
    }

    public Format getFormat() {
        int n = this.m_Options.getTypeIndex();
        if (n == 0) {
            return null;
        }
        Format format = new Format();
        format.setType(TYPE_NAMES[n]);
        if (this.m_Pattern.isCustom()) {
            format.setCustomPattern(this.m_Pattern.getPattern());
        } else if (n == 1 || n == 2 || n == 3) {
            this.m_NumberPanel.getFormat(format);
        } else if (n == 4) {
            this.m_DateTimePanel.getFormat(format);
        }
        return format;
    }

    public void update() {
        this.m_Pattern.m_CustomPattern.getDocument().removeDocumentListener(this.m_Mediator);
        this.m_Pattern.m_Sample.setForeground(Color.black);
        int n = this.m_Options.getTypeIndex();
        this.m_Details.showCard(PANEL_TYPES[n]);
        this.m_Pattern.setVisible(n != 0);
        if (this.m_Pattern.isCustom()) {
            this.m_NumberPanel.setEnabled(false);
            this.m_DateTimePanel.setEnabled(false);
            this.m_Pattern.m_CustomPattern.setEnabled(true);
            try {
                this.m_Pattern.m_Sample.setText(this.getSample(this.m_Pattern.getPattern()));
            }
            catch (Exception exception) {
                this.m_Pattern.m_Sample.setForeground(Color.red);
                this.m_Pattern.m_Sample.setText(exception.getMessage());
            }
        } else {
            this.m_NumberPanel.setEnabled(true);
            this.m_DateTimePanel.setEnabled(true);
            this.m_Pattern.m_CustomPattern.setEnabled(false);
            if (n == 1 || n == 2 || n == 3) {
                this.m_NumberPanel.update();
            } else if (n == 4) {
                this.m_DateTimePanel.update();
            }
        }
        if (this.m_Pattern.isCustom()) {
            this.m_Pattern.m_CustomPattern.getDocument().addDocumentListener(this.m_Mediator);
        }
    }

    public boolean isFormatValid() {
        return this.m_Pattern.m_Sample.getForeground() != Color.red;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this.m_Options, bl);
        this.m_NumberPanel.setEnabled(bl);
        this.m_DateTimePanel.setEnabled(bl);
        this.m_Pattern.setEnabled(bl);
    }

    protected String getSample(String string) {
        if (string.indexOf("${") >= 0) {
            return "No sample available when ${substitution} used";
        }
        int n = this.m_Options.getTypeIndex();
        if (n == 1 || n == 2 || n == 3) {
            return this.m_NumberPanel.getSample(string);
        }
        if (n == 4) {
            return this.m_DateTimePanel.getSample(string);
        }
        return null;
    }

    protected void refreshPattern() {
        int n = this.m_Options.getTypeIndex();
        if (n == 1 || n == 2 || n == 3) {
            this.m_NumberPanel.update();
        } else if (n == 4) {
            this.m_DateTimePanel.update();
        }
    }

    private class Options
    extends JPanel {
        private I18NComboBox m_Type;

        public Options() {
            this.setLayout(new FlowLayout(0));
            this.add(SwingFactory.newLabel("format-type"));
            this.m_Type = I18NComboBox.apply(I18NComboBox.buildNames(TYPE_NAMES, I18N.ERD, NAMES));
            this.add(this.m_Type);
            this.m_Type.addItemListener(FormatPanel.this.m_Mediator);
        }

        public void setType(String string) {
            this.m_Type.setSelectedId(string);
        }

        public String getType() {
            return this.m_Type.getSelectedId();
        }

        public int getTypeIndex() {
            return this.m_Type.getSelectedIndex();
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.m_Type.setEnabled(bl);
        }
    }

    private class Builder
    extends JPanel {
        private CardLayout m_Layout = new CardLayout();

        public Builder() {
            this.setLayout(this.m_Layout);
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.add("None", new JPanel());
            FormatPanel.this.m_NumberPanel = new NumberPanel();
            this.add("Number", FormatPanel.this.m_NumberPanel);
            FormatPanel.this.m_DateTimePanel = new DateTimePanel();
            this.add("DateTime", FormatPanel.this.m_DateTimePanel);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            FormatPanel.this.m_NumberPanel.setEnabled(bl);
            FormatPanel.this.m_DateTimePanel.setEnabled(bl);
        }

        public void showCard(String string) {
            this.m_Layout.show(this, string);
        }
    }

    private class Pattern
    extends JPanel {
        private ArchLayout m_Layout;
        private JCheckBox m_Custom;
        JTextField m_CustomPattern;
        JLabel m_Sample;

        public Pattern() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_Layout = new ArchLayout();
            this.setLayout(this.m_Layout);
            this.m_Custom = SwingFactory.newCheckBox("custom");
            this.add(this.m_Custom);
            this.m_Custom.addItemListener(FormatPanel.this.m_Mediator);
            this.m_CustomPattern = SwingFactory.newTextField("pattern");
            this.add(this.m_CustomPattern);
            this.m_CustomPattern.setEnabled(false);
            this.add(SwingFactory.newLabel("sample-label"));
            this.m_Sample = SwingFactory.newLabel("sample");
            this.add(this.m_Sample);
            this.m_Sample.setBorder(BorderFactory.createEtchedBorder());
            this.m_Layout.stickTop("pattern");
            this.m_Layout.putRight("pattern", "custom", 10);
            this.m_Layout.stickLeft("custom");
            this.m_Layout.vCenter("custom", "pattern");
            this.m_Layout.stickLeft("sample-label");
            this.m_Layout.vCenter("sample-label", "sample");
            this.m_Layout.putBelow("sample", "pattern", 10);
            this.m_Layout.putRight("sample", "sample-label", 10);
            this.m_Layout.stickRight("pattern");
            this.m_Layout.stickRight("sample");
            this.m_Layout.setHeight("sample", "pattern");
        }

        public void setFormat(Format format) {
            String string = format.getCustomPattern();
            if (StringUtil.notEmpty(string)) {
                this.m_Custom.setSelected(true);
                this.m_CustomPattern.setText(string);
            }
        }

        public boolean isCustom() {
            return this.m_Custom.isSelected();
        }

        public void setValues(String string, String string2) {
            if (!this.isCustom()) {
                this.m_CustomPattern.setText(string);
            }
            this.m_Sample.setText(string2);
        }

        public String getPattern() {
            return this.m_CustomPattern.getText();
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            SwingUtil.setEnabled(this, bl);
        }
    }

    private class NumberPanel
    extends JPanel {
        private ArchLayout m_Layout = new ArchLayout();
        private JSpinner m_MinInt;
        private JSpinner m_MaxInt;
        private JSpinner m_MinFrac;
        private JSpinner m_MaxFrac;
        private JSpinner m_GroupingSize;
        private JCheckBox m_GroupingUsed;
        private JCheckBox m_DecimalSeparatorAlwaysShown;

        public NumberPanel() {
            this.setLayout(this.m_Layout);
            this.add(SwingFactory.newLabel("int-label"));
            this.add(SwingFactory.newLabel("int-minlabel"));
            this.m_MinInt = SwingFactory.newSpinner("int-min", new SpinnerNumberModel(1, 0, 300, 1));
            this.add(this.m_MinInt);
            this.add(SwingFactory.newLabel("int-maxlabel"));
            this.m_MaxInt = SwingFactory.newSpinner("int-max", new SpinnerNumberModel(10, 0, 300, 1));
            this.add(this.m_MaxInt);
            this.add(SwingFactory.newLabel("frac-label"));
            this.add(SwingFactory.newLabel("frac-minlabel"));
            this.m_MinFrac = SwingFactory.newSpinner("frac-min", new SpinnerNumberModel(2, 0, 300, 1));
            this.add(this.m_MinFrac);
            this.add(SwingFactory.newLabel("frac-maxlabel"));
            this.m_MaxFrac = SwingFactory.newSpinner("frac-max", new SpinnerNumberModel(2, 0, 300, 1));
            this.add(this.m_MaxFrac);
            this.add(SwingFactory.newLabel("gsz-label"));
            this.m_GroupingSize = SwingFactory.newSpinner("gsz", new SpinnerNumberModel(3, 1, 300, 1));
            this.add(this.m_GroupingSize);
            this.add(SwingFactory.newLabel("gused-label"));
            this.m_GroupingUsed = SwingFactory.newCheckBox("gused");
            this.add(this.m_GroupingUsed);
            this.add(SwingFactory.newLabel("dec-label"));
            this.m_DecimalSeparatorAlwaysShown = SwingFactory.newCheckBox("dec");
            this.add(this.m_DecimalSeparatorAlwaysShown);
            this.m_Layout.stickLeft("int-label");
            this.m_Layout.vCenter("int-label", "int-min");
            this.m_Layout.vCenter("int-minlabel", "int-min");
            this.m_Layout.vCenter("int-maxlabel", "int-min");
            this.m_Layout.vCenter("int-max", "int-min");
            this.m_Layout.stickTop("int-min");
            this.m_Layout.putRight("int-min", "int-label,frac-label,gsz-label,gused-label,dec-label", 10);
            this.m_Layout.putRight("int-maxlabel", "int-min", 10);
            this.m_Layout.putRight("int-max", "int-maxlabel", 10);
            this.m_Layout.putLeft("int-minlabel", "int-min", -10);
            this.m_Layout.stickLeft("frac-label");
            this.m_Layout.vCenter("frac-label", "frac-min");
            this.m_Layout.vCenter("frac-minlabel", "frac-min");
            this.m_Layout.vCenter("frac-maxlabel", "frac-min");
            this.m_Layout.vCenter("frac-max", "frac-min");
            this.m_Layout.putLeft("frac-minlabel", "frac-min", -10);
            this.m_Layout.alignBelow("frac-min", "int-min");
            this.m_Layout.alignBelow("frac-maxlabel", "int-maxlabel");
            this.m_Layout.alignBelow("frac-max", "int-max");
            this.m_Layout.stickLeft("gused-label");
            this.m_Layout.vCenter("gused-label", "gused");
            this.m_Layout.alignBelow("gused", "frac-min");
            this.m_Layout.stickLeft("gsz-label");
            this.m_Layout.vCenter("gsz-label", "gsz");
            this.m_Layout.alignBelow("gsz", "gused");
            this.m_Layout.stickLeft("dec-label");
            this.m_Layout.vCenter("dec-label", "dec");
            this.m_Layout.alignBelow("dec", "gsz");
            this.m_MinInt.getModel().addChangeListener(FormatPanel.this.m_Mediator);
            this.m_MaxInt.getModel().addChangeListener(FormatPanel.this.m_Mediator);
            this.m_MinFrac.getModel().addChangeListener(FormatPanel.this.m_Mediator);
            this.m_MaxFrac.getModel().addChangeListener(FormatPanel.this.m_Mediator);
            this.m_GroupingSize.getModel().addChangeListener(FormatPanel.this.m_Mediator);
            this.m_GroupingUsed.addItemListener(FormatPanel.this.m_Mediator);
            this.m_DecimalSeparatorAlwaysShown.addItemListener(FormatPanel.this.m_Mediator);
        }

        public void setFormat(Format format) {
            this.m_MinInt.setValue(format.getMinIntegerDigits());
            this.m_MaxInt.setValue(format.getMaxIntegerDigits());
            this.m_MinFrac.setValue(format.getMinFractionDigits());
            this.m_MaxFrac.setValue(format.getMaxFractionDigits());
            this.m_GroupingSize.setValue(format.getGroupingSize());
            this.m_GroupingUsed.setSelected(format.isGroupingUsed());
            this.m_DecimalSeparatorAlwaysShown.setSelected(format.isDecimalSeparatorAlwaysShown());
        }

        public void setDefault() {
            this.m_MinInt.setValue(1);
            this.m_MaxInt.setValue(12);
            this.m_MinFrac.setValue(2);
            this.m_MaxFrac.setValue(2);
            this.m_GroupingSize.setValue(3);
            this.m_GroupingUsed.setSelected(true);
            this.m_DecimalSeparatorAlwaysShown.setSelected(true);
        }

        public void getFormat(Format format) {
            format.setMinIntegerDigits(((Number)this.m_MinInt.getValue()).intValue());
            format.setMaxIntegerDigits(((Number)this.m_MaxInt.getValue()).intValue());
            format.setMinFractionDigits(((Number)this.m_MinFrac.getValue()).intValue());
            format.setMaxFractionDigits(((Number)this.m_MaxFrac.getValue()).intValue());
            format.setGroupingSize(((Number)this.m_GroupingSize.getValue()).intValue());
            format.setGroupingUsed(this.m_GroupingUsed.isSelected());
            format.setDecimalSeparatorAlwaysShown(this.m_DecimalSeparatorAlwaysShown.isSelected());
        }

        public void update() {
            int n = FormatPanel.this.m_Options.getTypeIndex();
            Format format = new Format();
            format.setType(TYPE_NAMES[n]);
            FormatPanel.this.m_NumberPanel.getFormat(format);
            NumberFormat numberFormat = this.getNumberFormat();
            if (numberFormat != null) {
                String string = ((DecimalFormat)numberFormat).toPattern();
                String string2 = numberFormat.format(123456.7890123) + "  " + numberFormat.format(-123456.7890123);
                FormatPanel.this.m_Pattern.setValues(string, string2);
            }
        }

        public String getSample(String string) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(FormatPanel.this.m_Locale);
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
            decimalFormat.applyLocalizedPattern(string);
            String string2 = decimalFormat.format(123456.7890123) + "  " + decimalFormat.format(-123456.7890123);
            return string2;
        }

        public NumberFormat getNumberFormat() {
            int n = FormatPanel.this.m_Options.getTypeIndex();
            Format format = new Format();
            format.setType(TYPE_NAMES[n]);
            FormatPanel.this.m_NumberPanel.getFormat(format);
            NumberFormat numberFormat = null;
            if (n == 1) {
                numberFormat = NumberFormat.getCurrencyInstance(FormatPanel.this.m_Locale);
            }
            if (n == 2) {
                numberFormat = NumberFormat.getPercentInstance(FormatPanel.this.m_Locale);
            }
            if (n == 3) {
                numberFormat = NumberFormat.getNumberInstance(FormatPanel.this.m_Locale);
            }
            if (numberFormat != null) {
                this.configNumberFormatter(numberFormat, format);
            }
            return numberFormat;
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            SwingUtil.setEnabled(this, bl);
        }

        private void configNumberFormatter(NumberFormat numberFormat, Format format) {
            numberFormat.setMinimumIntegerDigits(format.getMinIntegerDigits());
            numberFormat.setMaximumIntegerDigits(format.getMaxIntegerDigits());
            numberFormat.setMinimumFractionDigits(format.getMinFractionDigits());
            numberFormat.setMaximumFractionDigits(format.getMaxFractionDigits());
            numberFormat.setGroupingUsed(format.isGroupingUsed());
            ((DecimalFormat)numberFormat).setGroupingSize(format.getGroupingSize());
            ((DecimalFormat)numberFormat).setDecimalSeparatorAlwaysShown(format.isDecimalSeparatorAlwaysShown());
        }
    }

    public class DateTimePanel
    extends JPanel {
        private ArchLayout m_Layout;
        private I18NComboBox m_DateCombo = I18NComboBox.apply(I18NComboBox.buildNames(CHOICES, I18N.ERD, KEYS));
        private I18NComboBox m_TimeCombo = I18NComboBox.apply(I18NComboBox.buildNames(CHOICES, I18N.ERD, KEYS));

        public DateTimePanel() {
            this.m_Layout = new ArchLayout();
            this.setLayout(this.m_Layout);
            this.add(SwingFactory.newLabel("date-label"));
            this.add("date", this.m_DateCombo);
            this.add(SwingFactory.newLabel("time-label"));
            this.add("time", this.m_TimeCombo);
            this.m_Layout.stickTop("date");
            this.m_Layout.stickLeft("date-label");
            this.m_Layout.vCenter("date-label", "date");
            this.m_Layout.putRight("date", "date-label,time-label", 10);
            this.m_Layout.stickLeft("time-label");
            this.m_Layout.vCenter("time-label", "time");
            this.m_Layout.alignBelow("time", "date");
            this.m_DateCombo.addItemListener(FormatPanel.this.m_Mediator);
            this.m_TimeCombo.addItemListener(FormatPanel.this.m_Mediator);
        }

        public void setFormat(Format format) {
            this.m_DateCombo.setSelectedId(format.getDateFormat());
            this.m_TimeCombo.setSelectedId(format.getTimeFormat());
        }

        public void setDefault() {
            this.m_DateCombo.setSelectedId("Short");
            this.m_TimeCombo.setSelectedId("Short");
        }

        public void getFormat(Format format) {
            format.setDateFormat(this.m_DateCombo.getSelectedId());
            format.setTimeFormat(this.m_TimeCombo.getSelectedId());
        }

        public void update() {
            String string = null;
            String string2 = null;
            DateFormat dateFormat = this.getDateFormat();
            if (dateFormat != null) {
                string = ((SimpleDateFormat)dateFormat).toPattern();
                string2 = dateFormat.format(new Date());
            }
            FormatPanel.this.m_Pattern.setValues(string, string2);
        }

        public DateFormat getDateFormat() {
            int n = this.getStyle(this.m_DateCombo.getSelectedId());
            int n2 = this.getStyle(this.m_TimeCombo.getSelectedId());
            DateFormat dateFormat = null;
            if (n == -1) {
                if (n2 != -1) {
                    dateFormat = DateFormat.getTimeInstance(n2, FormatPanel.this.m_Locale);
                }
            } else {
                dateFormat = n2 == -1 ? DateFormat.getDateInstance(n, FormatPanel.this.m_Locale) : DateFormat.getDateTimeInstance(n, n2, FormatPanel.this.m_Locale);
            }
            return dateFormat;
        }

        public String getSample(String string) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, FormatPanel.this.m_Locale);
            return simpleDateFormat.format(new Date());
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            SwingUtil.setEnabled(this, bl);
        }

        private int getStyle(String string) {
            if (string == null || string.equals("None")) {
                return -1;
            }
            if (string.equals("Full")) {
                return 0;
            }
            if (string.equals("Long")) {
                return 1;
            }
            if (string.equals("Medium")) {
                return 2;
            }
            if (string.equals("Short")) {
                return 3;
            }
            return 3;
        }
    }
}

