/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.text;

import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.IControlSourceHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.TOCElementHolder;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.wizard.data.FieldPanel;
import com.elixirtech.wizard.data.IDataPanel;
import com.elixirtech.wizard.data.LiteralPanel;
import com.elixirtech.wizard.data.ScriptPanel;
import com.elixirtech.wizard.text.FieldTab;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class TOCTab
extends FieldTab
implements ItemListener {
    private static final String[] TYPES = new String[]{"Field", "Script", "Literal"};
    private static final String[] TYPE_KEYS = new String[]{"ControlSource.FIELD", "ControlSource.SCRIPT", "ControlSource.LITERAL"};
    private JCheckBox m_TOCEnabled;

    public TOCTab(TOCElementHolder tOCElementHolder) {
        super((IControlSourceHolder)tOCElementHolder);
    }

    @Override
    protected Name[] getTypes() {
        return I18NComboBox.buildNames(TYPES, I18N.ERD, TYPE_KEYS);
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("TOCTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("TOCTab.message");
    }

    @Override
    protected JPanel buildNorth() {
        JPanel jPanel = super.buildNorth();
        jPanel.add(Box.createHorizontalStrut(20));
        this.m_TOCEnabled = SwingFactory.newCheckBox("toc-enabled");
        jPanel.add(this.m_TOCEnabled);
        TOCElementHolder tOCElementHolder = (TOCElementHolder)this.m_CSHolder;
        this.m_TOCEnabled.setSelected(tOCElementHolder.isTableOfContents());
        I18N.ERD_MAP.injectComponents("TOCTab.", jPanel);
        return jPanel;
    }

    @Override
    public void performFinish() {
        super.performFinish();
        TOCElementHolder tOCElementHolder = (TOCElementHolder)this.m_CSHolder;
        tOCElementHolder.setTableOfContents(this.m_TOCEnabled.isSelected());
    }

    @Override
    protected void buildPanels(ControlSource controlSource) {
        RawModelElement rawModelElement = (RawModelElement)this.m_CSHolder;
        RawReport rawReport = (RawReport)rawModelElement.getResourceProvider();
        this.m_Panels = new IDataPanel[3];
        this.m_Panels[0] = new FieldPanel(rawReport, rawModelElement, controlSource);
        this.m_Panels[1] = new ScriptPanel(controlSource);
        this.m_Panels[2] = new LiteralPanel(controlSource);
    }
}

