/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.xml;

import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.jdom.output.XMLOutputter;
import com.elixirtech.util.base64.Base64Decoder;
import com.elixirtech.util.base64.Base64Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class EncryptWrapper {
    public static Document wrap(Document document) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        XMLOutputter xMLOutputter = new XMLOutputter();
        xMLOutputter.output(document, (OutputStream)gZIPOutputStream);
        gZIPOutputStream.close();
        Element element = document.getRootElement();
        Element element2 = new Element("encrypted-" + element.getName(), element.getNamespace());
        element2.setAttribute("version", "1");
        element2.setText(Base64Encoder.encode(byteArrayOutputStream.toByteArray()));
        return new Document(element2);
    }

    public static Document unwrap(Document document) throws IOException {
        Element element = document.getRootElement();
        String string = element.getAttributeValue("version");
        if (!"1".equals(string)) {
            throw new IOException("Incorrect encryption version: " + string);
        }
        String string2 = element.getText();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64Decoder.decode(string2));
        try (GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);){
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document2 = sAXBuilder.build((InputStream)gZIPInputStream);
            return document2;
        }
    }
}

