/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.xml;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SAXParser
implements XMLReader {
    Map<String, Boolean> m_Features = new HashMap<String, Boolean>();
    Map<String, Object> m_Properties = new HashMap<String, Object>();
    EntityResolver m_EntityResolver;
    ErrorHandler m_ErrorHandler;
    ContentHandler m_ContentHandler;
    DTDHandler m_DTDHandler;

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean bl = this.m_Features.get(string);
        return bl != null && bl.equals(Boolean.TRUE);
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.m_Features.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.m_Properties.get(string);
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.m_Properties.put(string, object);
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.m_EntityResolver = entityResolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.m_EntityResolver;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
        this.m_DTDHandler = dTDHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.m_DTDHandler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.m_ContentHandler = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.m_ContentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.m_ErrorHandler = errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.m_ErrorHandler;
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        try {
            javax.xml.parsers.SAXParser sAXParser = this.buildParser();
            sAXParser.parse(inputSource, (DefaultHandler)new DH());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("ParserConfigurationException: " + String.valueOf(parserConfigurationException), parserConfigurationException);
        }
    }

    @Override
    public void parse(String string) throws IOException, SAXException {
        try {
            javax.xml.parsers.SAXParser sAXParser = this.buildParser();
            sAXParser.parse(string, (DefaultHandler)new DH());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("ParserConfigurationException: " + String.valueOf(parserConfigurationException), parserConfigurationException);
        }
    }

    private javax.xml.parsers.SAXParser buildParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(this.getFeature("http://xml.org/sax/features/namespaces"));
        sAXParserFactory.setValidating(this.getFeature("http://xml.org/sax/features/validation"));
        javax.xml.parsers.SAXParser sAXParser = sAXParserFactory.newSAXParser();
        for (String string : this.m_Properties.keySet()) {
            Object object = this.m_Properties.get(string);
            sAXParser.setProperty(string, object);
        }
        return sAXParser;
    }

    private class DH
    extends DefaultHandler {
        private DH() {
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            SAXParser.this.m_ContentHandler.characters(cArray, n, n2);
        }

        @Override
        public void endDocument() throws SAXException {
            SAXParser.this.m_ContentHandler.endDocument();
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            SAXParser.this.m_ContentHandler.endElement(string, string2, string3);
        }

        @Override
        public void endPrefixMapping(String string) throws SAXException {
            SAXParser.this.m_ContentHandler.endPrefixMapping(string);
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            SAXParser.this.m_ContentHandler.ignorableWhitespace(cArray, n, n2);
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
            SAXParser.this.m_ContentHandler.processingInstruction(string, string2);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            SAXParser.this.m_ContentHandler.setDocumentLocator(locator);
        }

        @Override
        public void skippedEntity(String string) throws SAXException {
            SAXParser.this.m_ContentHandler.skippedEntity(string);
        }

        @Override
        public void startDocument() throws SAXException {
            SAXParser.this.m_ContentHandler.startDocument();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            SAXParser.this.m_ContentHandler.startElement(string, string2, string3, attributes);
        }

        @Override
        public void startPrefixMapping(String string, String string2) throws SAXException {
            SAXParser.this.m_ContentHandler.startPrefixMapping(string, string2);
        }

        @Override
        public void notationDecl(String string, String string2, String string3) throws SAXException {
            SAXParser.this.m_DTDHandler.notationDecl(string, string2, string3);
        }

        @Override
        public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
            SAXParser.this.m_DTDHandler.unparsedEntityDecl(string, string2, string3, string4);
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException {
            InputSource inputSource;
            try {
                inputSource = SAXParser.this.m_EntityResolver.resolveEntity(string, string2);
            }
            catch (Exception exception) {
                throw new SAXException("resolveEntity exception: " + exception.getMessage(), exception);
            }
            return inputSource;
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            SAXParser.this.m_ErrorHandler.error(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            SAXParser.this.m_ErrorHandler.fatalError(sAXParseException);
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            SAXParser.this.m_ErrorHandler.warning(sAXParseException);
        }
    }
}

