/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.xml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXWriter
extends DefaultHandler
implements LexicalHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_CANONICAL = false;
    protected PrintWriter fOut;
    protected boolean fCanonical;
    protected int fElementDepth;

    public void setCanonical(boolean bl) {
        this.fCanonical = bl;
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF-8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    @Override
    public void startDocument() throws SAXException {
        this.fElementDepth = 0;
        if (!this.fCanonical) {
            this.fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.fOut.flush();
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.fElementDepth > 0) {
            this.fOut.print("<?");
            this.fOut.print(string);
            if (string2 != null && string2.length() > 0) {
                this.fOut.print(' ');
                this.fOut.print(string2);
            }
            this.fOut.print("?>");
            this.fOut.flush();
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.fElementDepth;
        this.fOut.print('<');
        this.fOut.print(string3);
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                this.fOut.print(' ');
                this.fOut.print(attributes.getQName(i));
                this.fOut.print("=\"");
                this.normalizeAndPrint(attributes.getValue(i));
                this.fOut.print('\"');
            }
        }
        this.fOut.print('>');
        this.fOut.flush();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.normalizeAndPrint(cArray, n, n2);
        this.fOut.flush();
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
        this.fOut.flush();
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.fElementDepth;
        this.fOut.print("</");
        this.fOut.print(string3);
        this.fOut.print('>');
        this.fOut.flush();
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (!this.fCanonical && this.fElementDepth > 0) {
            this.fOut.print("<!--");
            this.normalizeAndPrint(cArray, n, n2);
            this.fOut.print("-->");
            this.fOut.flush();
        }
    }

    protected void normalizeAndPrint(String string) {
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                this.normalizeAndPrint(c);
            }
        }
    }

    protected void normalizeAndPrint(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.normalizeAndPrint(cArray[n + i]);
        }
    }

    protected void normalizeAndPrint(char c) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                this.fOut.print("&quot;");
                break;
            }
            case '\n': 
            case '\r': {
                if (this.fCanonical) {
                    this.fOut.print("&#");
                    this.fOut.print(Integer.toString(c));
                    this.fOut.print(';');
                    break;
                }
            }
            default: {
                this.fOut.print(c);
            }
        }
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }
}

