/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.compression.internal.operators;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import monix.execution.Ack;
import monix.execution.Ack$;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.reactive.compression.CompressionParameters;
import monix.reactive.compression.internal.operators.Gzipper;
import monix.reactive.observers.Subscriber;
import scala.Function1;
import scala.Option;
import scala.concurrent.Future;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class GzipOperator
implements Function1<Subscriber<byte[]>, Subscriber<byte[]>> {
    public final Option<String> monix$reactive$compression$internal$operators$GzipOperator$$fileName;
    public final Option<Instant> monix$reactive$compression$internal$operators$GzipOperator$$modificationTime;
    public final Option<String> monix$reactive$compression$internal$operators$GzipOperator$$comment;
    public final int monix$reactive$compression$internal$operators$GzipOperator$$bufferSize;
    public final CompressionParameters monix$reactive$compression$internal$operators$GzipOperator$$params;

    public GzipOperator(Option<String> fileName, Option<Instant> modificationTime, Option<String> comment, int bufferSize, CompressionParameters params) {
        this.monix$reactive$compression$internal$operators$GzipOperator$$fileName = fileName;
        this.monix$reactive$compression$internal$operators$GzipOperator$$modificationTime = modificationTime;
        this.monix$reactive$compression$internal$operators$GzipOperator$$comment = comment;
        this.monix$reactive$compression$internal$operators$GzipOperator$$bufferSize = bufferSize;
        this.monix$reactive$compression$internal$operators$GzipOperator$$params = params;
    }

    public Subscriber<byte[]> apply(Subscriber<byte[]> out) {
        return new Subscriber<byte[]>(out, this){
            private final Subscriber out$2;
            private final Scheduler scheduler;
            private Future ack;
            private final Gzipper gzipper;
            {
                this.out$2 = out$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.scheduler = out$1.scheduler();
                this.gzipper = new Gzipper($outer.monix$reactive$compression$internal$operators$GzipOperator$$bufferSize, $outer.monix$reactive$compression$internal$operators$GzipOperator$$params.level(), $outer.monix$reactive$compression$internal$operators$GzipOperator$$params.strategy(), $outer.monix$reactive$compression$internal$operators$GzipOperator$$params.flushMode(), $outer.monix$reactive$compression$internal$operators$GzipOperator$$fileName, $outer.monix$reactive$compression$internal$operators$GzipOperator$$modificationTime, $outer.monix$reactive$compression$internal$operators$GzipOperator$$comment);
            }

            public Scheduler scheduler() {
                return this.scheduler;
            }

            public Future onNext(byte[] elem) {
                byte[] result = this.gzipper.onChunk(elem);
                this.ack = this.out$2.onNext(result);
                return this.ack;
            }

            public void onError(Throwable ex) {
                this.gzipper.close();
                this.out$2.onError(ex);
            }

            public void onComplete() {
                if (this.ack == null) {
                    this.ack = Ack.Continue$.MODULE$;
                }
                Future future = Ack$.MODULE$.AckExtensions(this.ack);
                Ack.AckExtensions$.MODULE$.syncOnComplete$extension(future, (Function1)(JProcedure1 & Serializable)x$1 -> {
                    Try try_ = x$1;
                    if (try_ instanceof Success && Ack.Continue$.MODULE$.equals(((Success)try_).value())) {
                        boolean streamErrors = true;
                        try {
                            try {
                                byte[] lastArray = this.gzipper.finish();
                                streamErrors = false;
                                this.out$2.onNext(lastArray);
                                this.out$2.onComplete();
                            }
                            catch (Throwable throwable) {
                                Option option;
                                Throwable throwable2 = throwable;
                                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                    Throwable throwable3;
                                    Throwable e = throwable3 = (Throwable)option.get();
                                    if (streamErrors) {
                                        this.out$2.onError(e);
                                    }
                                }
                                throw throwable;
                            }
                        }
                        finally {
                            this.gzipper.close();
                        }
                    } else {
                        this.gzipper.close();
                    }
                }, (UncaughtExceptionReporter)this.scheduler());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{onComplete$$anonfun$1(scala.util.Try )}, serializedLambda);
            }
        };
    }
}

