/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.operators;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Scheduler;
import monix.execution.cancelables.CompositeCancelable;
import monix.execution.cancelables.CompositeCancelable$;
import monix.execution.cancelables.MultiAssignCancelable;
import monix.execution.cancelables.MultiAssignCancelable$;
import monix.execution.cancelables.SingleAssignCancelable;
import monix.execution.cancelables.SingleAssignCancelable$;
import monix.execution.exceptions.DownstreamTimeoutException;
import monix.execution.exceptions.DownstreamTimeoutException$;
import monix.reactive.Observable;
import monix.reactive.internal.operators.DownstreamTimeoutObservable$;
import monix.reactive.observers.Subscriber;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public final class DownstreamTimeoutObservable<A>
extends Observable<A> {
    private final Observable<A> source;
    public final FiniteDuration monix$reactive$internal$operators$DownstreamTimeoutObservable$$timeout;

    public DownstreamTimeoutObservable(Observable<A> source, FiniteDuration timeout) {
        this.source = source;
        this.monix$reactive$internal$operators$DownstreamTimeoutObservable$$timeout = timeout;
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> downstream) {
        MultiAssignCancelable timeoutCheck = MultiAssignCancelable$.MODULE$.apply();
        SingleAssignCancelable mainTask = SingleAssignCancelable$.MODULE$.apply();
        CompositeCancelable composite = CompositeCancelable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Cancelable[]{mainTask, timeoutCheck}));
        mainTask.$colon$eq(this.source.unsafeSubscribeFn(new Subscriber<A>(downstream, timeoutCheck, mainTask, this){
            private final Subscriber downstream$2;
            private final MultiAssignCancelable timeoutCheck$2;
            private final SingleAssignCancelable mainTask$2;
            private final Scheduler scheduler;
            private final long timeoutMillis;
            private boolean isProcessingOnNext;
            private boolean isDone;
            private long lastEmittedMillis;
            private final /* synthetic */ DownstreamTimeoutObservable $outer;
            {
                this.downstream$2 = downstream$1;
                this.timeoutCheck$2 = timeoutCheck$1;
                this.mainTask$2 = mainTask$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.scheduler = downstream$1.scheduler();
                this.timeoutMillis = $outer.monix$reactive$internal$operators$DownstreamTimeoutObservable$$timeout.toMillis();
                this.isProcessingOnNext = false;
                this.isDone = false;
                this.lastEmittedMillis = this.scheduler().clockMonotonic(package$.MODULE$.MILLISECONDS());
                Predef$.MODULE$.locally((Object)timeoutCheck$1.$colon$eq(this.scheduler().scheduleOnce($outer.monix$reactive$internal$operators$DownstreamTimeoutObservable$$timeout.length(), $outer.monix$reactive$internal$operators$DownstreamTimeoutObservable$$timeout.unit(), (Runnable)this)));
            }

            public Scheduler scheduler() {
                return this.scheduler;
            }

            public void run() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    BoxedUnit boxedUnit;
                    if (!this.isDone) {
                        long sinceLastOnNextInMillis;
                        long rightNow = this.scheduler().clockMonotonic(package$.MODULE$.MILLISECONDS());
                        long l = sinceLastOnNextInMillis = !this.isProcessingOnNext ? 0L : rightNow - this.lastEmittedMillis;
                        if (sinceLastOnNextInMillis >= this.timeoutMillis) {
                            this.triggerTimeout();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            long remainingTimeMillis = this.timeoutMillis - sinceLastOnNextInMillis;
                            this.timeoutCheck$2.$colon$eq(this.scheduler().scheduleOnce(remainingTimeMillis, TimeUnit.MILLISECONDS, (Runnable)this));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            public Future onNext(Object elem) {
                Ack.Stop$ stop$;
                $anon$1 var2_2 = this;
                synchronized (var2_2) {
                    Ack.Stop$ stop$2;
                    if (this.isDone) {
                        stop$2 = Ack.Stop$.MODULE$;
                    } else {
                        this.isProcessingOnNext = true;
                        this.lastEmittedMillis = this.scheduler().clockMonotonic(package$.MODULE$.MILLISECONDS());
                        Future<Ack> future = this.downstream$2.onNext(elem);
                        if (Ack.Continue$.MODULE$.equals(future)) {
                            stop$2 = this.unfreeze$1();
                        } else if (Ack.Stop$.MODULE$.equals(future)) {
                            this.timeoutCheck$2.cancel();
                            stop$2 = Ack.Stop$.MODULE$;
                        } else {
                            Future<Ack> async = future;
                            stop$2 = async.flatMap((Function1 & Serializable)x$1 -> {
                                Ack.Stop$ stop$;
                                Ack ack = x$1;
                                if (Ack.Continue$.MODULE$.equals(ack)) {
                                    $anon$1 var3_3 = this;
                                    synchronized (var3_3) {
                                        Ack ack2 = this.unfreeze$1();
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
                                        stop$ = ack2;
                                    }
                                } else if (Ack.Stop$.MODULE$.equals(ack)) {
                                    this.timeoutCheck$2.cancel();
                                    stop$ = Ack.Stop$.MODULE$;
                                } else {
                                    throw new MatchError((Object)ack);
                                }
                                return stop$;
                            }, (ExecutionContext)this.scheduler());
                        }
                    }
                    stop$ = stop$2;
                }
                return stop$;
            }

            public void triggerTimeout() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    BoxedUnit boxedUnit;
                    if (!this.isDone) {
                        this.isDone = true;
                        DownstreamTimeoutException ex = DownstreamTimeoutException$.MODULE$.apply(this.$outer.monix$reactive$internal$operators$DownstreamTimeoutObservable$$timeout);
                        try {
                            this.downstream$2.onError((Throwable)ex);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        finally {
                            this.mainTask$2.cancel();
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            public void onError(Throwable ex) {
                $anon$1 var2_2 = this;
                synchronized (var2_2) {
                    BoxedUnit boxedUnit;
                    if (!this.isDone) {
                        this.isDone = true;
                        try {
                            this.downstream$2.onError(ex);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        finally {
                            this.timeoutCheck$2.cancel();
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            public void onComplete() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    BoxedUnit boxedUnit;
                    if (!this.isDone) {
                        this.isDone = true;
                        try {
                            this.downstream$2.onComplete();
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        finally {
                            this.timeoutCheck$2.cancel();
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            private final Ack unfreeze$1() {
                this.isProcessingOnNext = false;
                return Ack.Continue$.MODULE$;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{onNext$$anonfun$1(monix.execution.Ack )}, serializedLambda);
            }
        }));
        return composite;
    }
}

