/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.subjects;

import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.ChannelType;
import monix.execution.Scheduler;
import monix.reactive.MulticastStrategy;
import monix.reactive.Observer;
import monix.reactive.OverflowStrategy;
import monix.reactive.observers.BufferedSubscriber$;
import monix.reactive.observers.Subscriber;
import monix.reactive.observers.Subscriber$;
import monix.reactive.subjects.AsyncSubject;
import monix.reactive.subjects.ConcurrentSubject$;
import monix.reactive.subjects.Subject;
import scala.collection.immutable.Seq;

public abstract class ConcurrentSubject<I, O>
extends Subject<I, O>
implements Observer.Sync<I> {
    public static <A> ConcurrentSubject<A, A> apply(MulticastStrategy<A> multicastStrategy, Scheduler scheduler) {
        return ConcurrentSubject$.MODULE$.apply(multicastStrategy, scheduler);
    }

    public static <A> ConcurrentSubject<A, A> apply(MulticastStrategy<A> multicastStrategy, OverflowStrategy.Synchronous<A> synchronous, Scheduler scheduler) {
        return ConcurrentSubject$.MODULE$.apply(multicastStrategy, synchronous, scheduler);
    }

    public static <A> ConcurrentSubject<A, A> async(Scheduler scheduler) {
        return ConcurrentSubject$.MODULE$.async(scheduler);
    }

    public static <I, O> ConcurrentSubject<I, O> from(Subject<I, O> subject, OverflowStrategy.Synchronous<I> synchronous, ChannelType.ProducerSide producerSide, Scheduler scheduler) {
        return ConcurrentSubject$.MODULE$.from(subject, synchronous, producerSide, scheduler);
    }

    public static <A> ConcurrentSubject<A, A> publishToOne(Scheduler scheduler) {
        return ConcurrentSubject$.MODULE$.publishToOne(scheduler);
    }

    public static <A> ConcurrentSubject<A, A> publishToOne(OverflowStrategy.Synchronous<A> synchronous, Scheduler scheduler) {
        return ConcurrentSubject$.MODULE$.publishToOne(synchronous, scheduler);
    }

    public static <A> ConcurrentSubject<A, A> replayLimited(int n, Scheduler scheduler) {
        return ConcurrentSubject$.MODULE$.replayLimited(n, scheduler);
    }

    public static <A> ConcurrentSubject<A, A> replayLimited(int n, Seq<A> seq, Scheduler scheduler) {
        return ConcurrentSubject$.MODULE$.replayLimited(n, seq, scheduler);
    }

    public static <A> ConcurrentSubject<A, A> replayLimited(int n, Seq<A> seq, OverflowStrategy.Synchronous<A> synchronous, Scheduler scheduler) {
        return ConcurrentSubject$.MODULE$.replayLimited(n, seq, synchronous, scheduler);
    }

    public static <A> ConcurrentSubject<A, A> replayLimited(int n, OverflowStrategy.Synchronous<A> synchronous, Scheduler scheduler) {
        return ConcurrentSubject$.MODULE$.replayLimited(n, synchronous, scheduler);
    }

    public static <I, O> ChannelType.ProducerSide from$default$3() {
        return ConcurrentSubject$.MODULE$.from$default$3();
    }

    private static final class ConcurrentAsyncSubject<A>
    extends ConcurrentSubject<A, A> {
        private final AsyncSubject<A> subject;

        public ConcurrentAsyncSubject(AsyncSubject<A> subject) {
            this.subject = subject;
        }

        @Override
        public int size() {
            return this.subject.size();
        }

        @Override
        public Cancelable unsafeSubscribeFn(Subscriber<A> subscriber) {
            return this.subject.unsafeSubscribeFn(subscriber);
        }

        @Override
        public Ack onNext(A elem) {
            Ack ack;
            ConcurrentAsyncSubject concurrentAsyncSubject = this;
            synchronized (concurrentAsyncSubject) {
                ack = this.subject.onNext(elem);
            }
            return ack;
        }

        @Override
        public void onError(Throwable ex) {
            ConcurrentAsyncSubject concurrentAsyncSubject = this;
            synchronized (concurrentAsyncSubject) {
                this.subject.onError(ex);
            }
        }

        @Override
        public void onComplete() {
            ConcurrentAsyncSubject concurrentAsyncSubject = this;
            synchronized (concurrentAsyncSubject) {
                this.subject.onComplete();
            }
        }
    }

    private static final class SubjectAsConcurrent<I, O>
    extends ConcurrentSubject<I, O> {
        private final Subject<I, O> subject;
        private final Subscriber.Sync<I> in;

        public SubjectAsConcurrent(Subject<I, O> subject, OverflowStrategy.Synchronous<I> overflowStrategy, ChannelType.ProducerSide producerType, Scheduler scheduler) {
            this.subject = subject;
            this.in = BufferedSubscriber$.MODULE$.synchronous(Subscriber$.MODULE$.apply(subject, scheduler), (OverflowStrategy.Synchronous)overflowStrategy, producerType);
        }

        @Override
        public int size() {
            return this.subject.size();
        }

        @Override
        public Cancelable unsafeSubscribeFn(Subscriber<O> subscriber) {
            return this.subject.unsafeSubscribeFn(subscriber);
        }

        @Override
        public Ack onNext(I elem) {
            return this.in.onNext(elem);
        }

        @Override
        public void onError(Throwable ex) {
            this.in.onError(ex);
        }

        @Override
        public void onComplete() {
            this.in.onComplete();
        }
    }
}

