/*
 * Decompiled with CFR 0.152.
 */
package monix.execution;

import java.io.Serializable;
import monix.execution.AsyncQueue$;
import monix.execution.BufferCapacity;
import monix.execution.CancelableFuture;
import monix.execution.CancelableFuture$;
import monix.execution.CancelablePromise;
import monix.execution.CancelablePromise$;
import monix.execution.ChannelType;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicAny$;
import monix.execution.atomic.PaddingStrategy$LeftRight128$;
import monix.execution.cancelables.MultiAssignCancelable;
import monix.execution.cancelables.MultiAssignCancelable$;
import monix.execution.internal.Constants$;
import monix.execution.internal.collection.LowLevelConcurrentQueue;
import monix.execution.internal.collection.LowLevelConcurrentQueue$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class AsyncQueue<A> {
    private final Scheduler scheduler;
    private final LowLevelConcurrentQueue<A> queue;
    private final AtomicAny<CancelablePromise<BoxedUnit>> consumersAwaiting;
    private final AtomicAny<CancelablePromise<BoxedUnit>> producersAwaiting;
    private final Function0<A> pollQueue;
    private final Function1<A, Object> pollTest;
    private final Function1<A, A> pollMap;
    private final Function1<Object, Object> offerTest;
    private final Function1<Object, BoxedUnit> offerMap;

    public static <A> AsyncQueue<A> bounded(int n, Scheduler scheduler) {
        return AsyncQueue$.MODULE$.bounded(n, scheduler);
    }

    public static <A> AsyncQueue<A> unbounded(Option<Object> option, Scheduler scheduler) {
        return AsyncQueue$.MODULE$.unbounded(option, scheduler);
    }

    public static <A> AsyncQueue<A> withConfig(BufferCapacity bufferCapacity, ChannelType channelType, Scheduler scheduler) {
        return AsyncQueue$.MODULE$.withConfig(bufferCapacity, channelType, scheduler);
    }

    public static <A> Option<Object> unbounded$default$1() {
        return AsyncQueue$.MODULE$.unbounded$default$1();
    }

    public static <A> FiniteDuration $lessinit$greater$default$3() {
        return AsyncQueue$.MODULE$.$lessinit$greater$default$3();
    }

    public AsyncQueue(BufferCapacity capacity, ChannelType channelType, FiniteDuration retryDelay, Scheduler scheduler) {
        this.scheduler = scheduler;
        this.queue = LowLevelConcurrentQueue$.MODULE$.apply(capacity, channelType, true);
        this.consumersAwaiting = AtomicAny$.MODULE$.withPadding(null, PaddingStrategy$LeftRight128$.MODULE$);
        this.producersAwaiting = capacity.isBounded() ? AtomicAny$.MODULE$.withPadding(null, PaddingStrategy$LeftRight128$.MODULE$) : null;
        this.pollQueue = (Function0 & Serializable)() -> this.tryPollUnsafe();
        this.pollTest = (Function1 & Serializable)_$4 -> _$4 != null;
        this.pollMap = (Function1 & Serializable)a -> a;
        this.offerTest = (Function1 & Serializable)x -> BoxesRunTime.unboxToBoolean((Object)x);
        this.offerMap = (Function1 & Serializable)v1 -> {
            AsyncQueue.$init$$$anonfun$5(BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        };
    }

    public boolean tryOffer(A a) {
        return this.tryOfferUnsafe(a);
    }

    public Option<A> tryPoll() {
        return Option$.MODULE$.apply(this.tryPollUnsafe());
    }

    public CancelableFuture<A> poll() {
        CancelableFuture<A> cancelableFuture;
        A happy = this.tryPollUnsafe();
        if (happy != null) {
            cancelableFuture = CancelableFuture$.MODULE$.successful(happy);
        } else {
            Promise p = Promise$.MODULE$.apply();
            MultiAssignCancelable c = MultiAssignCancelable$.MODULE$.apply();
            this.sleepThenRepeat(this.consumersAwaiting, this.pollQueue, this.pollTest, this.pollMap, p, c);
            cancelableFuture = CancelableFuture$.MODULE$.apply(p.future(), c);
        }
        return cancelableFuture;
    }

    public CancelableFuture<BoxedUnit> offer(A a) {
        boolean happy = this.tryOfferUnsafe(a);
        return happy ? CancelableFuture$.MODULE$.unit() : this.offerWait(a, MultiAssignCancelable$.MODULE$.apply());
    }

    public CancelableFuture<BoxedUnit> offerMany(Iterable<A> seq) {
        return this.loop$1(seq.iterator(), null);
    }

    public CancelableFuture<Seq<A>> drain(int minLength, int maxLength) {
        CancelableFuture<Object> cancelableFuture;
        if (minLength > maxLength) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(27).append("minLength (").append(minLength).append(") <= maxLength (").append(maxLength).toString());
        }
        ArrayBuffer buffer = ArrayBuffer$.MODULE$.empty();
        int length = this.tryDrainUnsafe(buffer, maxLength);
        if (length >= minLength) {
            cancelableFuture = CancelableFuture$.MODULE$.successful(this.toSeq(buffer));
        } else {
            Promise promise = Promise$.MODULE$.apply();
            MultiAssignCancelable conn = MultiAssignCancelable$.MODULE$.apply();
            this.sleepThenRepeat(this.consumersAwaiting, (Function0)(Function0 & Serializable)() -> this.tryDrainUnsafe(buffer, maxLength - buffer.length()), (Function1)(JFunction1.mcZI.sp & Serializable)_$2 -> buffer.length() >= minLength, (Function1)(Function1 & Serializable)_$3 -> this.drain$$anonfun$3(buffer, BoxesRunTime.unboxToInt((Object)_$3)), (Promise)promise, conn);
            cancelableFuture = CancelableFuture$.MODULE$.apply(promise.future(), conn);
        }
        return cancelableFuture;
    }

    public void clear() {
        this.queue.clear();
        this.notifyProducers();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    private boolean tryOfferUnsafe(A a) {
        boolean bl;
        if (this.queue.offer(a) == 0) {
            this.notifyConsumers();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private A tryPollUnsafe() {
        void var1_1;
        A a = this.queue.poll();
        this.notifyProducers();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int tryDrainUnsafe(ArrayBuffer<A> buffer, int maxLength) {
        void var3_3;
        int length = this.queue.drainToBuffer((Buffer<A>)buffer, maxLength);
        if (length > 0) {
            this.notifyProducers();
        }
        return (int)var3_3;
    }

    private void notifyConsumers() {
        AsyncQueue asyncQueue = this;
        while (true) {
            asyncQueue.queue.fenceOffer();
            CancelablePromise<BoxedUnit> ref = asyncQueue.consumersAwaiting.get();
            if (ref == null) break;
            if (!asyncQueue.consumersAwaiting.compareAndSet(ref, null)) continue;
            ref.complete(Constants$.MODULE$.successOfUnit());
            break;
        }
    }

    private void notifyProducers() {
        AsyncQueue asyncQueue = this;
        while (asyncQueue.producersAwaiting != null) {
            asyncQueue.queue.fencePoll();
            CancelablePromise<BoxedUnit> ref = asyncQueue.producersAwaiting.get();
            if (ref == null) break;
            if (!asyncQueue.producersAwaiting.compareAndSet(ref, null)) continue;
            ref.complete(Constants$.MODULE$.successOfUnit());
            break;
        }
    }

    private CancelableFuture<BoxedUnit> offerWait(A a, MultiAssignCancelable c) {
        Promise p = Promise$.MODULE$.apply();
        this.sleepThenRepeat(this.producersAwaiting, (Function0 & Serializable)() -> this.tryOfferUnsafe(a), this.offerTest, this.offerMap, p, c);
        return CancelableFuture$.MODULE$.apply(p.future(), c);
    }

    private Seq<A> toSeq(ArrayBuffer<A> buffer) {
        Object object = Predef$.MODULE$.genericArrayOps(buffer.toArray(ClassTag$.MODULE$.Any()));
        return ArrayOps$.MODULE$.toSeq$extension(object);
    }

    private <T, U> void sleepThenRepeat(AtomicAny<CancelablePromise<BoxedUnit>> state, Function0<T> f, Function1<T, Object> filter, Function1<T, U> map, Promise<U> cb, MultiAssignCancelable token) {
        block1: {
            CancelablePromise<BoxedUnit> cancelablePromise;
            AsyncQueue asyncQueue = this;
            while ((cancelablePromise = state.get()) == null) {
                CancelablePromise<BoxedUnit> ref = CancelablePromise$.MODULE$.apply(CancelablePromise$.MODULE$.apply$default$1());
                if (!state.compareAndSet(null, ref)) continue;
                asyncQueue.sleepThenRepeat_Step2TryAgainThenSleep(state, f, filter, map, cb, token, ref);
                break block1;
            }
            CancelablePromise<BoxedUnit> ref = cancelablePromise;
            asyncQueue.sleepThenRepeat_Step2TryAgainThenSleep(state, f, filter, map, cb, token, ref);
        }
    }

    private <T, U> void sleepThenRepeat_Step2TryAgainThenSleep(AtomicAny<CancelablePromise<BoxedUnit>> state, Function0<T> f, Function1<T, Object> filter, Function1<T, U> map, Promise<U> cb, MultiAssignCancelable token, CancelablePromise<BoxedUnit> p) {
        this.scheduler.execute(() -> {
            Object value = f.apply();
            if (BoxesRunTime.unboxToBoolean((Object)filter.apply(value))) {
                cb.success(map.apply(value));
            } else {
                token.$colon$eq(p.subscribe((JProcedure1 & Serializable)_$6 -> this.sleepThenRepeat_Step3Awaken(state, f, filter, map, cb, token)));
            }
        });
    }

    private <T, U> void sleepThenRepeat_Step3Awaken(AtomicAny<CancelablePromise<BoxedUnit>> state, Function0<T> f, Function1<T, Object> filter, Function1<T, U> map, Promise<U> cb, MultiAssignCancelable token) {
        Object value = f.apply();
        if (BoxesRunTime.unboxToBoolean((Object)filter.apply(value))) {
            cb.success(map.apply(value));
        } else {
            this.sleepThenRepeat(state, f, filter, map, cb, token);
        }
    }

    private static final /* synthetic */ void $init$$$anonfun$5(boolean _$5) {
    }

    private final CancelableFuture loop$1(Iterator cursor, MultiAssignCancelable c) {
        Future future;
        Object elem = null;
        boolean hasCapacity = true;
        while (hasCapacity && cursor.hasNext()) {
            elem = cursor.next();
            hasCapacity = this.queue.offer(elem) == 0;
        }
        this.notifyConsumers();
        if (!hasCapacity) {
            MultiAssignCancelable c2 = c != null ? c : MultiAssignCancelable$.MODULE$.apply();
            future = this.offerWait(elem, c2).flatMap((Function1 & Serializable)_$1 -> this.loop$1(cursor, c2), (ExecutionContext)this.scheduler);
        } else {
            future = CancelableFuture$.MODULE$.unit();
        }
        return future;
    }

    private final /* synthetic */ Seq drain$$anonfun$3(ArrayBuffer buffer$3, int _$3) {
        return this.toSeq(buffer$3);
    }
}

