/*
 * Decompiled with CFR 0.152.
 */
package monix.execution;

import java.io.Serializable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicAny$;
import monix.execution.schedulers.TrampolinedRunnable;
import scala.Function0;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.concurrent.Promise;
import scala.runtime.BoxedUnit;

public interface Cancelable
extends Serializable {
    public static Cancelable apply() {
        return Cancelable$.MODULE$.apply();
    }

    public static Cancelable apply(Function0<BoxedUnit> function0) {
        return Cancelable$.MODULE$.apply(function0);
    }

    public static void cancelAll(Iterable<Cancelable> iterable) {
        Cancelable$.MODULE$.cancelAll(iterable);
    }

    public static Cancelable collection(Iterable<Cancelable> iterable) {
        return Cancelable$.MODULE$.collection(iterable);
    }

    public static Cancelable collection(Seq<Cancelable> seq) {
        return Cancelable$.MODULE$.collection(seq);
    }

    public static Cancelable empty() {
        return Cancelable$.MODULE$.empty();
    }

    public static <A> Cancelable fromPromise(Promise<A> promise, Throwable throwable) {
        return Cancelable$.MODULE$.fromPromise(promise, throwable);
    }

    public static Cancelable trampolined(Iterable<Cancelable> iterable, Scheduler scheduler) {
        return Cancelable$.MODULE$.trampolined(iterable, scheduler);
    }

    public static Cancelable trampolined(Seq<Cancelable> seq, Scheduler scheduler) {
        return Cancelable$.MODULE$.trampolined(seq, scheduler);
    }

    public void cancel();

    private static final class CancelableTask
    implements Cancelable {
        private final AtomicAny<Function0<BoxedUnit>> callbackRef;

        public CancelableTask(Function0<BoxedUnit> cb) {
            this.callbackRef = AtomicAny$.MODULE$.apply(cb);
        }

        @Override
        public void cancel() {
            Function0 callback = this.callbackRef.getAndSet(null);
            if (callback != null) {
                callback.apply$mcV$sp();
            }
        }
    }

    private static final class CollectionTrampolined
    implements Cancelable,
    TrampolinedRunnable {
        private final Scheduler sc;
        private final AtomicAny<Iterable<Cancelable>> atomic;

        public CollectionTrampolined(Iterable<Cancelable> refs, Scheduler sc) {
            this.sc = sc;
            this.atomic = AtomicAny$.MODULE$.apply(refs);
        }

        @Override
        public void cancel() {
            this.sc.execute(this);
        }

        @Override
        public void run() {
            Iterable refs = this.atomic.getAndSet(null);
            if (refs != null) {
                Cancelable$.MODULE$.cancelAll((Iterable<Cancelable>)refs);
            }
        }
    }

    public static interface Empty
    extends Cancelable,
    IsDummy {
    }

    public static interface IsDummy {
    }
}

