/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.atomic;

import monix.execution.atomic.AtomicDouble$;
import monix.execution.atomic.AtomicNumber;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.internal.atomic.BoxedLong;

public final class AtomicDouble
extends AtomicNumber<Object> {
    private final BoxedLong ref;

    public static AtomicDouble apply(double d) {
        return AtomicDouble$.MODULE$.apply(d);
    }

    public static AtomicDouble create(double d, PaddingStrategy paddingStrategy, boolean bl) {
        return AtomicDouble$.MODULE$.create(d, paddingStrategy, bl);
    }

    public static AtomicDouble safe(double d, PaddingStrategy paddingStrategy) {
        return AtomicDouble$.MODULE$.safe(d, paddingStrategy);
    }

    public static AtomicDouble withPadding(double d, PaddingStrategy paddingStrategy) {
        return AtomicDouble$.MODULE$.withPadding(d, paddingStrategy);
    }

    public AtomicDouble(BoxedLong ref) {
        this.ref = ref;
    }

    public BoxedLong ref() {
        return this.ref;
    }

    @Override
    public double get() {
        return Double.longBitsToDouble(this.ref().volatileGet());
    }

    @Override
    public void set(double update) {
        this.ref().volatileSet(Double.doubleToLongBits(update));
    }

    @Override
    public void lazySet(double update) {
        this.ref().lazySet(Double.doubleToLongBits(update));
    }

    @Override
    public boolean compareAndSet(double expect, double update) {
        long expectLong = Double.doubleToLongBits(expect);
        long updateLong = Double.doubleToLongBits(update);
        return this.ref().compareAndSet(expectLong, updateLong);
    }

    @Override
    public double getAndSet(double update) {
        return Double.longBitsToDouble(this.ref().getAndSet(Double.doubleToLongBits(update)));
    }

    @Override
    public void increment(int v) {
        double update;
        double current;
        AtomicDouble atomicDouble = this;
        while (!atomicDouble.compareAndSet(current = atomicDouble.get(), update = atomicDouble.incrementOp(current, v))) {
        }
    }

    @Override
    public int increment$default$1() {
        return 1;
    }

    @Override
    public void add(double v) {
        double update;
        double current;
        AtomicDouble atomicDouble = this;
        while (!atomicDouble.compareAndSet(current = atomicDouble.get(), update = atomicDouble.plusOp(current, v))) {
        }
    }

    @Override
    public double incrementAndGet(int v) {
        double update;
        double current;
        AtomicDouble atomicDouble = this;
        while (!atomicDouble.compareAndSet(current = atomicDouble.get(), update = atomicDouble.incrementOp(current, v))) {
        }
        return update;
    }

    @Override
    public int incrementAndGet$default$1() {
        return 1;
    }

    @Override
    public double addAndGet(double v) {
        double update;
        double current;
        AtomicDouble atomicDouble = this;
        while (!atomicDouble.compareAndSet(current = atomicDouble.get(), update = atomicDouble.plusOp(current, v))) {
        }
        return update;
    }

    @Override
    public double getAndIncrement(int v) {
        double update;
        double current;
        AtomicDouble atomicDouble = this;
        while (!atomicDouble.compareAndSet(current = atomicDouble.get(), update = atomicDouble.incrementOp(current, v))) {
        }
        return current;
    }

    @Override
    public int getAndIncrement$default$1() {
        return 1;
    }

    @Override
    public double getAndAdd(double v) {
        double update;
        double current;
        AtomicDouble atomicDouble = this;
        while (!atomicDouble.compareAndSet(current = atomicDouble.get(), update = atomicDouble.plusOp(current, v))) {
        }
        return current;
    }

    @Override
    public void subtract(double v) {
        double update;
        double current;
        AtomicDouble atomicDouble = this;
        while (!atomicDouble.compareAndSet(current = atomicDouble.get(), update = atomicDouble.minusOp(current, v))) {
        }
    }

    @Override
    public double subtractAndGet(double v) {
        double update;
        double current;
        AtomicDouble atomicDouble = this;
        while (!atomicDouble.compareAndSet(current = atomicDouble.get(), update = atomicDouble.minusOp(current, v))) {
        }
        return update;
    }

    @Override
    public double getAndSubtract(double v) {
        double update;
        double current;
        AtomicDouble atomicDouble = this;
        while (!atomicDouble.compareAndSet(current = atomicDouble.get(), update = atomicDouble.minusOp(current, v))) {
        }
        return current;
    }

    @Override
    public void decrement(int v) {
        this.increment(-v);
    }

    @Override
    public int decrement$default$1() {
        return 1;
    }

    @Override
    public double decrementAndGet(int v) {
        return this.incrementAndGet(-v);
    }

    @Override
    public int decrementAndGet$default$1() {
        return 1;
    }

    @Override
    public double getAndDecrement(int v) {
        return this.getAndIncrement(-v);
    }

    @Override
    public int getAndDecrement$default$1() {
        return 1;
    }

    private double plusOp(double a, double b) {
        return a + b;
    }

    private double minusOp(double a, double b) {
        return a - b;
    }

    private double incrementOp(double a, int b) {
        return a + (double)b;
    }
}

